/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.common;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.util.HashCodeUtil;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class BytesRange {
    public static final int TO_END_OF_CONTENT = Integer.MAX_VALUE;
    @Nullable
    private static Pattern sHeaderParsingRegEx;
    public final int from;
    public final int to;

    public BytesRange(int from, int to) {
        this.from = from;
        this.to = to;
    }

    public String toHttpRangeHeaderValue() {
        return String.format((Locale)null, "bytes=%s-%s", BytesRange.valueOrEmpty(this.from), BytesRange.valueOrEmpty(this.to));
    }

    public boolean contains(@Nullable BytesRange compare) {
        if (compare == null) {
            return false;
        }
        return this.from <= compare.from && this.to >= compare.to;
    }

    public String toString() {
        return String.format((Locale)null, "%s-%s", BytesRange.valueOrEmpty(this.from), BytesRange.valueOrEmpty(this.to));
    }

    private static String valueOrEmpty(int n) {
        if (n == Integer.MAX_VALUE) {
            return "";
        }
        return Integer.toString(n);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BytesRange)) {
            return false;
        }
        BytesRange that = (BytesRange)other;
        return this.from == that.from && this.to == that.to;
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)this.from, (int)this.to);
    }

    public static BytesRange from(int from) {
        Preconditions.checkArgument((from >= 0 ? 1 : 0) != 0);
        return new BytesRange(from, Integer.MAX_VALUE);
    }

    public static BytesRange toMax(int to) {
        Preconditions.checkArgument((to > 0 ? 1 : 0) != 0);
        return new BytesRange(0, to);
    }

    @Nullable
    public static BytesRange fromContentRangeHeader(@Nullable String header) throws IllegalArgumentException {
        if (header == null) {
            return null;
        }
        if (sHeaderParsingRegEx == null) {
            sHeaderParsingRegEx = Pattern.compile("[-/ ]");
        }
        try {
            String[] headerParts = sHeaderParsingRegEx.split(header);
            Preconditions.checkArgument((headerParts.length == 4 ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)headerParts[0].equals("bytes"));
            int from = Integer.parseInt(headerParts[1]);
            int to = Integer.parseInt(headerParts[2]);
            int length = Integer.parseInt(headerParts[3]);
            Preconditions.checkArgument((to > from ? 1 : 0) != 0);
            Preconditions.checkArgument((length > to ? 1 : 0) != 0);
            if (to < length - 1) {
                return new BytesRange(from, to);
            }
            return new BytesRange(from, Integer.MAX_VALUE);
        }
        catch (IllegalArgumentException x) {
            throw new IllegalArgumentException(String.format((Locale)null, "Invalid Content-Range header value: \"%s\"", header), x);
        }
    }
}

