/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.image;

import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.image.CloseableBitmap;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imageutils.BitmapUtil;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CloseableStaticBitmap
extends CloseableBitmap {
    @GuardedBy(value="this")
    private CloseableReference<Bitmap> mBitmapReference;
    private volatile Bitmap mBitmap;
    private final QualityInfo mQualityInfo;
    private final int mRotationAngle;
    private final int mExifOrientation;

    public CloseableStaticBitmap(Bitmap bitmap, ResourceReleaser<Bitmap> resourceReleaser, QualityInfo qualityInfo, int rotationAngle) {
        this(bitmap, resourceReleaser, qualityInfo, rotationAngle, 0);
    }

    public CloseableStaticBitmap(Bitmap bitmap, ResourceReleaser<Bitmap> resourceReleaser, QualityInfo qualityInfo, int rotationAngle, int exifOrientation) {
        this.mBitmap = (Bitmap)Preconditions.checkNotNull((Object)bitmap);
        this.mBitmapReference = CloseableReference.of((Object)this.mBitmap, (ResourceReleaser)((ResourceReleaser)Preconditions.checkNotNull(resourceReleaser)));
        this.mQualityInfo = qualityInfo;
        this.mRotationAngle = rotationAngle;
        this.mExifOrientation = exifOrientation;
    }

    public CloseableStaticBitmap(CloseableReference<Bitmap> bitmapReference, QualityInfo qualityInfo, int rotationAngle) {
        this(bitmapReference, qualityInfo, rotationAngle, 0);
    }

    public CloseableStaticBitmap(CloseableReference<Bitmap> bitmapReference, QualityInfo qualityInfo, int rotationAngle, int exifOrientation) {
        this.mBitmapReference = (CloseableReference)Preconditions.checkNotNull((Object)bitmapReference.cloneOrNull());
        this.mBitmap = (Bitmap)this.mBitmapReference.get();
        this.mQualityInfo = qualityInfo;
        this.mRotationAngle = rotationAngle;
        this.mExifOrientation = exifOrientation;
    }

    @Override
    public void close() {
        CloseableReference<Bitmap> reference = this.detachBitmapReference();
        if (reference != null) {
            reference.close();
        }
    }

    private synchronized CloseableReference<Bitmap> detachBitmapReference() {
        CloseableReference<Bitmap> reference = this.mBitmapReference;
        this.mBitmapReference = null;
        this.mBitmap = null;
        return reference;
    }

    public synchronized CloseableReference<Bitmap> convertToBitmapReference() {
        Preconditions.checkNotNull(this.mBitmapReference, (Object)"Cannot convert a closed static bitmap");
        return this.detachBitmapReference();
    }

    @Nullable
    public synchronized CloseableReference<Bitmap> cloneUnderlyingBitmapReference() {
        return CloseableReference.cloneOrNull(this.mBitmapReference);
    }

    @Override
    public synchronized boolean isClosed() {
        return this.mBitmapReference == null;
    }

    @Override
    public Bitmap getUnderlyingBitmap() {
        return this.mBitmap;
    }

    @Override
    public int getSizeInBytes() {
        return BitmapUtil.getSizeInBytes(this.mBitmap);
    }

    @Override
    public int getWidth() {
        if (this.mRotationAngle % 180 != 0 || this.mExifOrientation == 5 || this.mExifOrientation == 7) {
            return CloseableStaticBitmap.getBitmapHeight(this.mBitmap);
        }
        return CloseableStaticBitmap.getBitmapWidth(this.mBitmap);
    }

    @Override
    public int getHeight() {
        if (this.mRotationAngle % 180 != 0 || this.mExifOrientation == 5 || this.mExifOrientation == 7) {
            return CloseableStaticBitmap.getBitmapWidth(this.mBitmap);
        }
        return CloseableStaticBitmap.getBitmapHeight(this.mBitmap);
    }

    private static int getBitmapWidth(@Nullable Bitmap bitmap) {
        return bitmap == null ? 0 : bitmap.getWidth();
    }

    private static int getBitmapHeight(@Nullable Bitmap bitmap) {
        return bitmap == null ? 0 : bitmap.getHeight();
    }

    public int getRotationAngle() {
        return this.mRotationAngle;
    }

    public int getExifOrientation() {
        return this.mExifOrientation;
    }

    @Override
    public QualityInfo getQualityInfo() {
        return this.mQualityInfo;
    }
}

