/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import android.graphics.Bitmap;
import com.facebook.common.internal.Supplier;
import com.facebook.common.memory.MemoryTrimType;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.AnimationFrames;
import com.facebook.imagepipeline.cache.LruCountingMemoryCache;
import com.facebook.imagepipeline.cache.MemoryCacheParams;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\tJ0\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u000e0\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/facebook/imagepipeline/cache/AnimatedCache;", "", "memoryMB", "", "(I)V", "evictionRatio", "", "lruCache", "Lcom/facebook/imagepipeline/cache/LruCountingMemoryCache;", "", "Lcom/facebook/imagepipeline/cache/AnimationFrames;", "maxCacheEntrySize", "sizeBytes", "findAnimation", "Lcom/facebook/common/references/CloseableReference;", "key", "getSize", "removeAnimation", "", "saveAnimation", "newFrames", "", "Landroid/graphics/Bitmap;", "Companion", "imagepipeline-base_release"})
public final class AnimatedCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int sizeBytes;
    private final float evictionRatio;
    private final int maxCacheEntrySize;
    @NotNull
    private final LruCountingMemoryCache<String, AnimationFrames> lruCache;
    private static final int EVICTION_QUEUE = 50;
    @Nullable
    private static AnimatedCache instance;

    private AnimatedCache(int memoryMB) {
        this.sizeBytes = memoryMB * 0x100000;
        this.evictionRatio = memoryMB < 90 ? 0.15f : 0.3f;
        this.maxCacheEntrySize = (int)((double)this.sizeBytes * 0.1);
        this.lruCache = new LruCountingMemoryCache(AnimatedCache::lruCache$lambda$0, AnimatedCache::lruCache$lambda$1, (Supplier<MemoryCacheParams>)((Supplier)() -> AnimatedCache.lruCache$lambda$2(this)), null, false, false);
    }

    public final int getSize(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.lruCache.getSizeInBytes();
    }

    @Nullable
    public final CloseableReference<AnimationFrames> findAnimation(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.lruCache.get(key);
    }

    @Nullable
    public final CloseableReference<AnimationFrames> saveAnimation(@NotNull String key, @NotNull Map<Integer, ? extends CloseableReference<Bitmap>> newFrames) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(newFrames, (String)"newFrames");
        return this.lruCache.cache(key, (CloseableReference<AnimationFrames>)CloseableReference.of((Closeable)new AnimationFrames(newFrames)));
    }

    public final void removeAnimation(@NotNull String key) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            CloseableReference<AnimationFrames> closeableReference = this.lruCache.get(key);
            if (closeableReference == null) break block0;
            closeableReference.close();
        }
    }

    private static final int lruCache$lambda$0(AnimationFrames it) {
        return it.getSizeBytes();
    }

    private static final double lruCache$lambda$1(MemoryTrimType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSuggestedTrimRatio();
    }

    private static final MemoryCacheParams lruCache$lambda$2(AnimatedCache this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new MemoryCacheParams(this$0.sizeBytes, Integer.MAX_VALUE, (int)((float)this$0.sizeBytes * this$0.evictionRatio), 50, this$0.maxCacheEntrySize, TimeUnit.SECONDS.toMillis(5L));
    }

    @JvmStatic
    @NotNull
    public static final AnimatedCache getInstance(int memoryMB) {
        return Companion.getInstance(memoryMB);
    }

    public /* synthetic */ AnimatedCache(int memoryMB, DefaultConstructorMarker $constructor_marker) {
        this(memoryMB);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/facebook/imagepipeline/cache/AnimatedCache$Companion;", "", "()V", "EVICTION_QUEUE", "", "instance", "Lcom/facebook/imagepipeline/cache/AnimatedCache;", "getInstance", "memoryMB", "imagepipeline-base_release"})
    @SourceDebugExtension(value={"SMAP\nAnimatedCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimatedCache.kt\ncom/facebook/imagepipeline/cache/AnimatedCache$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AnimatedCache getInstance(int memoryMB) {
            AnimatedCache animatedCache = instance;
            if (animatedCache == null) {
                AnimatedCache animatedCache2;
                AnimatedCache it = animatedCache2 = new AnimatedCache(memoryMB, null);
                boolean bl = false;
                instance = it;
                animatedCache = animatedCache2;
            }
            return animatedCache;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

