/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.testing;

import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.imageutils.BitmapUtil;
import org.mockito.Mockito;

public class MockBitmapFactory {
    public static int DEFAULT_BITMAP_WIDTH = 3;
    public static int DEFAULT_BITMAP_HEIGHT = 4;
    public static int DEFAULT_BITMAP_PIXELS = DEFAULT_BITMAP_WIDTH * DEFAULT_BITMAP_HEIGHT;
    public static int DEFAULT_BITMAP_SIZE = MockBitmapFactory.bitmapSize(DEFAULT_BITMAP_WIDTH, DEFAULT_BITMAP_HEIGHT, Bitmap.Config.ARGB_8888);

    public static Bitmap create() {
        return MockBitmapFactory.create(DEFAULT_BITMAP_WIDTH, DEFAULT_BITMAP_HEIGHT, Bitmap.Config.ARGB_8888);
    }

    public static Bitmap createForSize(int size, Bitmap.Config config) {
        Preconditions.checkArgument((size % BitmapUtil.getPixelSizeForBitmapConfig((Bitmap.Config)config) == 0 ? 1 : 0) != 0);
        return MockBitmapFactory.create(1, size / BitmapUtil.getPixelSizeForBitmapConfig((Bitmap.Config)config), config);
    }

    public static Bitmap create(int width, int height, Bitmap.Config config) {
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)config);
        Bitmap bitmap = (Bitmap)Mockito.mock(Bitmap.class);
        Mockito.when((Object)bitmap.getWidth()).thenReturn((Object)width);
        Mockito.when((Object)bitmap.getHeight()).thenReturn((Object)height);
        Mockito.when((Object)bitmap.getConfig()).thenReturn((Object)config);
        Mockito.when((Object)bitmap.isMutable()).thenReturn((Object)true);
        Mockito.when((Object)bitmap.getRowBytes()).thenReturn((Object)(width * BitmapUtil.getPixelSizeForBitmapConfig((Bitmap.Config)config)));
        Mockito.when((Object)bitmap.getByteCount()).thenReturn((Object)MockBitmapFactory.bitmapSize(width, height, config));
        return bitmap;
    }

    public static int bitmapSize(int width, int height, Bitmap.Config config) {
        return BitmapUtil.getSizeInByteForBitmap((int)width, (int)height, (Bitmap.Config)config);
    }
}

