/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.platform;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.MemoryFile;
import com.facebook.common.internal.ByteStreams;
import com.facebook.common.internal.Closeables;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Throwables;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.streams.LimitedInputStream;
import com.facebook.common.webp.WebpSupportStatus;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferInputStream;
import com.facebook.imagepipeline.platform.DalvikPurgeableDecoder;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

public class GingerbreadPurgeableDecoder
extends DalvikPurgeableDecoder {
    private static Method sGetFileDescriptorMethod;
    private final boolean mWebpSupportEnabled;

    public GingerbreadPurgeableDecoder(boolean webpSupportEnabled) {
        this.mWebpSupportEnabled = webpSupportEnabled;
    }

    @Override
    protected Bitmap decodeByteArrayAsPurgeable(CloseableReference<PooledByteBuffer> bytesRef, BitmapFactory.Options options) {
        return this.decodeFileDescriptorAsPurgeable(bytesRef, ((PooledByteBuffer)bytesRef.get()).size(), null, options);
    }

    @Override
    protected Bitmap decodeJPEGByteArrayAsPurgeable(CloseableReference<PooledByteBuffer> bytesRef, int length, BitmapFactory.Options options) {
        byte[] suffix = GingerbreadPurgeableDecoder.endsWithEOI(bytesRef, length) ? null : EOI;
        return this.decodeFileDescriptorAsPurgeable(bytesRef, length, suffix, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MemoryFile copyToMemoryFile(CloseableReference<PooledByteBuffer> bytesRef, int inputLength, @Nullable byte[] suffix) throws IOException {
        MemoryFile memoryFile;
        int outputLength = inputLength + (suffix == null ? 0 : suffix.length);
        MemoryFile memoryFile2 = new MemoryFile(null, outputLength);
        memoryFile2.allowPurging(false);
        PooledByteBufferInputStream pbbIs = null;
        LimitedInputStream is = null;
        OutputStream os = null;
        try {
            pbbIs = new PooledByteBufferInputStream((PooledByteBuffer)bytesRef.get());
            is = new LimitedInputStream((InputStream)pbbIs, inputLength);
            os = memoryFile2.getOutputStream();
            ByteStreams.copy((InputStream)is, (OutputStream)os);
            if (suffix != null) {
                memoryFile2.writeBytes(suffix, 0, inputLength, suffix.length);
            }
            memoryFile = memoryFile2;
        }
        catch (Throwable throwable) {
            CloseableReference.closeSafely(bytesRef);
            Closeables.closeQuietly(pbbIs);
            Closeables.closeQuietly(is);
            Closeables.close(os, (boolean)true);
            throw throwable;
        }
        CloseableReference.closeSafely(bytesRef);
        Closeables.closeQuietly((InputStream)pbbIs);
        Closeables.closeQuietly((InputStream)is);
        Closeables.close((Closeable)os, (boolean)true);
        return memoryFile;
    }

    private synchronized Method getFileDescriptorMethod() {
        if (sGetFileDescriptorMethod == null) {
            try {
                sGetFileDescriptorMethod = MemoryFile.class.getDeclaredMethod("getFileDescriptor", new Class[0]);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return sGetFileDescriptorMethod;
    }

    private FileDescriptor getMemoryFileDescriptor(MemoryFile memoryFile) {
        try {
            Object rawFD = this.getFileDescriptorMethod().invoke((Object)memoryFile, new Object[0]);
            return (FileDescriptor)rawFD;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected Bitmap decodeFileDescriptorAsPurgeable(CloseableReference<PooledByteBuffer> bytesRef, int inputLength, byte[] suffix, BitmapFactory.Options options) {
        try (MemoryFile memoryFile = null;){
            memoryFile = GingerbreadPurgeableDecoder.copyToMemoryFile(bytesRef, inputLength, suffix);
            FileDescriptor fd = this.getMemoryFileDescriptor(memoryFile);
            Bitmap bitmap = this.mWebpSupportEnabled ? WebpSupportStatus.sWebpBitmapFactory.decodeFileDescriptor(fd, null, options) : BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
            Bitmap bitmap2 = (Bitmap)Preconditions.checkNotNull((Object)bitmap, (Object)"BitmapFactory returned null");
            return bitmap2;
        }
    }
}

