/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import android.net.Uri;
import bolts.Continuation;
import bolts.Task;
import com.android.internal.util.Predicate;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Supplier;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.UriUtil;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSources;
import com.facebook.datasource.SimpleDataSource;
import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.core.ProducerSequenceFactory;
import com.facebook.imagepipeline.datasource.CloseableProducerToDataSourceAdapter;
import com.facebook.imagepipeline.datasource.ProducerToDataSourceAdapter;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.listener.ForwardingRequestListener;
import com.facebook.imagepipeline.listener.RequestListener;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.SettableProducerContext;
import com.facebook.imagepipeline.producers.ThreadHandoffProducerQueue;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ImagePipeline {
    private static final CancellationException PREFETCH_EXCEPTION = new CancellationException("Prefetching is not enabled");
    private final ProducerSequenceFactory mProducerSequenceFactory;
    private final RequestListener mRequestListener;
    private final Supplier<Boolean> mIsPrefetchEnabledSupplier;
    private final MemoryCache<CacheKey, CloseableImage> mBitmapMemoryCache;
    private final MemoryCache<CacheKey, PooledByteBuffer> mEncodedMemoryCache;
    private final BufferedDiskCache mMainBufferedDiskCache;
    private final BufferedDiskCache mSmallImageBufferedDiskCache;
    private final CacheKeyFactory mCacheKeyFactory;
    private final ThreadHandoffProducerQueue mThreadHandoffProducerQueue;
    private final Supplier<Boolean> mSuppressBitmapPrefetchingSupplier;
    private AtomicLong mIdCounter = new AtomicLong();

    public ImagePipeline(ProducerSequenceFactory producerSequenceFactory, Set<RequestListener> requestListeners, Supplier<Boolean> isPrefetchEnabledSupplier, MemoryCache<CacheKey, CloseableImage> bitmapMemoryCache, MemoryCache<CacheKey, PooledByteBuffer> encodedMemoryCache, BufferedDiskCache mainBufferedDiskCache, BufferedDiskCache smallImageBufferedDiskCache, CacheKeyFactory cacheKeyFactory, ThreadHandoffProducerQueue threadHandoffProducerQueue, Supplier<Boolean> suppressBitmapPrefetchingSupplier) {
        this.mProducerSequenceFactory = producerSequenceFactory;
        this.mRequestListener = new ForwardingRequestListener(requestListeners);
        this.mIsPrefetchEnabledSupplier = isPrefetchEnabledSupplier;
        this.mBitmapMemoryCache = bitmapMemoryCache;
        this.mEncodedMemoryCache = encodedMemoryCache;
        this.mMainBufferedDiskCache = mainBufferedDiskCache;
        this.mSmallImageBufferedDiskCache = smallImageBufferedDiskCache;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mThreadHandoffProducerQueue = threadHandoffProducerQueue;
        this.mSuppressBitmapPrefetchingSupplier = suppressBitmapPrefetchingSupplier;
    }

    private String generateUniqueFutureId() {
        return String.valueOf(this.mIdCounter.getAndIncrement());
    }

    @Deprecated
    public Supplier<DataSource<CloseableReference<CloseableImage>>> getDataSourceSupplier(ImageRequest imageRequest, Object callerContext, boolean bitmapCacheOnly) {
        ImageRequest.RequestLevel requestLevel = bitmapCacheOnly ? ImageRequest.RequestLevel.BITMAP_MEMORY_CACHE : ImageRequest.RequestLevel.FULL_FETCH;
        return this.getDataSourceSupplier(imageRequest, callerContext, requestLevel);
    }

    public Supplier<DataSource<CloseableReference<CloseableImage>>> getDataSourceSupplier(final ImageRequest imageRequest, final Object callerContext, final ImageRequest.RequestLevel requestLevel) {
        return new Supplier<DataSource<CloseableReference<CloseableImage>>>(){

            public DataSource<CloseableReference<CloseableImage>> get() {
                return ImagePipeline.this.fetchDecodedImage(imageRequest, callerContext, requestLevel);
            }

            public String toString() {
                return Objects.toStringHelper((Object)this).add("uri", (Object)imageRequest.getSourceUri()).toString();
            }
        };
    }

    public Supplier<DataSource<CloseableReference<PooledByteBuffer>>> getEncodedImageDataSourceSupplier(final ImageRequest imageRequest, final Object callerContext) {
        return new Supplier<DataSource<CloseableReference<PooledByteBuffer>>>(){

            public DataSource<CloseableReference<PooledByteBuffer>> get() {
                return ImagePipeline.this.fetchEncodedImage(imageRequest, callerContext);
            }

            public String toString() {
                return Objects.toStringHelper((Object)this).add("uri", (Object)imageRequest.getSourceUri()).toString();
            }
        };
    }

    public DataSource<CloseableReference<CloseableImage>> fetchImageFromBitmapCache(ImageRequest imageRequest, Object callerContext) {
        return this.fetchDecodedImage(imageRequest, callerContext, ImageRequest.RequestLevel.BITMAP_MEMORY_CACHE);
    }

    public DataSource<CloseableReference<CloseableImage>> fetchDecodedImage(ImageRequest imageRequest, Object callerContext) {
        return this.fetchDecodedImage(imageRequest, callerContext, ImageRequest.RequestLevel.FULL_FETCH);
    }

    public DataSource<CloseableReference<CloseableImage>> fetchDecodedImage(ImageRequest imageRequest, Object callerContext, ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit) {
        try {
            Producer producerSequence = this.mProducerSequenceFactory.getDecodedImageProducerSequence(imageRequest);
            return this.submitFetchRequest(producerSequence, imageRequest, lowestPermittedRequestLevelOnSubmit, callerContext);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }

    public DataSource<CloseableReference<PooledByteBuffer>> fetchEncodedImage(ImageRequest imageRequest, Object callerContext) {
        Preconditions.checkNotNull((Object)imageRequest.getSourceUri());
        try {
            Producer producerSequence = this.mProducerSequenceFactory.getEncodedImageProducerSequence(imageRequest);
            if (imageRequest.getResizeOptions() != null) {
                imageRequest = ImageRequestBuilder.fromRequest(imageRequest).setResizeOptions(null).build();
            }
            return this.submitFetchRequest(producerSequence, imageRequest, ImageRequest.RequestLevel.FULL_FETCH, callerContext);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }

    public DataSource<Void> prefetchToBitmapCache(ImageRequest imageRequest, Object callerContext) {
        if (!((Boolean)this.mIsPrefetchEnabledSupplier.get()).booleanValue()) {
            return DataSources.immediateFailedDataSource((Throwable)PREFETCH_EXCEPTION);
        }
        try {
            Producer<Void> producerSequence = (Boolean)this.mSuppressBitmapPrefetchingSupplier.get() != false ? this.mProducerSequenceFactory.getEncodedImagePrefetchProducerSequence(imageRequest) : this.mProducerSequenceFactory.getDecodedImagePrefetchProducerSequence(imageRequest);
            return this.submitPrefetchRequest(producerSequence, imageRequest, ImageRequest.RequestLevel.FULL_FETCH, callerContext, Priority.MEDIUM);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }

    public DataSource<Void> prefetchToDiskCache(ImageRequest imageRequest, Object callerContext) {
        return this.prefetchToDiskCache(imageRequest, callerContext, Priority.MEDIUM);
    }

    public DataSource<Void> prefetchToDiskCache(ImageRequest imageRequest, Object callerContext, Priority priority) {
        if (!((Boolean)this.mIsPrefetchEnabledSupplier.get()).booleanValue()) {
            return DataSources.immediateFailedDataSource((Throwable)PREFETCH_EXCEPTION);
        }
        try {
            Producer<Void> producerSequence = this.mProducerSequenceFactory.getEncodedImagePrefetchProducerSequence(imageRequest);
            return this.submitPrefetchRequest(producerSequence, imageRequest, ImageRequest.RequestLevel.FULL_FETCH, callerContext, priority);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }

    public void evictFromMemoryCache(Uri uri) {
        Predicate<CacheKey> predicate = this.predicateForUri(uri);
        this.mBitmapMemoryCache.removeAll(predicate);
        this.mEncodedMemoryCache.removeAll(predicate);
    }

    public void evictFromDiskCache(Uri uri) {
        this.evictFromDiskCache(ImageRequest.fromUri(uri));
    }

    public void evictFromDiskCache(ImageRequest imageRequest) {
        CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, null);
        this.mMainBufferedDiskCache.remove(cacheKey);
        this.mSmallImageBufferedDiskCache.remove(cacheKey);
    }

    public void evictFromCache(Uri uri) {
        this.evictFromMemoryCache(uri);
        this.evictFromDiskCache(uri);
    }

    public void clearMemoryCaches() {
        Predicate<CacheKey> allPredicate = new Predicate<CacheKey>(){

            public boolean apply(CacheKey key) {
                return true;
            }
        };
        this.mBitmapMemoryCache.removeAll((Predicate)allPredicate);
        this.mEncodedMemoryCache.removeAll((Predicate)allPredicate);
    }

    public void clearDiskCaches() {
        this.mMainBufferedDiskCache.clearAll();
        this.mSmallImageBufferedDiskCache.clearAll();
    }

    public void clearCaches() {
        this.clearMemoryCaches();
        this.clearDiskCaches();
    }

    public boolean isInBitmapMemoryCache(Uri uri) {
        if (uri == null) {
            return false;
        }
        Predicate<CacheKey> bitmapCachePredicate = this.predicateForUri(uri);
        return this.mBitmapMemoryCache.contains(bitmapCachePredicate);
    }

    public MemoryCache<CacheKey, CloseableImage> getBitmapMemoryCache() {
        return this.mBitmapMemoryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInBitmapMemoryCache(ImageRequest imageRequest) {
        if (imageRequest == null) {
            return false;
        }
        CacheKey cacheKey = this.mCacheKeyFactory.getBitmapCacheKey(imageRequest, null);
        CloseableReference ref = this.mBitmapMemoryCache.get((Object)cacheKey);
        try {
            boolean bl = CloseableReference.isValid((CloseableReference)ref);
            return bl;
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)ref);
        }
    }

    public boolean isInDiskCacheSync(Uri uri) {
        return this.isInDiskCacheSync(uri, ImageRequest.CacheChoice.SMALL) || this.isInDiskCacheSync(uri, ImageRequest.CacheChoice.DEFAULT);
    }

    public boolean isInDiskCacheSync(Uri uri, ImageRequest.CacheChoice cacheChoice) {
        ImageRequest imageRequest = ImageRequestBuilder.newBuilderWithSource(uri).setCacheChoice(cacheChoice).build();
        return this.isInDiskCacheSync(imageRequest);
    }

    public boolean isInDiskCacheSync(ImageRequest imageRequest) {
        CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, null);
        ImageRequest.CacheChoice cacheChoice = imageRequest.getCacheChoice();
        switch (cacheChoice) {
            case DEFAULT: {
                return this.mMainBufferedDiskCache.diskCheckSync(cacheKey);
            }
            case SMALL: {
                return this.mSmallImageBufferedDiskCache.diskCheckSync(cacheKey);
            }
        }
        return false;
    }

    public DataSource<Boolean> isInDiskCache(Uri uri) {
        return this.isInDiskCache(ImageRequest.fromUri(uri));
    }

    public DataSource<Boolean> isInDiskCache(ImageRequest imageRequest) {
        final CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, null);
        final SimpleDataSource dataSource = SimpleDataSource.create();
        this.mMainBufferedDiskCache.contains(cacheKey).continueWithTask((Continuation)new Continuation<Boolean, Task<Boolean>>(){

            public Task<Boolean> then(Task<Boolean> task) throws Exception {
                if (!task.isCancelled() && !task.isFaulted() && ((Boolean)task.getResult()).booleanValue()) {
                    return Task.forResult((Object)true);
                }
                return ImagePipeline.this.mSmallImageBufferedDiskCache.contains(cacheKey);
            }
        }).continueWith((Continuation)new Continuation<Boolean, Void>(){

            public Void then(Task<Boolean> task) throws Exception {
                dataSource.setResult((Object)(!task.isCancelled() && !task.isFaulted() && (Boolean)task.getResult() != false ? 1 : 0));
                return null;
            }
        });
        return dataSource;
    }

    private <T> DataSource<CloseableReference<T>> submitFetchRequest(Producer<CloseableReference<T>> producerSequence, ImageRequest imageRequest, ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit, Object callerContext) {
        RequestListener requestListener = this.getRequestListenerForRequest(imageRequest);
        try {
            ImageRequest.RequestLevel lowestPermittedRequestLevel = ImageRequest.RequestLevel.getMax(imageRequest.getLowestPermittedRequestLevel(), lowestPermittedRequestLevelOnSubmit);
            SettableProducerContext settableProducerContext = new SettableProducerContext(imageRequest, this.generateUniqueFutureId(), requestListener, callerContext, lowestPermittedRequestLevel, false, imageRequest.getProgressiveRenderingEnabled() || imageRequest.getMediaVariations() != null || !UriUtil.isNetworkUri((Uri)imageRequest.getSourceUri()), imageRequest.getPriority());
            return CloseableProducerToDataSourceAdapter.create(producerSequence, settableProducerContext, requestListener);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }

    private DataSource<Void> submitPrefetchRequest(Producer<Void> producerSequence, ImageRequest imageRequest, ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit, Object callerContext, Priority priority) {
        RequestListener requestListener = this.getRequestListenerForRequest(imageRequest);
        try {
            ImageRequest.RequestLevel lowestPermittedRequestLevel = ImageRequest.RequestLevel.getMax(imageRequest.getLowestPermittedRequestLevel(), lowestPermittedRequestLevelOnSubmit);
            SettableProducerContext settableProducerContext = new SettableProducerContext(imageRequest, this.generateUniqueFutureId(), requestListener, callerContext, lowestPermittedRequestLevel, true, false, priority);
            return ProducerToDataSourceAdapter.create(producerSequence, settableProducerContext, requestListener);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }

    private RequestListener getRequestListenerForRequest(ImageRequest imageRequest) {
        if (imageRequest.getRequestListener() == null) {
            return this.mRequestListener;
        }
        return new ForwardingRequestListener(this.mRequestListener, imageRequest.getRequestListener());
    }

    private Predicate<CacheKey> predicateForUri(final Uri uri) {
        return new Predicate<CacheKey>(){

            public boolean apply(CacheKey key) {
                return key.containsUri(uri);
            }
        };
    }

    public void pause() {
        this.mThreadHandoffProducerQueue.startQueueing();
    }

    public void resume() {
        this.mThreadHandoffProducerQueue.stopQueuing();
    }

    public boolean isPaused() {
        return this.mThreadHandoffProducerQueue.isQueueing();
    }

    public CacheKeyFactory getCacheKeyFactory() {
        return this.mCacheKeyFactory;
    }
}

