/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import bolts.Continuation;
import bolts.Task;
import com.facebook.cache.common.CacheKey;
import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.DiskCachePolicy;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;

public class SplitCachesByImageSizeDiskCachePolicy
implements DiskCachePolicy {
    private final BufferedDiskCache mDefaultBufferedDiskCache;
    private final BufferedDiskCache mSmallImageBufferedDiskCache;
    private final CacheKeyFactory mCacheKeyFactory;
    private final int mForceSmallCacheThresholdBytes;

    public SplitCachesByImageSizeDiskCachePolicy(BufferedDiskCache defaultBufferedDiskCache, BufferedDiskCache smallImageBufferedDiskCache, CacheKeyFactory cacheKeyFactory, int forceSmallCacheThresholdBytes) {
        this.mDefaultBufferedDiskCache = defaultBufferedDiskCache;
        this.mSmallImageBufferedDiskCache = smallImageBufferedDiskCache;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mForceSmallCacheThresholdBytes = forceSmallCacheThresholdBytes;
    }

    @Override
    public Task<EncodedImage> createAndStartCacheReadTask(ImageRequest imageRequest, Object callerContext, final AtomicBoolean isCancelled) {
        BufferedDiskCache secondCache;
        BufferedDiskCache firstCache;
        final CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, callerContext);
        boolean alreadyInSmall = this.mSmallImageBufferedDiskCache.containsSync(cacheKey);
        boolean alreadyInMain = this.mDefaultBufferedDiskCache.containsSync(cacheKey);
        if (alreadyInSmall || !alreadyInMain) {
            firstCache = this.mSmallImageBufferedDiskCache;
            secondCache = this.mDefaultBufferedDiskCache;
        } else {
            firstCache = this.mDefaultBufferedDiskCache;
            secondCache = this.mSmallImageBufferedDiskCache;
        }
        return firstCache.get(cacheKey, isCancelled).continueWithTask((Continuation)new Continuation<EncodedImage, Task<EncodedImage>>(){

            public Task<EncodedImage> then(Task<EncodedImage> task) throws Exception {
                if (SplitCachesByImageSizeDiskCachePolicy.isTaskCancelled(task) || !task.isFaulted() && task.getResult() != null) {
                    return task;
                }
                return secondCache.get(cacheKey, isCancelled);
            }
        });
    }

    @Override
    public void writeToCache(EncodedImage newResult, ImageRequest imageRequest, Object callerContext) {
        CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, callerContext);
        int size = newResult.getSize();
        if (size > 0 && size < this.mForceSmallCacheThresholdBytes) {
            this.mSmallImageBufferedDiskCache.put(cacheKey, newResult);
        } else {
            this.mDefaultBufferedDiskCache.put(cacheKey, newResult);
        }
    }

    private static boolean isTaskCancelled(Task<?> task) {
        return task.isCancelled() || task.isFaulted() && task.getError() instanceof CancellationException;
    }
}

