/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imagepipeline.producers.BaseConsumer;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.ImageRequest;

public class BitmapMemoryCacheProducer
implements Producer<CloseableReference<CloseableImage>> {
    public static final String PRODUCER_NAME = "BitmapMemoryCacheProducer";
    public static final String EXTRA_CACHED_VALUE_FOUND = "cached_value_found";
    private final MemoryCache<CacheKey, CloseableImage> mMemoryCache;
    private final CacheKeyFactory mCacheKeyFactory;
    private final Producer<CloseableReference<CloseableImage>> mInputProducer;

    public BitmapMemoryCacheProducer(MemoryCache<CacheKey, CloseableImage> memoryCache, CacheKeyFactory cacheKeyFactory, Producer<CloseableReference<CloseableImage>> inputProducer) {
        this.mMemoryCache = memoryCache;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mInputProducer = inputProducer;
    }

    @Override
    public void produceResults(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext) {
        ProducerListener listener = producerContext.getListener();
        String requestId = producerContext.getId();
        listener.onProducerStart(requestId, this.getProducerName());
        ImageRequest imageRequest = producerContext.getImageRequest();
        Object callerContext = producerContext.getCallerContext();
        CacheKey cacheKey = this.mCacheKeyFactory.getBitmapCacheKey(imageRequest, callerContext);
        CloseableReference cachedReference = this.mMemoryCache.get((Object)cacheKey);
        if (cachedReference != null) {
            boolean isFinal = ((CloseableImage)cachedReference.get()).getQualityInfo().isOfFullQuality();
            if (isFinal) {
                listener.onProducerFinishWithSuccess(requestId, this.getProducerName(), listener.requiresExtraMap(requestId) ? ImmutableMap.of((Object)EXTRA_CACHED_VALUE_FOUND, (Object)"true") : null);
                listener.onUltimateProducerReached(requestId, this.getProducerName(), true);
                consumer.onProgressUpdate(1.0f);
            }
            consumer.onNewResult((CloseableReference<CloseableImage>)cachedReference, BaseConsumer.simpleStatusForIsLast(isFinal));
            cachedReference.close();
            if (isFinal) {
                return;
            }
        }
        if (producerContext.getLowestPermittedRequestLevel().getValue() >= ImageRequest.RequestLevel.BITMAP_MEMORY_CACHE.getValue()) {
            listener.onProducerFinishWithSuccess(requestId, this.getProducerName(), listener.requiresExtraMap(requestId) ? ImmutableMap.of((Object)EXTRA_CACHED_VALUE_FOUND, (Object)"false") : null);
            listener.onUltimateProducerReached(requestId, this.getProducerName(), false);
            consumer.onNewResult(null, 1);
            return;
        }
        Consumer<CloseableReference<CloseableImage>> wrappedConsumer = this.wrapConsumer(consumer, cacheKey, producerContext.getImageRequest().isMemoryCacheEnabled());
        listener.onProducerFinishWithSuccess(requestId, this.getProducerName(), listener.requiresExtraMap(requestId) ? ImmutableMap.of((Object)EXTRA_CACHED_VALUE_FOUND, (Object)"false") : null);
        this.mInputProducer.produceResults(wrappedConsumer, producerContext);
    }

    protected Consumer<CloseableReference<CloseableImage>> wrapConsumer(Consumer<CloseableReference<CloseableImage>> consumer, final CacheKey cacheKey, final boolean isMemoryCacheEnabled) {
        return new DelegatingConsumer<CloseableReference<CloseableImage>, CloseableReference<CloseableImage>>(consumer){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNewResultImpl(CloseableReference<CloseableImage> newResult, int status) {
                CloseableReference currentCachedResult;
                boolean isLast = 1.isLast(status);
                if (newResult == null) {
                    if (isLast) {
                        this.getConsumer().onNewResult(null, status);
                    }
                    return;
                }
                if (((CloseableImage)newResult.get()).isStateful() || 1.statusHasFlag(status, 8)) {
                    this.getConsumer().onNewResult(newResult, status);
                    return;
                }
                if (!isLast && (currentCachedResult = BitmapMemoryCacheProducer.this.mMemoryCache.get((Object)cacheKey)) != null) {
                    try {
                        QualityInfo newInfo = ((CloseableImage)newResult.get()).getQualityInfo();
                        QualityInfo cachedInfo = ((CloseableImage)currentCachedResult.get()).getQualityInfo();
                        if (cachedInfo.isOfFullQuality() || cachedInfo.getQuality() >= newInfo.getQuality()) {
                            this.getConsumer().onNewResult(currentCachedResult, status);
                            return;
                        }
                    }
                    finally {
                        CloseableReference.closeSafely((CloseableReference)currentCachedResult);
                    }
                }
                CloseableReference<CloseableImage> newCachedResult = null;
                if (isMemoryCacheEnabled) {
                    newCachedResult = BitmapMemoryCacheProducer.this.mMemoryCache.cache((Object)cacheKey, newResult);
                }
                try {
                    if (isLast) {
                        this.getConsumer().onProgressUpdate(1.0f);
                    }
                    this.getConsumer().onNewResult(newCachedResult != null ? newCachedResult : newResult, status);
                }
                finally {
                    CloseableReference.closeSafely(newCachedResult);
                }
            }
        };
    }

    protected String getProducerName() {
        return PRODUCER_NAME;
    }
}

