/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.imagepipeline.memory.LruBucketsPoolBackend;
import com.facebook.imageutils.BitmapUtil;

public class BitmapPoolBackend
extends LruBucketsPoolBackend<Bitmap> {
    private static final String TAG = "BitmapPoolBackend";

    @Override
    public void put(Bitmap bitmap) {
        if (this.isReusable(bitmap)) {
            super.put(bitmap);
        }
    }

    @Override
    @Nullable
    public Bitmap get(int size) {
        Bitmap bitmap = (Bitmap)super.get(size);
        if (bitmap != null && this.isReusable(bitmap)) {
            bitmap.eraseColor(0);
            return bitmap;
        }
        return null;
    }

    @Override
    public int getSize(Bitmap bitmap) {
        return BitmapUtil.getSizeInBytes((Bitmap)bitmap);
    }

    protected boolean isReusable(@Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return false;
        }
        if (bitmap.isRecycled()) {
            FLog.wtf((String)TAG, (String)"Cannot reuse a recycled bitmap: %s", (Object[])new Object[]{bitmap});
            return false;
        }
        if (!bitmap.isMutable()) {
            FLog.wtf((String)TAG, (String)"Cannot reuse an immutable bitmap: %s", (Object[])new Object[]{bitmap});
            return false;
        }
        return true;
    }
}

