/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.filter;

import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import java.util.Locale;

public abstract class IterativeBoxBlurFilter {
    private static final String TAG = "IterativeBoxBlurFilter";

    public static void boxBlurBitmapInPlace(Bitmap bitmap, int iterations, int radius) {
        Preconditions.checkNotNull((Object)bitmap);
        Preconditions.checkArgument((boolean)bitmap.isMutable());
        Preconditions.checkArgument(((float)bitmap.getHeight() <= 2048.0f ? 1 : 0) != 0);
        Preconditions.checkArgument(((float)bitmap.getWidth() <= 2048.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((radius > 0 && radius <= 25 ? 1 : 0) != 0);
        Preconditions.checkArgument((iterations > 0 ? 1 : 0) != 0);
        try {
            IterativeBoxBlurFilter.fastBoxBlur(bitmap, iterations, radius);
        }
        catch (OutOfMemoryError oom) {
            FLog.e((String)TAG, (String)String.format((Locale)null, "OOM: %d iterations on %dx%d with %d radius", iterations, bitmap.getWidth(), bitmap.getHeight(), radius));
            throw oom;
        }
    }

    private static void fastBoxBlur(Bitmap bitmap, int iterations, int radius) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int[] pixels = new int[w * h];
        bitmap.getPixels(pixels, 0, w, 0, 0, w, h);
        int diameter = radius + 1 + radius;
        int[] div = new int[256 * diameter];
        int ptr = radius + 1;
        for (int b = 1; b <= 255; ++b) {
            for (int d = 0; d < diameter; ++d) {
                div[ptr] = b;
                ++ptr;
            }
        }
        int[] tempRowOrColumn = new int[Math.max(w, h)];
        for (int i = 0; i < iterations; ++i) {
            for (int row = 0; row < h; ++row) {
                IterativeBoxBlurFilter.internalHorizontalBlur(pixels, tempRowOrColumn, w, row, diameter, div);
                System.arraycopy(tempRowOrColumn, 0, pixels, row * w, w);
            }
            for (int col = 0; col < w; ++col) {
                IterativeBoxBlurFilter.internalVerticalBlur(pixels, tempRowOrColumn, w, h, col, diameter, div);
                int pos = col;
                for (int row = 0; row < h; ++row) {
                    pixels[pos] = tempRowOrColumn[row];
                    pos += w;
                }
            }
        }
        bitmap.setPixels(pixels, 0, w, 0, 0, w, h);
    }

    private static void internalHorizontalBlur(int[] pixels, int[] outRow, int w, int row, int diameter, int[] div) {
        int firstInByte = w * row;
        int lastInByte = w * (row + 1) - 1;
        int radius = diameter >> 1;
        int a = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        for (int i = -radius; i < w + radius; ++i) {
            int ii = IterativeBoxBlurFilter.bound(firstInByte + i, firstInByte, lastInByte);
            int pixel = pixels[ii];
            r += pixel >> 16 & 0xFF;
            g += pixel >> 8 & 0xFF;
            b += pixel & 0xFF;
            a += pixel >>> 24;
            if (i < radius) continue;
            int outOffset = i - radius;
            outRow[outOffset] = div[a] << 24 | div[r] << 16 | div[g] << 8 | div[b];
            int j = i - (diameter - 1);
            int jj = IterativeBoxBlurFilter.bound(firstInByte + j, firstInByte, lastInByte);
            pixel = pixels[jj];
            r -= pixel >> 16 & 0xFF;
            g -= pixel >> 8 & 0xFF;
            b -= pixel & 0xFF;
            a -= pixel >>> 24;
        }
    }

    private static void internalVerticalBlur(int[] pixels, int[] outCol, int w, int h, int col, int diameter, int[] div) {
        int lastInByte = w * (h - 1) + col;
        int radiusTimesW = (diameter >> 1) * w;
        int diameterMinusOneTimesW = (diameter - 1) * w;
        int a = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int outColPos = 0;
        for (int i = col - radiusTimesW; i <= lastInByte + radiusTimesW; i += w) {
            int ii = IterativeBoxBlurFilter.bound(i, col, lastInByte);
            int pixel = pixels[ii];
            r += pixel >> 16 & 0xFF;
            g += pixel >> 8 & 0xFF;
            b += pixel & 0xFF;
            a += pixel >>> 24;
            int outPos = i - radiusTimesW;
            if (outPos < col) continue;
            outCol[outColPos] = div[a] << 24 | div[r] << 16 | div[g] << 8 | div[b];
            ++outColPos;
            int j = i - diameterMinusOneTimesW;
            int jj = IterativeBoxBlurFilter.bound(j, col, lastInByte);
            pixel = pixels[jj];
            r -= pixel >> 16 & 0xFF;
            g -= pixel >> 8 & 0xFF;
            b -= pixel & 0xFF;
            a -= pixel >>> 24;
        }
    }

    private static int bound(int x, int l, int h) {
        return x < l ? l : (x > h ? h : x);
    }
}

