/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.filter;

import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;

public final class InPlaceRoundFilter {
    private InPlaceRoundFilter() {
    }

    public static void roundBitmapInPlace(Bitmap bitmap) {
        int i;
        Preconditions.checkNotNull((Object)bitmap);
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int radius = Math.min(w, h) / 2;
        int centerX = w / 2;
        int centerY = h / 2;
        if (radius == 0) {
            return;
        }
        Preconditions.checkArgument((radius >= 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((w > 0 && (float)w <= 2048.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((h > 0 && (float)h <= 2048.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((centerX > 0 && centerX < w ? 1 : 0) != 0);
        Preconditions.checkArgument((centerY > 0 && centerY < h ? 1 : 0) != 0);
        int[] pixels = new int[w * h];
        bitmap.getPixels(pixels, 0, w, 0, 0, w, h);
        int x = radius - 1;
        int y = 0;
        int maxX = centerX + x;
        int maxY = centerY + x;
        int minX = centerX - x;
        int minY = centerY - x;
        Preconditions.checkArgument((minX >= 0 && minY >= 0 && maxX < w && maxY < h ? 1 : 0) != 0);
        int dx = 1;
        int dy = 1;
        int rInc = -radius * 2;
        int[] transparentColor = new int[w];
        int err = dx + rInc;
        while (x >= y) {
            int cXpX = centerX + x;
            int cXmX = centerX - x;
            int cXpY = centerX + y;
            int cXmY = centerX - y;
            int cYpX = centerY + x;
            int cYmX = centerY - x;
            int cYpY = centerY + y;
            int cYmY = centerY - y;
            Preconditions.checkArgument((x >= 0 && cXpY < w && cXmY >= 0 && cYpY < h && cYmY >= 0 ? 1 : 0) != 0);
            int offA = w * cYpY;
            int offB = w * cYmY;
            int offC = w * cYpX;
            int offD = w * cYmX;
            System.arraycopy(transparentColor, 0, pixels, offA, cXmX);
            System.arraycopy(transparentColor, 0, pixels, offB, cXmX);
            System.arraycopy(transparentColor, 0, pixels, offC, cXmY);
            System.arraycopy(transparentColor, 0, pixels, offD, cXmY);
            System.arraycopy(transparentColor, 0, pixels, offA + cXpX, w - cXpX);
            System.arraycopy(transparentColor, 0, pixels, offB + cXpX, w - cXpX);
            System.arraycopy(transparentColor, 0, pixels, offC + cXpY, w - cXpY);
            System.arraycopy(transparentColor, 0, pixels, offD + cXpY, w - cXpY);
            if (err <= 0) {
                ++y;
                err += (dy += 2);
            }
            if (err <= 0) continue;
            --x;
            err += (dx += 2) + rInc;
        }
        for (i = centerY - radius; i >= 0; --i) {
            System.arraycopy(transparentColor, 0, pixels, i * w, w);
        }
        for (i = centerY + radius; i < h; ++i) {
            System.arraycopy(transparentColor, 0, pixels, i * w, w);
        }
        bitmap.setPixels(pixels, 0, w, 0, 0, w, h);
    }
}

