/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.util.Log;
import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.memory.MemoryChunk;
import com.facebook.imagepipeline.memory.MemoryChunkUtil;
import java.io.Closeable;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class BufferMemoryChunk
implements MemoryChunk,
Closeable {
    private static final String TAG = "BufferMemoryChunk";
    private ByteBuffer mBuffer;
    private final int mSize;
    private final long mId;

    public BufferMemoryChunk(int size) {
        this.mBuffer = ByteBuffer.allocateDirect(size);
        this.mSize = size;
        this.mId = System.identityHashCode(this);
    }

    @Override
    public synchronized void close() {
        this.mBuffer = null;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.mBuffer == null;
    }

    @Override
    public int getSize() {
        return this.mSize;
    }

    @Override
    public synchronized int write(int memoryOffset, byte[] byteArray, int byteArrayOffset, int count) {
        Preconditions.checkNotNull((Object)byteArray);
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        int actualCount = MemoryChunkUtil.adjustByteCount(memoryOffset, count, this.mSize);
        MemoryChunkUtil.checkBounds(memoryOffset, byteArray.length, byteArrayOffset, actualCount, this.mSize);
        this.mBuffer.position(memoryOffset);
        this.mBuffer.put(byteArray, byteArrayOffset, actualCount);
        return actualCount;
    }

    @Override
    public synchronized int read(int memoryOffset, byte[] byteArray, int byteArrayOffset, int count) {
        Preconditions.checkNotNull((Object)byteArray);
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        int actualCount = MemoryChunkUtil.adjustByteCount(memoryOffset, count, this.mSize);
        MemoryChunkUtil.checkBounds(memoryOffset, byteArray.length, byteArrayOffset, actualCount, this.mSize);
        this.mBuffer.position(memoryOffset);
        this.mBuffer.get(byteArray, byteArrayOffset, actualCount);
        return actualCount;
    }

    @Override
    public synchronized byte read(int offset) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((offset < this.mSize ? 1 : 0) != 0);
        return this.mBuffer.get(offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(int offset, MemoryChunk other, int otherOffset, int count) {
        Preconditions.checkNotNull((Object)other);
        if (other.getUniqueId() == this.getUniqueId()) {
            Log.w((String)TAG, (String)("Copying from BufferMemoryChunk " + Long.toHexString(this.getUniqueId()) + " to BufferMemoryChunk " + Long.toHexString(other.getUniqueId()) + " which are the same "));
            Preconditions.checkArgument((boolean)false);
        }
        if (other.getUniqueId() < this.getUniqueId()) {
            MemoryChunk memoryChunk = other;
            synchronized (memoryChunk) {
                BufferMemoryChunk bufferMemoryChunk = this;
                synchronized (bufferMemoryChunk) {
                    this.doCopy(offset, other, otherOffset, count);
                }
            }
            return;
        }
        BufferMemoryChunk bufferMemoryChunk = this;
        synchronized (bufferMemoryChunk) {
            MemoryChunk memoryChunk = other;
            synchronized (memoryChunk) {
                this.doCopy(offset, other, otherOffset, count);
            }
        }
    }

    @Override
    public long getNativePtr() {
        throw new UnsupportedOperationException("Cannot get the pointer of a BufferMemoryChunk");
    }

    @Override
    @Nullable
    public synchronized ByteBuffer getByteBuffer() {
        return this.mBuffer;
    }

    @Override
    public long getUniqueId() {
        return this.mId;
    }

    private void doCopy(int offset, MemoryChunk other, int otherOffset, int count) {
        if (!(other instanceof BufferMemoryChunk)) {
            throw new IllegalArgumentException("Cannot copy two incompatible MemoryChunks");
        }
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Preconditions.checkState((!other.isClosed() ? 1 : 0) != 0);
        MemoryChunkUtil.checkBounds(offset, other.getSize(), otherOffset, count, this.mSize);
        this.mBuffer.position(offset);
        other.getByteBuffer().position(otherOffset);
        byte[] b = new byte[count];
        this.mBuffer.get(b, 0, count);
        other.getByteBuffer().put(b, 0, count);
    }
}

