/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.imagepipeline.producers.ThreadHandoffProducerQueue;
import javax.annotation.Nullable;

public class ThreadHandoffProducer<T>
implements Producer<T> {
    public static final String PRODUCER_NAME = "BackgroundThreadHandoffProducer";
    private final Producer<T> mInputProducer;
    private final ThreadHandoffProducerQueue mThreadHandoffProducerQueue;

    public ThreadHandoffProducer(Producer<T> inputProducer, ThreadHandoffProducerQueue inputThreadHandoffProducerQueue) {
        this.mInputProducer = (Producer)Preconditions.checkNotNull(inputProducer);
        this.mThreadHandoffProducerQueue = inputThreadHandoffProducerQueue;
    }

    @Override
    public void produceResults(final Consumer<T> consumer, final ProducerContext context) {
        final ProducerListener producerListener = context.getListener();
        final String requestId = context.getId();
        final StatefulProducerRunnable statefulRunnable = new StatefulProducerRunnable<T>(consumer, producerListener, PRODUCER_NAME, requestId){

            @Override
            protected void onSuccess(T ignored) {
                producerListener.onProducerFinishWithSuccess(requestId, ThreadHandoffProducer.PRODUCER_NAME, null);
                ThreadHandoffProducer.this.mInputProducer.produceResults(consumer, context);
            }

            @Override
            protected void disposeResult(T ignored) {
            }

            @Nullable
            protected T getResult() throws Exception {
                return null;
            }
        };
        context.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                statefulRunnable.cancel();
                ThreadHandoffProducer.this.mThreadHandoffProducerQueue.remove((Runnable)((Object)statefulRunnable));
            }
        });
        this.mThreadHandoffProducerQueue.addToQueueOrExecute((Runnable)((Object)statefulRunnable));
    }
}

