/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import android.content.Context;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.Supplier;
import com.facebook.common.internal.Suppliers;
import com.facebook.common.memory.ByteArrayPool;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.webp.WebpBitmapFactory;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MediaVariationsIndex;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.core.ExecutorSupplier;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.facebook.imagepipeline.core.ProducerFactory;
import com.facebook.imagepipeline.decoder.ImageDecoder;
import com.facebook.imagepipeline.decoder.ProgressiveJpegConfig;
import com.facebook.imagepipeline.image.CloseableImage;

public class ImagePipelineExperiments {
    private final boolean mWebpSupportEnabled;
    private final boolean mExternalCreatedBitmapLogEnabled;
    private final Supplier<Boolean> mMediaVariationsIndexEnabled;
    private final WebpBitmapFactory.WebpErrorLogger mWebpErrorLogger;
    private final boolean mDecodeCancellationEnabled;
    private final WebpBitmapFactory mWebpBitmapFactory;
    private final boolean mSuppressBitmapPrefetching;
    private final boolean mUseDownsamplingRatioForResizing;
    private final boolean mUseBitmapPrepareToDraw;
    private final int mBitmapPrepareToDrawMinSizeBytes;
    private final int mBitmapPrepareToDrawMaxSizeBytes;
    private boolean mBitmapPrepareToDrawForPrefetch;
    private final boolean mPartialImageCachingEnabled;
    private final Supplier<Boolean> mSmartResizingEnabled;
    private final ProducerFactoryMethod mProducerFactoryMethod;

    private ImagePipelineExperiments(Builder builder) {
        this.mWebpSupportEnabled = builder.mWebpSupportEnabled;
        this.mExternalCreatedBitmapLogEnabled = builder.mExternalCreatedBitmapLogEnabled;
        this.mMediaVariationsIndexEnabled = builder.mMediaVariationsIndexEnabled != null ? builder.mMediaVariationsIndexEnabled : new Supplier<Boolean>(){

            public Boolean get() {
                return Boolean.FALSE;
            }
        };
        this.mWebpErrorLogger = builder.mWebpErrorLogger;
        this.mDecodeCancellationEnabled = builder.mDecodeCancellationEnabled;
        this.mWebpBitmapFactory = builder.mWebpBitmapFactory;
        this.mSuppressBitmapPrefetching = builder.mSuppressBitmapPrefetching;
        this.mUseDownsamplingRatioForResizing = builder.mUseDownsamplingRatioForResizing;
        this.mUseBitmapPrepareToDraw = builder.mUseBitmapPrepareToDraw;
        this.mBitmapPrepareToDrawMinSizeBytes = builder.mBitmapPrepareToDrawMinSizeBytes;
        this.mBitmapPrepareToDrawMaxSizeBytes = builder.mBitmapPrepareToDrawMaxSizeBytes;
        this.mBitmapPrepareToDrawForPrefetch = builder.mBitmapPrepareToDrawForPrefetch;
        this.mPartialImageCachingEnabled = builder.mPartialImageCachingEnabled;
        this.mSmartResizingEnabled = builder.mSmartResizingEnabled;
        this.mProducerFactoryMethod = builder.mProducerFactoryMethod == null ? new DefaultProducerFactoryMethod() : builder.mProducerFactoryMethod;
    }

    public boolean isExternalCreatedBitmapLogEnabled() {
        return this.mExternalCreatedBitmapLogEnabled;
    }

    public boolean getMediaVariationsIndexEnabled() {
        return (Boolean)this.mMediaVariationsIndexEnabled.get();
    }

    public boolean getUseDownsamplingRatioForResizing() {
        return this.mUseDownsamplingRatioForResizing;
    }

    public boolean isWebpSupportEnabled() {
        return this.mWebpSupportEnabled;
    }

    public boolean isDecodeCancellationEnabled() {
        return this.mDecodeCancellationEnabled;
    }

    public WebpBitmapFactory.WebpErrorLogger getWebpErrorLogger() {
        return this.mWebpErrorLogger;
    }

    public WebpBitmapFactory getWebpBitmapFactory() {
        return this.mWebpBitmapFactory;
    }

    public boolean getUseBitmapPrepareToDraw() {
        return this.mUseBitmapPrepareToDraw;
    }

    public int getBitmapPrepareToDrawMinSizeBytes() {
        return this.mBitmapPrepareToDrawMinSizeBytes;
    }

    public int getBitmapPrepareToDrawMaxSizeBytes() {
        return this.mBitmapPrepareToDrawMaxSizeBytes;
    }

    public boolean isPartialImageCachingEnabled() {
        return this.mPartialImageCachingEnabled;
    }

    public Supplier<Boolean> isSmartResizingEnabled() {
        return this.mSmartResizingEnabled;
    }

    public ProducerFactoryMethod getProducerFactoryMethod() {
        return this.mProducerFactoryMethod;
    }

    public static Builder newBuilder(ImagePipelineConfig.Builder configBuilder) {
        return new Builder(configBuilder);
    }

    public boolean getBitmapPrepareToDrawForPrefetch() {
        return this.mBitmapPrepareToDrawForPrefetch;
    }

    public static class DefaultProducerFactoryMethod
    implements ProducerFactoryMethod {
        @Override
        public ProducerFactory createProducerFactory(Context context, ByteArrayPool byteArrayPool, ImageDecoder imageDecoder, ProgressiveJpegConfig progressiveJpegConfig, boolean downsampleEnabled, boolean resizeAndRotateEnabledForNetwork, boolean decodeCancellationEnabled, Supplier<Boolean> experimentalSmartResizingEnabled, ExecutorSupplier executorSupplier, PooledByteBufferFactory pooledByteBufferFactory, MemoryCache<CacheKey, CloseableImage> bitmapMemoryCache, MemoryCache<CacheKey, PooledByteBuffer> encodedMemoryCache, BufferedDiskCache defaultBufferedDiskCache, BufferedDiskCache smallImageBufferedDiskCache, MediaVariationsIndex mediaVariationsIndex, CacheKeyFactory cacheKeyFactory, PlatformBitmapFactory platformBitmapFactory, int bitmapPrepareToDrawMinSizeBytes, int bitmapPrepareToDrawMaxSizeBytes, boolean bitmapPrepareToDrawForPrefetch) {
            return new ProducerFactory(context, byteArrayPool, imageDecoder, progressiveJpegConfig, downsampleEnabled, resizeAndRotateEnabledForNetwork, decodeCancellationEnabled, experimentalSmartResizingEnabled, executorSupplier, pooledByteBufferFactory, bitmapMemoryCache, encodedMemoryCache, defaultBufferedDiskCache, smallImageBufferedDiskCache, mediaVariationsIndex, cacheKeyFactory, platformBitmapFactory, bitmapPrepareToDrawMinSizeBytes, bitmapPrepareToDrawMaxSizeBytes, bitmapPrepareToDrawForPrefetch);
        }
    }

    public static interface ProducerFactoryMethod {
        public ProducerFactory createProducerFactory(Context var1, ByteArrayPool var2, ImageDecoder var3, ProgressiveJpegConfig var4, boolean var5, boolean var6, boolean var7, Supplier<Boolean> var8, ExecutorSupplier var9, PooledByteBufferFactory var10, MemoryCache<CacheKey, CloseableImage> var11, MemoryCache<CacheKey, PooledByteBuffer> var12, BufferedDiskCache var13, BufferedDiskCache var14, MediaVariationsIndex var15, CacheKeyFactory var16, PlatformBitmapFactory var17, int var18, int var19, boolean var20);
    }

    public static class Builder {
        private final ImagePipelineConfig.Builder mConfigBuilder;
        private boolean mWebpSupportEnabled = false;
        private boolean mExternalCreatedBitmapLogEnabled = false;
        private Supplier<Boolean> mMediaVariationsIndexEnabled = null;
        private WebpBitmapFactory.WebpErrorLogger mWebpErrorLogger;
        private boolean mDecodeCancellationEnabled = false;
        private WebpBitmapFactory mWebpBitmapFactory;
        private boolean mSuppressBitmapPrefetching = false;
        private boolean mUseDownsamplingRatioForResizing = false;
        private boolean mUseBitmapPrepareToDraw = false;
        private int mBitmapPrepareToDrawMinSizeBytes = 0;
        private int mBitmapPrepareToDrawMaxSizeBytes = 0;
        public boolean mBitmapPrepareToDrawForPrefetch = false;
        private boolean mPartialImageCachingEnabled = false;
        private Supplier<Boolean> mSmartResizingEnabled = Suppliers.BOOLEAN_FALSE;
        private ProducerFactoryMethod mProducerFactoryMethod;

        public Builder(ImagePipelineConfig.Builder configBuilder) {
            this.mConfigBuilder = configBuilder;
        }

        public ImagePipelineConfig.Builder setExternalCreatedBitmapLogEnabled(boolean externalCreatedBitmapLogEnabled) {
            this.mExternalCreatedBitmapLogEnabled = externalCreatedBitmapLogEnabled;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setMediaVariationsIndexEnabled(Supplier<Boolean> mediaVariationsIndexEnabled) {
            this.mMediaVariationsIndexEnabled = mediaVariationsIndexEnabled;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setWebpSupportEnabled(boolean webpSupportEnabled) {
            this.mWebpSupportEnabled = webpSupportEnabled;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setUseDownsampligRatioForResizing(boolean useDownsamplingRatioForResizing) {
            this.mUseDownsamplingRatioForResizing = useDownsamplingRatioForResizing;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setPartialImageCachingEnabled(boolean partialImageCachingEnabled) {
            this.mPartialImageCachingEnabled = partialImageCachingEnabled;
            return this.mConfigBuilder;
        }

        public boolean isPartialImageCachingEnabled() {
            return this.mPartialImageCachingEnabled;
        }

        public ImagePipelineConfig.Builder setDecodeCancellationEnabled(boolean decodeCancellationEnabled) {
            this.mDecodeCancellationEnabled = decodeCancellationEnabled;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setWebpErrorLogger(WebpBitmapFactory.WebpErrorLogger webpErrorLogger) {
            this.mWebpErrorLogger = webpErrorLogger;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setWebpBitmapFactory(WebpBitmapFactory webpBitmapFactory) {
            this.mWebpBitmapFactory = webpBitmapFactory;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setSuppressBitmapPrefetching(boolean suppressBitmapPrefetching) {
            this.mSuppressBitmapPrefetching = suppressBitmapPrefetching;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setBitmapPrepareToDraw(boolean useBitmapPrepareToDraw, int minBitmapSizeBytes, int maxBitmapSizeBytes, boolean preparePrefetch) {
            this.mUseBitmapPrepareToDraw = useBitmapPrepareToDraw;
            this.mBitmapPrepareToDrawMinSizeBytes = minBitmapSizeBytes;
            this.mBitmapPrepareToDrawMaxSizeBytes = maxBitmapSizeBytes;
            this.mBitmapPrepareToDrawForPrefetch = preparePrefetch;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setSmartResizingEnabled(Supplier<Boolean> smartResizingEnabled) {
            this.mSmartResizingEnabled = smartResizingEnabled;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setProducerFactoryMethod(ProducerFactoryMethod producerFactoryMethod) {
            this.mProducerFactoryMethod = producerFactoryMethod;
            return this.mConfigBuilder;
        }

        public ImagePipelineExperiments build() {
            return new ImagePipelineExperiments(this);
        }
    }
}

