/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.imagepipeline.memory.BitmapCounter;
import com.facebook.infer.annotation.ThreadSafe;

public class BitmapCounterProvider {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    public static final int MAX_BITMAP_TOTAL_SIZE = BitmapCounterProvider.getMaxSizeHardCap();
    public static final int MAX_BITMAP_COUNT = 384;
    private static volatile BitmapCounter sBitmapCounter;

    private static int getMaxSizeHardCap() {
        int maxMemory = (int)Math.min(Runtime.getRuntime().maxMemory(), Integer.MAX_VALUE);
        if ((long)maxMemory > 0x1000000L) {
            return maxMemory / 4 * 3;
        }
        return maxMemory / 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ThreadSafe
    public static BitmapCounter get() {
        if (sBitmapCounter != null) return sBitmapCounter;
        Class<BitmapCounterProvider> clazz = BitmapCounterProvider.class;
        synchronized (BitmapCounterProvider.class) {
            if (sBitmapCounter != null) return sBitmapCounter;
            sBitmapCounter = new BitmapCounter(384, MAX_BITMAP_TOTAL_SIZE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sBitmapCounter;
        }
    }
}

