/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.nativecode;

import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.nativecode.ImagePipelineNativeLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@DoNotStrip
public class JpegTranscoder {
    public static final int MIN_QUALITY = 0;
    public static final int MAX_QUALITY = 100;
    public static final int MIN_SCALE_NUMERATOR = 1;
    public static final int MAX_SCALE_NUMERATOR = 16;
    public static final int SCALE_DENOMINATOR = 8;

    public static boolean isRotationAngleAllowed(int degrees) {
        return degrees >= 0 && degrees <= 270 && degrees % 90 == 0;
    }

    public static boolean isExifOrientationAllowed(int exifOrientation) {
        switch (exifOrientation) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static void transcodeJpeg(InputStream inputStream, OutputStream outputStream, int rotationAngle, int scaleNumerator, int quality) throws IOException {
        Preconditions.checkArgument((scaleNumerator >= 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((scaleNumerator <= 16 ? 1 : 0) != 0);
        Preconditions.checkArgument((quality >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((quality <= 100 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)JpegTranscoder.isRotationAngleAllowed(rotationAngle));
        Preconditions.checkArgument((scaleNumerator != 8 || rotationAngle != 0 ? 1 : 0) != 0, (Object)"no transformation requested");
        JpegTranscoder.nativeTranscodeJpeg((InputStream)Preconditions.checkNotNull((Object)inputStream), (OutputStream)Preconditions.checkNotNull((Object)outputStream), rotationAngle, scaleNumerator, quality);
    }

    @DoNotStrip
    private static native void nativeTranscodeJpeg(InputStream var0, OutputStream var1, int var2, int var3, int var4) throws IOException;

    public static void transcodeJpegWithExifOrientation(InputStream inputStream, OutputStream outputStream, int exifOrientation, int scaleNumerator, int quality) throws IOException {
        Preconditions.checkArgument((scaleNumerator >= 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((scaleNumerator <= 16 ? 1 : 0) != 0);
        Preconditions.checkArgument((quality >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((quality <= 100 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)JpegTranscoder.isExifOrientationAllowed(exifOrientation));
        Preconditions.checkArgument((scaleNumerator != 8 || exifOrientation != 1 ? 1 : 0) != 0, (Object)"no transformation requested");
        JpegTranscoder.nativeTranscodeJpegWithExifOrientation((InputStream)Preconditions.checkNotNull((Object)inputStream), (OutputStream)Preconditions.checkNotNull((Object)outputStream), exifOrientation, scaleNumerator, quality);
    }

    @DoNotStrip
    private static native void nativeTranscodeJpegWithExifOrientation(InputStream var0, OutputStream var1, int var2, int var3, int var4) throws IOException;

    static {
        ImagePipelineNativeLoader.load();
    }
}

