/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import android.content.ContentResolver;
import android.net.Uri;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.media.MediaUtils;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.webp.WebpSupportStatus;
import com.facebook.imagepipeline.core.ProducerFactory;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.BitmapMemoryCacheGetProducer;
import com.facebook.imagepipeline.producers.BitmapMemoryCacheKeyMultiplexProducer;
import com.facebook.imagepipeline.producers.BitmapMemoryCacheProducer;
import com.facebook.imagepipeline.producers.BitmapPrepareProducer;
import com.facebook.imagepipeline.producers.DecodeProducer;
import com.facebook.imagepipeline.producers.DiskCacheReadProducer;
import com.facebook.imagepipeline.producers.DiskCacheWriteProducer;
import com.facebook.imagepipeline.producers.EncodedMemoryCacheProducer;
import com.facebook.imagepipeline.producers.EncodedProbeProducer;
import com.facebook.imagepipeline.producers.LocalAssetFetchProducer;
import com.facebook.imagepipeline.producers.LocalContentUriFetchProducer;
import com.facebook.imagepipeline.producers.LocalFileFetchProducer;
import com.facebook.imagepipeline.producers.LocalResourceFetchProducer;
import com.facebook.imagepipeline.producers.LocalVideoThumbnailProducer;
import com.facebook.imagepipeline.producers.NetworkFetcher;
import com.facebook.imagepipeline.producers.PartialDiskCacheProducer;
import com.facebook.imagepipeline.producers.PostprocessedBitmapMemoryCacheProducer;
import com.facebook.imagepipeline.producers.PostprocessorProducer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.QualifiedResourceFetchProducer;
import com.facebook.imagepipeline.producers.RemoveImageTransformMetaDataProducer;
import com.facebook.imagepipeline.producers.SwallowResultProducer;
import com.facebook.imagepipeline.producers.ThreadHandoffProducer;
import com.facebook.imagepipeline.producers.ThreadHandoffProducerQueue;
import com.facebook.imagepipeline.producers.ThrottlingProducer;
import com.facebook.imagepipeline.producers.ThumbnailBranchProducer;
import com.facebook.imagepipeline.producers.ThumbnailProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import com.facebook.imagepipeline.transcoder.ImageTranscoderFactory;
import java.util.HashMap;
import java.util.Map;

public class ProducerSequenceFactory {
    private final ContentResolver mContentResolver;
    private final ProducerFactory mProducerFactory;
    private final NetworkFetcher mNetworkFetcher;
    private final boolean mResizeAndRotateEnabledForNetwork;
    private final boolean mWebpSupportEnabled;
    private final boolean mPartialImageCachingEnabled;
    private final ThreadHandoffProducerQueue mThreadHandoffProducerQueue;
    private final boolean mDownsampleEnabled;
    private final boolean mUseBitmapPrepareToDraw;
    private final boolean mDiskCacheEnabled;
    private final ImageTranscoderFactory mImageTranscoderFactory;
    private final boolean mIsEncodedMemoryCacheProbingEnabled;
    private final boolean mIsDiskCacheProbingEnabled;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mNetworkFetchSequence;
    @VisibleForTesting
    Producer<EncodedImage> mBackgroundLocalFileFetchToEncodedMemorySequence;
    @VisibleForTesting
    Producer<EncodedImage> mBackgroundLocalContentUriFetchToEncodedMemorySequence;
    @VisibleForTesting
    Producer<EncodedImage> mBackgroundNetworkFetchToEncodedMemorySequence;
    @VisibleForTesting
    Producer<CloseableReference<PooledByteBuffer>> mLocalFileEncodedImageProducerSequence;
    @VisibleForTesting
    Producer<CloseableReference<PooledByteBuffer>> mLocalContentUriEncodedImageProducerSequence;
    @VisibleForTesting
    Producer<CloseableReference<PooledByteBuffer>> mNetworkEncodedImageProducerSequence;
    @VisibleForTesting
    Producer<Void> mLocalFileFetchToEncodedMemoryPrefetchSequence;
    @VisibleForTesting
    Producer<Void> mNetworkFetchToEncodedMemoryPrefetchSequence;
    private Producer<EncodedImage> mCommonNetworkFetchToEncodedMemorySequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalImageFileFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalVideoFileFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalContentUriFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalResourceFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalAssetFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mDataFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mQualifiedResourceFetchSequence;
    @VisibleForTesting
    Map<Producer<CloseableReference<CloseableImage>>, Producer<CloseableReference<CloseableImage>>> mPostprocessorSequences;
    @VisibleForTesting
    Map<Producer<CloseableReference<CloseableImage>>, Producer<Void>> mCloseableImagePrefetchSequences;
    @VisibleForTesting
    Map<Producer<CloseableReference<CloseableImage>>, Producer<CloseableReference<CloseableImage>>> mBitmapPrepareSequences;

    public ProducerSequenceFactory(ContentResolver contentResolver, ProducerFactory producerFactory, NetworkFetcher networkFetcher, boolean resizeAndRotateEnabledForNetwork, boolean webpSupportEnabled, ThreadHandoffProducerQueue threadHandoffProducerQueue, boolean downSampleEnabled, boolean useBitmapPrepareToDraw, boolean partialImageCachingEnabled, boolean diskCacheEnabled, ImageTranscoderFactory imageTranscoderFactory, boolean isEncodedMemoryCacheProbingEnabled, boolean isDiskCacheProbingEnabled) {
        this.mContentResolver = contentResolver;
        this.mProducerFactory = producerFactory;
        this.mNetworkFetcher = networkFetcher;
        this.mResizeAndRotateEnabledForNetwork = resizeAndRotateEnabledForNetwork;
        this.mWebpSupportEnabled = webpSupportEnabled;
        this.mPostprocessorSequences = new HashMap<Producer<CloseableReference<CloseableImage>>, Producer<CloseableReference<CloseableImage>>>();
        this.mCloseableImagePrefetchSequences = new HashMap<Producer<CloseableReference<CloseableImage>>, Producer<Void>>();
        this.mBitmapPrepareSequences = new HashMap<Producer<CloseableReference<CloseableImage>>, Producer<CloseableReference<CloseableImage>>>();
        this.mThreadHandoffProducerQueue = threadHandoffProducerQueue;
        this.mDownsampleEnabled = downSampleEnabled;
        this.mUseBitmapPrepareToDraw = useBitmapPrepareToDraw;
        this.mPartialImageCachingEnabled = partialImageCachingEnabled;
        this.mDiskCacheEnabled = diskCacheEnabled;
        this.mImageTranscoderFactory = imageTranscoderFactory;
        this.mIsEncodedMemoryCacheProbingEnabled = isEncodedMemoryCacheProbingEnabled;
        this.mIsDiskCacheProbingEnabled = isDiskCacheProbingEnabled;
    }

    public Producer<CloseableReference<PooledByteBuffer>> getEncodedImageProducerSequence(ImageRequest imageRequest) {
        try {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getEncodedImageProducerSequence");
            }
            ProducerSequenceFactory.validateEncodedImageRequest(imageRequest);
            Uri uri = imageRequest.getSourceUri();
            switch (imageRequest.getSourceUriType()) {
                case 0: {
                    Producer<CloseableReference<PooledByteBuffer>> producer = this.getNetworkFetchEncodedImageProducerSequence();
                    return producer;
                }
                case 2: 
                case 3: {
                    Producer<CloseableReference<PooledByteBuffer>> producer = this.getLocalFileFetchEncodedImageProducerSequence();
                    return producer;
                }
                case 4: {
                    Producer<CloseableReference<PooledByteBuffer>> producer = this.getLocalContentUriFetchEncodedImageProducerSequence();
                    return producer;
                }
            }
            throw new IllegalArgumentException("Unsupported uri scheme for encoded image fetch! Uri is: " + ProducerSequenceFactory.getShortenedUriString(uri));
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Producer<CloseableReference<PooledByteBuffer>> getNetworkFetchEncodedImageProducerSequence() {
        ProducerSequenceFactory producerSequenceFactory = this;
        synchronized (producerSequenceFactory) {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getNetworkFetchEncodedImageProducerSequence");
            }
            if (this.mNetworkEncodedImageProducerSequence == null) {
                if (FrescoSystrace.isTracing()) {
                    FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getNetworkFetchEncodedImageProducerSequence:init");
                }
                this.mNetworkEncodedImageProducerSequence = new RemoveImageTransformMetaDataProducer(this.getBackgroundNetworkFetchToEncodedMemorySequence());
                if (FrescoSystrace.isTracing()) {
                    FrescoSystrace.endSection();
                }
            }
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
        return this.mNetworkEncodedImageProducerSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Producer<CloseableReference<PooledByteBuffer>> getLocalFileFetchEncodedImageProducerSequence() {
        ProducerSequenceFactory producerSequenceFactory = this;
        synchronized (producerSequenceFactory) {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getLocalFileFetchEncodedImageProducerSequence");
            }
            if (this.mLocalFileEncodedImageProducerSequence == null) {
                if (FrescoSystrace.isTracing()) {
                    FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getLocalFileFetchEncodedImageProducerSequence:init");
                }
                this.mLocalFileEncodedImageProducerSequence = new RemoveImageTransformMetaDataProducer(this.getBackgroundLocalFileFetchToEncodeMemorySequence());
                if (FrescoSystrace.isTracing()) {
                    FrescoSystrace.endSection();
                }
            }
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
        return this.mLocalFileEncodedImageProducerSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Producer<CloseableReference<PooledByteBuffer>> getLocalContentUriFetchEncodedImageProducerSequence() {
        ProducerSequenceFactory producerSequenceFactory = this;
        synchronized (producerSequenceFactory) {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getLocalContentUriFetchEncodedImageProducerSequence");
            }
            if (this.mLocalContentUriEncodedImageProducerSequence == null) {
                if (FrescoSystrace.isTracing()) {
                    FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getLocalContentUriFetchEncodedImageProducerSequence:init");
                }
                this.mLocalContentUriEncodedImageProducerSequence = new RemoveImageTransformMetaDataProducer(this.getBackgroundLocalContentUriFetchToEncodeMemorySequence());
                if (FrescoSystrace.isTracing()) {
                    FrescoSystrace.endSection();
                }
            }
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
        return this.mLocalContentUriEncodedImageProducerSequence;
    }

    public Producer<Void> getEncodedImagePrefetchProducerSequence(ImageRequest imageRequest) {
        ProducerSequenceFactory.validateEncodedImageRequest(imageRequest);
        switch (imageRequest.getSourceUriType()) {
            case 0: {
                return this.getNetworkFetchToEncodedMemoryPrefetchSequence();
            }
            case 2: 
            case 3: {
                return this.getLocalFileFetchToEncodedMemoryPrefetchSequence();
            }
        }
        Uri uri = imageRequest.getSourceUri();
        throw new IllegalArgumentException("Unsupported uri scheme for encoded image fetch! Uri is: " + ProducerSequenceFactory.getShortenedUriString(uri));
    }

    private static void validateEncodedImageRequest(ImageRequest imageRequest) {
        Preconditions.checkNotNull((Object)imageRequest);
        Preconditions.checkArgument((imageRequest.getLowestPermittedRequestLevel().getValue() <= ImageRequest.RequestLevel.ENCODED_MEMORY_CACHE.getValue() ? 1 : 0) != 0);
    }

    public Producer<CloseableReference<CloseableImage>> getDecodedImageProducerSequence(ImageRequest imageRequest) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getDecodedImageProducerSequence");
        }
        Producer<CloseableReference<CloseableImage>> pipelineSequence = this.getBasicDecodedImageSequence(imageRequest);
        if (imageRequest.getPostprocessor() != null) {
            pipelineSequence = this.getPostprocessorSequence(pipelineSequence);
        }
        if (this.mUseBitmapPrepareToDraw) {
            pipelineSequence = this.getBitmapPrepareSequence(pipelineSequence);
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        return pipelineSequence;
    }

    public Producer<Void> getDecodedImagePrefetchProducerSequence(ImageRequest imageRequest) {
        Producer<CloseableReference<CloseableImage>> inputProducer = this.getBasicDecodedImageSequence(imageRequest);
        if (this.mUseBitmapPrepareToDraw) {
            inputProducer = this.getBitmapPrepareSequence(inputProducer);
        }
        return this.getDecodedImagePrefetchSequence(inputProducer);
    }

    private Producer<CloseableReference<CloseableImage>> getBasicDecodedImageSequence(ImageRequest imageRequest) {
        try {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getBasicDecodedImageSequence");
            }
            Preconditions.checkNotNull((Object)imageRequest);
            Uri uri = imageRequest.getSourceUri();
            Preconditions.checkNotNull((Object)uri, (Object)"Uri is null.");
            switch (imageRequest.getSourceUriType()) {
                case 0: {
                    Producer<CloseableReference<CloseableImage>> producer = this.getNetworkFetchSequence();
                    return producer;
                }
                case 2: {
                    Producer<CloseableReference<CloseableImage>> producer = this.getLocalVideoFileFetchSequence();
                    return producer;
                }
                case 3: {
                    Producer<CloseableReference<CloseableImage>> producer = this.getLocalImageFileFetchSequence();
                    return producer;
                }
                case 4: {
                    if (MediaUtils.isVideo((String)this.mContentResolver.getType(uri))) {
                        Producer<CloseableReference<CloseableImage>> producer = this.getLocalVideoFileFetchSequence();
                        return producer;
                    }
                    Producer<CloseableReference<CloseableImage>> producer = this.getLocalContentUriFetchSequence();
                    return producer;
                }
                case 5: {
                    Producer<CloseableReference<CloseableImage>> producer = this.getLocalAssetFetchSequence();
                    return producer;
                }
                case 6: {
                    Producer<CloseableReference<CloseableImage>> producer = this.getLocalResourceFetchSequence();
                    return producer;
                }
                case 8: {
                    Producer<CloseableReference<CloseableImage>> producer = this.getQualifiedResourceFetchSequence();
                    return producer;
                }
                case 7: {
                    Producer<CloseableReference<CloseableImage>> producer = this.getDataFetchSequence();
                    return producer;
                }
            }
            throw new IllegalArgumentException("Unsupported uri scheme! Uri is: " + ProducerSequenceFactory.getShortenedUriString(uri));
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getNetworkFetchSequence() {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getNetworkFetchSequence");
        }
        if (this.mNetworkFetchSequence == null) {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getNetworkFetchSequence:init");
            }
            this.mNetworkFetchSequence = this.newBitmapCacheGetToDecodeSequence(this.getCommonNetworkFetchToEncodedMemorySequence());
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        return this.mNetworkFetchSequence;
    }

    private synchronized Producer<EncodedImage> getBackgroundNetworkFetchToEncodedMemorySequence() {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getBackgroundNetworkFetchToEncodedMemorySequence");
        }
        if (this.mBackgroundNetworkFetchToEncodedMemorySequence == null) {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getBackgroundNetworkFetchToEncodedMemorySequence:init");
            }
            this.mBackgroundNetworkFetchToEncodedMemorySequence = this.mProducerFactory.newBackgroundThreadHandoffProducer(this.getCommonNetworkFetchToEncodedMemorySequence(), this.mThreadHandoffProducerQueue);
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        return this.mBackgroundNetworkFetchToEncodedMemorySequence;
    }

    private synchronized Producer<Void> getNetworkFetchToEncodedMemoryPrefetchSequence() {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getNetworkFetchToEncodedMemoryPrefetchSequence");
        }
        if (this.mNetworkFetchToEncodedMemoryPrefetchSequence == null) {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getNetworkFetchToEncodedMemoryPrefetchSequence:init");
            }
            this.mNetworkFetchToEncodedMemoryPrefetchSequence = ProducerFactory.newSwallowResultProducer(this.getBackgroundNetworkFetchToEncodedMemorySequence());
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        return this.mNetworkFetchToEncodedMemoryPrefetchSequence;
    }

    private synchronized Producer<EncodedImage> getCommonNetworkFetchToEncodedMemorySequence() {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getCommonNetworkFetchToEncodedMemorySequence");
        }
        if (this.mCommonNetworkFetchToEncodedMemorySequence == null) {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getCommonNetworkFetchToEncodedMemorySequence:init");
            }
            Producer<EncodedImage> inputProducer = this.newEncodedCacheMultiplexToTranscodeSequence(this.mProducerFactory.newNetworkFetchProducer(this.mNetworkFetcher));
            this.mCommonNetworkFetchToEncodedMemorySequence = ProducerFactory.newAddImageTransformMetaDataProducer(inputProducer);
            this.mCommonNetworkFetchToEncodedMemorySequence = this.mProducerFactory.newResizeAndRotateProducer(this.mCommonNetworkFetchToEncodedMemorySequence, this.mResizeAndRotateEnabledForNetwork && !this.mDownsampleEnabled, this.mImageTranscoderFactory);
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        return this.mCommonNetworkFetchToEncodedMemorySequence;
    }

    private synchronized Producer<Void> getLocalFileFetchToEncodedMemoryPrefetchSequence() {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getLocalFileFetchToEncodedMemoryPrefetchSequence");
        }
        if (this.mLocalFileFetchToEncodedMemoryPrefetchSequence == null) {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getLocalFileFetchToEncodedMemoryPrefetchSequence:init");
            }
            this.mLocalFileFetchToEncodedMemoryPrefetchSequence = ProducerFactory.newSwallowResultProducer(this.getBackgroundLocalFileFetchToEncodeMemorySequence());
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        return this.mLocalFileFetchToEncodedMemoryPrefetchSequence;
    }

    private synchronized Producer<EncodedImage> getBackgroundLocalFileFetchToEncodeMemorySequence() {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getBackgroundLocalFileFetchToEncodeMemorySequence");
        }
        if (this.mBackgroundLocalFileFetchToEncodedMemorySequence == null) {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getBackgroundLocalFileFetchToEncodeMemorySequence:init");
            }
            LocalFileFetchProducer localFileFetchProducer = this.mProducerFactory.newLocalFileFetchProducer();
            Producer<EncodedImage> toEncodedMultiplexProducer = this.newEncodedCacheMultiplexToTranscodeSequence(localFileFetchProducer);
            this.mBackgroundLocalFileFetchToEncodedMemorySequence = this.mProducerFactory.newBackgroundThreadHandoffProducer(toEncodedMultiplexProducer, this.mThreadHandoffProducerQueue);
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        return this.mBackgroundLocalFileFetchToEncodedMemorySequence;
    }

    private synchronized Producer<EncodedImage> getBackgroundLocalContentUriFetchToEncodeMemorySequence() {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getBackgroundLocalContentUriFetchToEncodeMemorySequence");
        }
        if (this.mBackgroundLocalContentUriFetchToEncodedMemorySequence == null) {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"ProducerSequenceFactory#getBackgroundLocalContentUriFetchToEncodeMemorySequence:init");
            }
            LocalContentUriFetchProducer localFileFetchProducer = this.mProducerFactory.newLocalContentUriFetchProducer();
            Producer<EncodedImage> toEncodedMultiplexProducer = this.newEncodedCacheMultiplexToTranscodeSequence(localFileFetchProducer);
            this.mBackgroundLocalContentUriFetchToEncodedMemorySequence = this.mProducerFactory.newBackgroundThreadHandoffProducer(toEncodedMultiplexProducer, this.mThreadHandoffProducerQueue);
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        return this.mBackgroundLocalContentUriFetchToEncodedMemorySequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalImageFileFetchSequence() {
        if (this.mLocalImageFileFetchSequence == null) {
            LocalFileFetchProducer localFileFetchProducer = this.mProducerFactory.newLocalFileFetchProducer();
            this.mLocalImageFileFetchSequence = this.newBitmapCacheGetToLocalTransformSequence(localFileFetchProducer);
        }
        return this.mLocalImageFileFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalVideoFileFetchSequence() {
        if (this.mLocalVideoFileFetchSequence == null) {
            LocalVideoThumbnailProducer localVideoThumbnailProducer = this.mProducerFactory.newLocalVideoThumbnailProducer();
            this.mLocalVideoFileFetchSequence = this.newBitmapCacheGetToBitmapCacheSequence(localVideoThumbnailProducer);
        }
        return this.mLocalVideoFileFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalContentUriFetchSequence() {
        if (this.mLocalContentUriFetchSequence == null) {
            LocalContentUriFetchProducer localContentUriFetchProducer = this.mProducerFactory.newLocalContentUriFetchProducer();
            ThumbnailProducer[] thumbnailProducers = new ThumbnailProducer[]{this.mProducerFactory.newLocalContentUriThumbnailFetchProducer(), this.mProducerFactory.newLocalExifThumbnailProducer()};
            this.mLocalContentUriFetchSequence = this.newBitmapCacheGetToLocalTransformSequence(localContentUriFetchProducer, thumbnailProducers);
        }
        return this.mLocalContentUriFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getQualifiedResourceFetchSequence() {
        if (this.mQualifiedResourceFetchSequence == null) {
            QualifiedResourceFetchProducer qualifiedResourceFetchProducer = this.mProducerFactory.newQualifiedResourceFetchProducer();
            this.mQualifiedResourceFetchSequence = this.newBitmapCacheGetToLocalTransformSequence(qualifiedResourceFetchProducer);
        }
        return this.mQualifiedResourceFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalResourceFetchSequence() {
        if (this.mLocalResourceFetchSequence == null) {
            LocalResourceFetchProducer localResourceFetchProducer = this.mProducerFactory.newLocalResourceFetchProducer();
            this.mLocalResourceFetchSequence = this.newBitmapCacheGetToLocalTransformSequence(localResourceFetchProducer);
        }
        return this.mLocalResourceFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalAssetFetchSequence() {
        if (this.mLocalAssetFetchSequence == null) {
            LocalAssetFetchProducer localAssetFetchProducer = this.mProducerFactory.newLocalAssetFetchProducer();
            this.mLocalAssetFetchSequence = this.newBitmapCacheGetToLocalTransformSequence(localAssetFetchProducer);
        }
        return this.mLocalAssetFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getDataFetchSequence() {
        if (this.mDataFetchSequence == null) {
            Producer<EncodedImage> inputProducer = this.mProducerFactory.newDataFetchProducer();
            if (WebpSupportStatus.sIsWebpSupportRequired && (!this.mWebpSupportEnabled || WebpSupportStatus.sWebpBitmapFactory == null)) {
                inputProducer = this.mProducerFactory.newWebpTranscodeProducer(inputProducer);
            }
            inputProducer = ProducerFactory.newAddImageTransformMetaDataProducer(inputProducer);
            inputProducer = this.mProducerFactory.newResizeAndRotateProducer(inputProducer, true, this.mImageTranscoderFactory);
            this.mDataFetchSequence = this.newBitmapCacheGetToDecodeSequence(inputProducer);
        }
        return this.mDataFetchSequence;
    }

    private Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToLocalTransformSequence(Producer<EncodedImage> inputProducer) {
        ThumbnailProducer[] defaultThumbnailProducers = new ThumbnailProducer[]{this.mProducerFactory.newLocalExifThumbnailProducer()};
        return this.newBitmapCacheGetToLocalTransformSequence(inputProducer, defaultThumbnailProducers);
    }

    private Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToLocalTransformSequence(Producer<EncodedImage> inputProducer, ThumbnailProducer<EncodedImage>[] thumbnailProducers) {
        inputProducer = this.newEncodedCacheMultiplexToTranscodeSequence(inputProducer);
        Producer<EncodedImage> inputProducerAfterDecode = this.newLocalTransformationsSequence(inputProducer, thumbnailProducers);
        return this.newBitmapCacheGetToDecodeSequence(inputProducerAfterDecode);
    }

    private Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToDecodeSequence(Producer<EncodedImage> inputProducer) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"ProducerSequenceFactory#newBitmapCacheGetToDecodeSequence");
        }
        DecodeProducer decodeProducer = this.mProducerFactory.newDecodeProducer(inputProducer);
        Producer<CloseableReference<CloseableImage>> result = this.newBitmapCacheGetToBitmapCacheSequence(decodeProducer);
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        return result;
    }

    private Producer<EncodedImage> newEncodedCacheMultiplexToTranscodeSequence(Producer<EncodedImage> inputProducer) {
        if (WebpSupportStatus.sIsWebpSupportRequired && (!this.mWebpSupportEnabled || WebpSupportStatus.sWebpBitmapFactory == null)) {
            inputProducer = this.mProducerFactory.newWebpTranscodeProducer(inputProducer);
        }
        if (this.mDiskCacheEnabled) {
            inputProducer = this.newDiskCacheSequence(inputProducer);
        }
        EncodedMemoryCacheProducer encodedMemoryCacheProducer = this.mProducerFactory.newEncodedMemoryCacheProducer(inputProducer);
        if (this.mIsDiskCacheProbingEnabled) {
            EncodedProbeProducer probeProducer = this.mProducerFactory.newEncodedProbeProducer(encodedMemoryCacheProducer);
            return this.mProducerFactory.newEncodedCacheKeyMultiplexProducer(probeProducer);
        }
        return this.mProducerFactory.newEncodedCacheKeyMultiplexProducer(encodedMemoryCacheProducer);
    }

    private Producer<EncodedImage> newDiskCacheSequence(Producer<EncodedImage> inputProducer) {
        DiskCacheWriteProducer cacheWriteProducer;
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"ProducerSequenceFactory#newDiskCacheSequence");
        }
        if (this.mPartialImageCachingEnabled) {
            PartialDiskCacheProducer partialDiskCacheProducer = this.mProducerFactory.newPartialDiskCacheProducer(inputProducer);
            cacheWriteProducer = this.mProducerFactory.newDiskCacheWriteProducer(partialDiskCacheProducer);
        } else {
            cacheWriteProducer = this.mProducerFactory.newDiskCacheWriteProducer(inputProducer);
        }
        DiskCacheReadProducer result = this.mProducerFactory.newDiskCacheReadProducer(cacheWriteProducer);
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        return result;
    }

    private Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToBitmapCacheSequence(Producer<CloseableReference<CloseableImage>> inputProducer) {
        BitmapMemoryCacheProducer bitmapMemoryCacheProducer = this.mProducerFactory.newBitmapMemoryCacheProducer(inputProducer);
        BitmapMemoryCacheKeyMultiplexProducer bitmapKeyMultiplexProducer = this.mProducerFactory.newBitmapMemoryCacheKeyMultiplexProducer(bitmapMemoryCacheProducer);
        ThreadHandoffProducer<CloseableReference<CloseableImage>> threadHandoffProducer = this.mProducerFactory.newBackgroundThreadHandoffProducer(bitmapKeyMultiplexProducer, this.mThreadHandoffProducerQueue);
        if (this.mIsEncodedMemoryCacheProbingEnabled || this.mIsDiskCacheProbingEnabled) {
            BitmapMemoryCacheGetProducer bitmapMemoryCacheGetProducer = this.mProducerFactory.newBitmapMemoryCacheGetProducer(threadHandoffProducer);
            return this.mProducerFactory.newBitmapProbeProducer(bitmapMemoryCacheGetProducer);
        }
        return this.mProducerFactory.newBitmapMemoryCacheGetProducer(threadHandoffProducer);
    }

    private Producer<EncodedImage> newLocalTransformationsSequence(Producer<EncodedImage> inputProducer, ThumbnailProducer<EncodedImage>[] thumbnailProducers) {
        Producer<EncodedImage> localImageProducer = ProducerFactory.newAddImageTransformMetaDataProducer(inputProducer);
        localImageProducer = this.mProducerFactory.newResizeAndRotateProducer(localImageProducer, true, this.mImageTranscoderFactory);
        ThrottlingProducer<EncodedImage> localImageThrottlingProducer = this.mProducerFactory.newThrottlingProducer(localImageProducer);
        return ProducerFactory.newBranchOnSeparateImagesProducer(this.newLocalThumbnailProducer(thumbnailProducers), localImageThrottlingProducer);
    }

    private Producer<EncodedImage> newLocalThumbnailProducer(ThumbnailProducer<EncodedImage>[] thumbnailProducers) {
        ThumbnailBranchProducer thumbnailBranchProducer = this.mProducerFactory.newThumbnailBranchProducer(thumbnailProducers);
        return this.mProducerFactory.newResizeAndRotateProducer(thumbnailBranchProducer, true, this.mImageTranscoderFactory);
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getPostprocessorSequence(Producer<CloseableReference<CloseableImage>> inputProducer) {
        if (!this.mPostprocessorSequences.containsKey(inputProducer)) {
            PostprocessorProducer postprocessorProducer = this.mProducerFactory.newPostprocessorProducer(inputProducer);
            PostprocessedBitmapMemoryCacheProducer postprocessedBitmapMemoryCacheProducer = this.mProducerFactory.newPostprocessorBitmapMemoryCacheProducer(postprocessorProducer);
            this.mPostprocessorSequences.put(inputProducer, postprocessedBitmapMemoryCacheProducer);
        }
        return this.mPostprocessorSequences.get(inputProducer);
    }

    private synchronized Producer<Void> getDecodedImagePrefetchSequence(Producer<CloseableReference<CloseableImage>> inputProducer) {
        if (!this.mCloseableImagePrefetchSequences.containsKey(inputProducer)) {
            SwallowResultProducer<CloseableReference<CloseableImage>> swallowResultProducer = ProducerFactory.newSwallowResultProducer(inputProducer);
            this.mCloseableImagePrefetchSequences.put(inputProducer, swallowResultProducer);
        }
        return this.mCloseableImagePrefetchSequences.get(inputProducer);
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getBitmapPrepareSequence(Producer<CloseableReference<CloseableImage>> inputProducer) {
        BitmapPrepareProducer bitmapPrepareProducer = this.mBitmapPrepareSequences.get(inputProducer);
        if (bitmapPrepareProducer == null) {
            bitmapPrepareProducer = this.mProducerFactory.newBitmapPrepareProducer(inputProducer);
            this.mBitmapPrepareSequences.put(inputProducer, bitmapPrepareProducer);
        }
        return bitmapPrepareProducer;
    }

    private static String getShortenedUriString(Uri uri) {
        String uriString = String.valueOf(uri);
        return uriString.length() > 30 ? uriString.substring(0, 30) + "..." : uriString;
    }
}

