/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.util.SparseIntArray;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.ByteArrayPool;
import com.facebook.common.memory.MemoryTrimmableRegistry;
import com.facebook.imagepipeline.memory.BasePool;
import com.facebook.imagepipeline.memory.PoolParams;
import com.facebook.imagepipeline.memory.PoolStatsTracker;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class GenericByteArrayPool
extends BasePool<byte[]>
implements ByteArrayPool {
    private final int[] mBucketSizes;

    public GenericByteArrayPool(MemoryTrimmableRegistry memoryTrimmableRegistry, PoolParams poolParams, PoolStatsTracker poolStatsTracker) {
        super(memoryTrimmableRegistry, poolParams, poolStatsTracker);
        SparseIntArray bucketSizes = poolParams.bucketSizes;
        this.mBucketSizes = new int[bucketSizes.size()];
        for (int i = 0; i < bucketSizes.size(); ++i) {
            this.mBucketSizes[i] = bucketSizes.keyAt(i);
        }
        this.initialize();
    }

    public int getMinBufferSize() {
        return this.mBucketSizes[0];
    }

    @Override
    protected byte[] alloc(int bucketedSize) {
        return new byte[bucketedSize];
    }

    @Override
    protected void free(byte[] value) {
        Preconditions.checkNotNull((Object)value);
    }

    @Override
    protected int getSizeInBytes(int bucketedSize) {
        return bucketedSize;
    }

    @Override
    protected int getBucketedSize(int requestSize) {
        int intRequestSize = requestSize;
        if (intRequestSize <= 0) {
            throw new BasePool.InvalidSizeException(requestSize);
        }
        for (int bucketedSize : this.mBucketSizes) {
            if (bucketedSize < intRequestSize) continue;
            return bucketedSize;
        }
        return requestSize;
    }

    @Override
    protected int getBucketedSizeForValue(byte[] value) {
        Preconditions.checkNotNull((Object)value);
        return value.length;
    }
}

