/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import bolts.Task;
import com.facebook.binaryresource.BinaryResource;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.WriterCallback;
import com.facebook.cache.disk.FileCache;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.memory.PooledByteStreams;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.ImageCacheStatsTracker;
import com.facebook.imagepipeline.cache.StagingArea;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.instrumentation.FrescoInstrumenter;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import com.facebook.infer.annotation.Nullsafe;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class BufferedDiskCache {
    private static final Class<?> TAG = BufferedDiskCache.class;
    private final FileCache mFileCache;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final PooledByteStreams mPooledByteStreams;
    private final Executor mReadExecutor;
    private final Executor mWriteExecutor;
    private final StagingArea mStagingArea;
    private final ImageCacheStatsTracker mImageCacheStatsTracker;

    public BufferedDiskCache(FileCache fileCache, PooledByteBufferFactory pooledByteBufferFactory, PooledByteStreams pooledByteStreams, Executor readExecutor, Executor writeExecutor, ImageCacheStatsTracker imageCacheStatsTracker) {
        this.mFileCache = fileCache;
        this.mPooledByteBufferFactory = pooledByteBufferFactory;
        this.mPooledByteStreams = pooledByteStreams;
        this.mReadExecutor = readExecutor;
        this.mWriteExecutor = writeExecutor;
        this.mImageCacheStatsTracker = imageCacheStatsTracker;
        this.mStagingArea = StagingArea.getInstance();
    }

    public boolean containsSync(CacheKey key) {
        return this.mStagingArea.containsKey(key) || this.mFileCache.hasKeySync(key);
    }

    public Task<Boolean> contains(CacheKey key) {
        if (this.containsSync(key)) {
            return Task.forResult((Object)true);
        }
        return this.containsAsync(key);
    }

    private Task<Boolean> containsAsync(final CacheKey key) {
        try {
            final Object token = FrescoInstrumenter.onBeforeSubmitWork((String)"BufferedDiskCache_containsAsync");
            return Task.call((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    Object currentToken = FrescoInstrumenter.onBeginWork((Object)token, null);
                    try {
                        Boolean bl = BufferedDiskCache.this.checkInStagingAreaAndFileCache(key);
                        return bl;
                    }
                    catch (Throwable th) {
                        FrescoInstrumenter.markFailure((Object)token, (Throwable)th);
                        throw th;
                    }
                    finally {
                        FrescoInstrumenter.onEndWork((Object)currentToken);
                    }
                }
            }, (Executor)this.mReadExecutor);
        }
        catch (Exception exception) {
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache read for %s", (Object[])new Object[]{key.getUriString()});
            return Task.forError((Exception)exception);
        }
    }

    public boolean diskCheckSync(CacheKey key) {
        if (this.containsSync(key)) {
            return true;
        }
        return this.checkInStagingAreaAndFileCache(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<EncodedImage> get(CacheKey key, AtomicBoolean isCancelled) {
        try {
            EncodedImage pinnedImage;
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"BufferedDiskCache#get");
            }
            if ((pinnedImage = this.mStagingArea.get(key)) != null) {
                Task<EncodedImage> task = this.foundPinnedImage(key, pinnedImage);
                return task;
            }
            Task<EncodedImage> task = this.getAsync(key, isCancelled);
            return task;
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    public Task<Void> probe(final CacheKey key) {
        Preconditions.checkNotNull((Object)key);
        try {
            final Object token = FrescoInstrumenter.onBeforeSubmitWork((String)"BufferedDiskCache_probe");
            return Task.call((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Object currentToken = FrescoInstrumenter.onBeginWork((Object)token, null);
                    try {
                        BufferedDiskCache.this.mFileCache.probe(key);
                    }
                    finally {
                        FrescoInstrumenter.onEndWork((Object)currentToken);
                    }
                    return null;
                }
            }, (Executor)this.mWriteExecutor);
        }
        catch (Exception exception) {
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache probe for %s", (Object[])new Object[]{key.getUriString()});
            return Task.forError((Exception)exception);
        }
    }

    public void addKeyForAsyncProbing(CacheKey key) {
        Preconditions.checkNotNull((Object)key);
        this.mFileCache.probe(key);
    }

    private boolean checkInStagingAreaAndFileCache(CacheKey key) {
        EncodedImage result = this.mStagingArea.get(key);
        if (result != null) {
            result.close();
            FLog.v(TAG, (String)"Found image for %s in staging area", (Object)key.getUriString());
            this.mImageCacheStatsTracker.onStagingAreaHit(key);
            return true;
        }
        FLog.v(TAG, (String)"Did not find image for %s in staging area", (Object)key.getUriString());
        this.mImageCacheStatsTracker.onStagingAreaMiss(key);
        try {
            return this.mFileCache.hasKey(key);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Task<EncodedImage> getAsync(final CacheKey key, final AtomicBoolean isCancelled) {
        try {
            final Object token = FrescoInstrumenter.onBeforeSubmitWork((String)"BufferedDiskCache_getAsync");
            return Task.call((Callable)new Callable<EncodedImage>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @Nullable
                public EncodedImage call() throws Exception {
                    Object currentToken = FrescoInstrumenter.onBeginWork((Object)token, null);
                    try {
                        if (isCancelled.get()) {
                            throw new CancellationException();
                        }
                        EncodedImage result = BufferedDiskCache.this.mStagingArea.get(key);
                        if (result != null) {
                            FLog.v((Class)TAG, (String)"Found image for %s in staging area", (Object)key.getUriString());
                            BufferedDiskCache.this.mImageCacheStatsTracker.onStagingAreaHit(key);
                        } else {
                            PooledByteBuffer buffer;
                            block18: {
                                FLog.v((Class)TAG, (String)"Did not find image for %s in staging area", (Object)key.getUriString());
                                BufferedDiskCache.this.mImageCacheStatsTracker.onStagingAreaMiss(key);
                                try {
                                    buffer = BufferedDiskCache.this.readFromDiskCache(key);
                                    if (buffer != null) break block18;
                                    EncodedImage encodedImage = null;
                                    return encodedImage;
                                }
                                catch (Exception exception) {
                                    EncodedImage encodedImage = null;
                                    FrescoInstrumenter.onEndWork((Object)currentToken);
                                    return encodedImage;
                                }
                            }
                            CloseableReference ref = CloseableReference.of((Closeable)buffer);
                            try {
                                result = new EncodedImage(ref);
                            }
                            finally {
                                CloseableReference.closeSafely((CloseableReference)ref);
                            }
                        }
                        if (Thread.interrupted()) {
                            FLog.v((Class)TAG, (String)"Host thread was interrupted, decreasing reference count");
                            if (result != null) {
                                result.close();
                            }
                            throw new InterruptedException();
                        }
                        EncodedImage encodedImage = result;
                        return encodedImage;
                    }
                    catch (Throwable th) {
                        FrescoInstrumenter.markFailure((Object)token, (Throwable)th);
                        throw th;
                    }
                    finally {
                        FrescoInstrumenter.onEndWork((Object)currentToken);
                    }
                }
            }, (Executor)this.mReadExecutor);
        }
        catch (Exception exception) {
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache read for %s", (Object[])new Object[]{key.getUriString()});
            return Task.forError((Exception)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(final CacheKey key, EncodedImage encodedImage) {
        try {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"BufferedDiskCache#put");
            }
            Preconditions.checkNotNull((Object)key);
            Preconditions.checkArgument((Boolean)EncodedImage.isValid((EncodedImage)encodedImage));
            this.mStagingArea.put(key, encodedImage);
            final EncodedImage finalEncodedImage = EncodedImage.cloneOrNull((EncodedImage)encodedImage);
            try {
                final Object token = FrescoInstrumenter.onBeforeSubmitWork((String)"BufferedDiskCache_putAsync");
                this.mWriteExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Object currentToken = FrescoInstrumenter.onBeginWork((Object)token, null);
                        try {
                            BufferedDiskCache.this.writeToDiskCache(key, finalEncodedImage);
                        }
                        catch (Throwable th) {
                            FrescoInstrumenter.markFailure((Object)token, (Throwable)th);
                            throw th;
                        }
                        finally {
                            BufferedDiskCache.this.mStagingArea.remove(key, finalEncodedImage);
                            EncodedImage.closeSafely((EncodedImage)finalEncodedImage);
                            FrescoInstrumenter.onEndWork((Object)currentToken);
                        }
                    }
                });
            }
            catch (Exception exception) {
                FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache write for %s", (Object[])new Object[]{key.getUriString()});
                this.mStagingArea.remove(key, encodedImage);
                EncodedImage.closeSafely((EncodedImage)finalEncodedImage);
            }
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    public Task<Void> remove(final CacheKey key) {
        Preconditions.checkNotNull((Object)key);
        this.mStagingArea.remove(key);
        try {
            final Object token = FrescoInstrumenter.onBeforeSubmitWork((String)"BufferedDiskCache_remove");
            return Task.call((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Object currentToken = FrescoInstrumenter.onBeginWork((Object)token, null);
                    try {
                        BufferedDiskCache.this.mStagingArea.remove(key);
                        BufferedDiskCache.this.mFileCache.remove(key);
                    }
                    catch (Throwable th) {
                        FrescoInstrumenter.markFailure((Object)token, (Throwable)th);
                        throw th;
                    }
                    finally {
                        FrescoInstrumenter.onEndWork((Object)currentToken);
                    }
                    return null;
                }
            }, (Executor)this.mWriteExecutor);
        }
        catch (Exception exception) {
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache remove for %s", (Object[])new Object[]{key.getUriString()});
            return Task.forError((Exception)exception);
        }
    }

    public Task<Void> clearAll() {
        this.mStagingArea.clearAll();
        final Object token = FrescoInstrumenter.onBeforeSubmitWork((String)"BufferedDiskCache_clearAll");
        try {
            return Task.call((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Object currentToken = FrescoInstrumenter.onBeginWork((Object)token, null);
                    try {
                        BufferedDiskCache.this.mStagingArea.clearAll();
                        BufferedDiskCache.this.mFileCache.clearAll();
                        Void void_ = null;
                        return void_;
                    }
                    catch (Throwable th) {
                        FrescoInstrumenter.markFailure((Object)token, (Throwable)th);
                        throw th;
                    }
                    finally {
                        FrescoInstrumenter.onEndWork((Object)currentToken);
                    }
                }
            }, (Executor)this.mWriteExecutor);
        }
        catch (Exception exception) {
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache clear", (Object[])new Object[0]);
            return Task.forError((Exception)exception);
        }
    }

    public long getSize() {
        return this.mFileCache.getSize();
    }

    private Task<EncodedImage> foundPinnedImage(CacheKey key, EncodedImage pinnedImage) {
        FLog.v(TAG, (String)"Found image for %s in staging area", (Object)key.getUriString());
        this.mImageCacheStatsTracker.onStagingAreaHit(key);
        return Task.forResult((Object)pinnedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private PooledByteBuffer readFromDiskCache(CacheKey key) throws IOException {
        try {
            PooledByteBuffer byteBuffer;
            FLog.v(TAG, (String)"Disk cache read for %s", (Object)key.getUriString());
            BinaryResource diskCacheResource = this.mFileCache.getResource(key);
            if (diskCacheResource == null) {
                FLog.v(TAG, (String)"Disk cache miss for %s", (Object)key.getUriString());
                this.mImageCacheStatsTracker.onDiskCacheMiss(key);
                return null;
            }
            FLog.v(TAG, (String)"Found entry in disk cache for %s", (Object)key.getUriString());
            this.mImageCacheStatsTracker.onDiskCacheHit(key);
            try (InputStream is = diskCacheResource.openStream();){
                byteBuffer = this.mPooledByteBufferFactory.newByteBuffer(is, (int)diskCacheResource.size());
            }
            FLog.v(TAG, (String)"Successful read from disk cache for %s", (Object)key.getUriString());
            return byteBuffer;
        }
        catch (IOException ioe) {
            FLog.w(TAG, (Throwable)ioe, (String)"Exception reading from cache for %s", (Object[])new Object[]{key.getUriString()});
            this.mImageCacheStatsTracker.onDiskCacheGetFail(key);
            throw ioe;
        }
    }

    private void writeToDiskCache(CacheKey key, final EncodedImage encodedImage) {
        FLog.v(TAG, (String)"About to write to disk-cache for key %s", (Object)key.getUriString());
        try {
            this.mFileCache.insert(key, new WriterCallback(){

                public void write(OutputStream os) throws IOException {
                    InputStream inputStream = encodedImage.getInputStream();
                    Preconditions.checkNotNull((Object)inputStream);
                    BufferedDiskCache.this.mPooledByteStreams.copy(inputStream, os);
                }
            });
            this.mImageCacheStatsTracker.onDiskCachePut(key);
            FLog.v(TAG, (String)"Successful disk-cache write for key %s", (Object)key.getUriString());
        }
        catch (IOException ioe) {
            FLog.w(TAG, (Throwable)ioe, (String)"Failed to write to disk-cache for key %s", (Object[])new Object[]{key.getUriString()});
        }
    }
}

