/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.HasImageMetadata;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imagepipeline.producers.BaseConsumer;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener2;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class BitmapMemoryCacheProducer
implements Producer<CloseableReference<CloseableImage>> {
    public static final String PRODUCER_NAME = "BitmapMemoryCacheProducer";
    public static final String EXTRA_CACHED_VALUE_FOUND = "cached_value_found";
    private static final String ORIGIN_SUBCATEGORY = "pipe_bg";
    private final MemoryCache<CacheKey, CloseableImage> mMemoryCache;
    private final CacheKeyFactory mCacheKeyFactory;
    private final Producer<CloseableReference<CloseableImage>> mInputProducer;

    public BitmapMemoryCacheProducer(MemoryCache<CacheKey, CloseableImage> memoryCache, CacheKeyFactory cacheKeyFactory, Producer<CloseableReference<CloseableImage>> inputProducer) {
        this.mMemoryCache = memoryCache;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mInputProducer = inputProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceResults(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext) {
        try {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"BitmapMemoryCacheProducer#produceResults");
            }
            ProducerListener2 listener = producerContext.getProducerListener();
            listener.onProducerStart(producerContext, this.getProducerName());
            ImageRequest imageRequest = producerContext.getImageRequest();
            Object callerContext = producerContext.getCallerContext();
            CacheKey cacheKey = this.mCacheKeyFactory.getBitmapCacheKey(imageRequest, callerContext);
            CloseableReference cachedReference = this.mMemoryCache.get((Object)cacheKey);
            if (cachedReference != null) {
                BitmapMemoryCacheProducer.maybeSetExtrasFromCloseableImage((HasImageMetadata)cachedReference.get(), producerContext);
                boolean isFinal = ((CloseableImage)cachedReference.get()).getQualityInfo().isOfFullQuality();
                if (isFinal) {
                    listener.onProducerFinishWithSuccess(producerContext, this.getProducerName(), listener.requiresExtraMap(producerContext, this.getProducerName()) ? ImmutableMap.of((Object)EXTRA_CACHED_VALUE_FOUND, (Object)"true") : null);
                    listener.onUltimateProducerReached(producerContext, this.getProducerName(), true);
                    producerContext.putOriginExtra("memory_bitmap", this.getOriginSubcategory());
                    consumer.onProgressUpdate(1.0f);
                }
                consumer.onNewResult((CloseableReference<CloseableImage>)cachedReference, BaseConsumer.simpleStatusForIsLast(isFinal));
                cachedReference.close();
                if (isFinal) {
                    return;
                }
            }
            if (producerContext.getLowestPermittedRequestLevel().getValue() >= ImageRequest.RequestLevel.BITMAP_MEMORY_CACHE.getValue()) {
                listener.onProducerFinishWithSuccess(producerContext, this.getProducerName(), listener.requiresExtraMap(producerContext, this.getProducerName()) ? ImmutableMap.of((Object)EXTRA_CACHED_VALUE_FOUND, (Object)"false") : null);
                listener.onUltimateProducerReached(producerContext, this.getProducerName(), false);
                producerContext.putOriginExtra("memory_bitmap", this.getOriginSubcategory());
                consumer.onNewResult(null, 1);
                return;
            }
            Consumer<CloseableReference<CloseableImage>> wrappedConsumer = this.wrapConsumer(consumer, cacheKey, producerContext.getImageRequest().isMemoryCacheEnabled());
            listener.onProducerFinishWithSuccess(producerContext, this.getProducerName(), listener.requiresExtraMap(producerContext, this.getProducerName()) ? ImmutableMap.of((Object)EXTRA_CACHED_VALUE_FOUND, (Object)"false") : null);
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"mInputProducer.produceResult");
            }
            this.mInputProducer.produceResults(wrappedConsumer, producerContext);
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    protected Consumer<CloseableReference<CloseableImage>> wrapConsumer(Consumer<CloseableReference<CloseableImage>> consumer, final CacheKey cacheKey, final boolean isMemoryCacheEnabled) {
        return new DelegatingConsumer<CloseableReference<CloseableImage>, CloseableReference<CloseableImage>>(consumer){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNewResultImpl(@Nullable CloseableReference<CloseableImage> newResult, int status) {
                try {
                    CloseableReference currentCachedResult;
                    if (FrescoSystrace.isTracing()) {
                        FrescoSystrace.beginSection((String)"BitmapMemoryCacheProducer#onNewResultImpl");
                    }
                    boolean isLast = 1.isLast(status);
                    if (newResult == null) {
                        if (isLast) {
                            this.getConsumer().onNewResult(null, status);
                        }
                        return;
                    }
                    if (((CloseableImage)newResult.get()).isStateful() || 1.statusHasFlag(status, 8)) {
                        this.getConsumer().onNewResult(newResult, status);
                        return;
                    }
                    if (!isLast && (currentCachedResult = BitmapMemoryCacheProducer.this.mMemoryCache.get((Object)cacheKey)) != null) {
                        try {
                            QualityInfo newInfo = ((CloseableImage)newResult.get()).getQualityInfo();
                            QualityInfo cachedInfo = ((CloseableImage)currentCachedResult.get()).getQualityInfo();
                            if (cachedInfo.isOfFullQuality() || cachedInfo.getQuality() >= newInfo.getQuality()) {
                                this.getConsumer().onNewResult(currentCachedResult, status);
                                return;
                            }
                        }
                        finally {
                            CloseableReference.closeSafely((CloseableReference)currentCachedResult);
                        }
                    }
                    CloseableReference<CloseableImage> newCachedResult = null;
                    if (isMemoryCacheEnabled) {
                        newCachedResult = BitmapMemoryCacheProducer.this.mMemoryCache.cache((Object)cacheKey, newResult);
                    }
                    try {
                        if (isLast) {
                            this.getConsumer().onProgressUpdate(1.0f);
                        }
                        this.getConsumer().onNewResult(newCachedResult != null ? newCachedResult : newResult, status);
                    }
                    finally {
                        CloseableReference.closeSafely(newCachedResult);
                    }
                }
                finally {
                    if (FrescoSystrace.isTracing()) {
                        FrescoSystrace.endSection();
                    }
                }
            }
        };
    }

    protected String getProducerName() {
        return PRODUCER_NAME;
    }

    private static void maybeSetExtrasFromCloseableImage(HasImageMetadata imageWithMeta, ProducerContext producerContext) {
        producerContext.putExtras(imageWithMeta.getExtras());
    }

    protected String getOriginSubcategory() {
        return ORIGIN_SUBCATEGORY;
    }
}

