/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.memory.PooledByteBufferOutputStream;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.TriState;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imageformat.ImageFormatChecker;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.nativecode.WebpTranscoder;
import com.facebook.imagepipeline.nativecode.WebpTranscoderFactory;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.infer.annotation.Nullsafe;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class WebpTranscodeProducer
implements Producer<EncodedImage> {
    public static final String PRODUCER_NAME = "WebpTranscodeProducer";
    private static final int DEFAULT_JPEG_QUALITY = 80;
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final Producer<EncodedImage> mInputProducer;

    public WebpTranscodeProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, Producer<EncodedImage> inputProducer) {
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mPooledByteBufferFactory = (PooledByteBufferFactory)Preconditions.checkNotNull((Object)pooledByteBufferFactory);
        this.mInputProducer = (Producer)Preconditions.checkNotNull(inputProducer);
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext context) {
        this.mInputProducer.produceResults(new WebpTranscodeConsumer(consumer, context), context);
    }

    private void transcodeLastResult(EncodedImage originalResult, Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        Preconditions.checkNotNull((Object)originalResult);
        final EncodedImage encodedImageCopy = EncodedImage.cloneOrNull((EncodedImage)originalResult);
        StatefulProducerRunnable<EncodedImage> runnable = new StatefulProducerRunnable<EncodedImage>(consumer, producerContext.getProducerListener(), producerContext, PRODUCER_NAME){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected EncodedImage getResult() throws Exception {
                try (PooledByteBufferOutputStream outputStream = WebpTranscodeProducer.this.mPooledByteBufferFactory.newOutputStream();){
                    EncodedImage encodedImage;
                    WebpTranscodeProducer.doTranscode(encodedImageCopy, outputStream);
                    CloseableReference ref = CloseableReference.of((Closeable)outputStream.toByteBuffer());
                    try {
                        EncodedImage encodedImage2 = new EncodedImage(ref);
                        encodedImage2.copyMetaDataFrom(encodedImageCopy);
                        encodedImage = encodedImage2;
                    }
                    catch (Throwable throwable) {
                        CloseableReference.closeSafely((CloseableReference)ref);
                        throw throwable;
                    }
                    CloseableReference.closeSafely((CloseableReference)ref);
                    return encodedImage;
                }
            }

            @Override
            protected void disposeResult(EncodedImage result) {
                EncodedImage.closeSafely((EncodedImage)result);
            }

            @Override
            protected void onSuccess(EncodedImage result) {
                EncodedImage.closeSafely((EncodedImage)encodedImageCopy);
                super.onSuccess(result);
            }

            @Override
            protected void onFailure(Exception e) {
                EncodedImage.closeSafely((EncodedImage)encodedImageCopy);
                super.onFailure(e);
            }

            @Override
            protected void onCancellation() {
                EncodedImage.closeSafely((EncodedImage)encodedImageCopy);
                super.onCancellation();
            }
        };
        this.mExecutor.execute((Runnable)((Object)runnable));
    }

    private static TriState shouldTranscode(EncodedImage encodedImage) {
        Preconditions.checkNotNull((Object)encodedImage);
        InputStream is = (InputStream)Preconditions.checkNotNull((Object)encodedImage.getInputStream());
        ImageFormat imageFormat = ImageFormatChecker.getImageFormat_WrapIOException((InputStream)is);
        if (DefaultImageFormats.isStaticWebpFormat((ImageFormat)imageFormat)) {
            WebpTranscoder webpTranscoder = WebpTranscoderFactory.getWebpTranscoder();
            if (webpTranscoder == null) {
                return TriState.NO;
            }
            return TriState.valueOf((!webpTranscoder.isWebpNativelySupported(imageFormat) ? 1 : 0) != 0);
        }
        if (imageFormat == ImageFormat.UNKNOWN) {
            return TriState.UNSET;
        }
        return TriState.NO;
    }

    private static void doTranscode(EncodedImage encodedImage, PooledByteBufferOutputStream outputStream) throws Exception {
        InputStream is = (InputStream)Preconditions.checkNotNull((Object)encodedImage.getInputStream());
        ImageFormat imageFormat = ImageFormatChecker.getImageFormat_WrapIOException((InputStream)is);
        if (imageFormat == DefaultImageFormats.WEBP_SIMPLE || imageFormat == DefaultImageFormats.WEBP_EXTENDED) {
            WebpTranscoderFactory.getWebpTranscoder().transcodeWebpToJpeg(is, (OutputStream)outputStream, 80);
            encodedImage.setImageFormat(DefaultImageFormats.JPEG);
        } else if (imageFormat == DefaultImageFormats.WEBP_LOSSLESS || imageFormat == DefaultImageFormats.WEBP_EXTENDED_WITH_ALPHA) {
            WebpTranscoderFactory.getWebpTranscoder().transcodeWebpToPng(is, (OutputStream)outputStream);
            encodedImage.setImageFormat(DefaultImageFormats.PNG);
        } else {
            throw new IllegalArgumentException("Wrong image format");
        }
    }

    private class WebpTranscodeConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private final ProducerContext mContext;
        private TriState mShouldTranscodeWhenFinished;

        public WebpTranscodeConsumer(Consumer<EncodedImage> consumer, ProducerContext context) {
            super(consumer);
            this.mContext = context;
            this.mShouldTranscodeWhenFinished = TriState.UNSET;
        }

        @Override
        protected void onNewResultImpl(@Nullable EncodedImage newResult, int status) {
            if (this.mShouldTranscodeWhenFinished == TriState.UNSET && newResult != null) {
                this.mShouldTranscodeWhenFinished = WebpTranscodeProducer.shouldTranscode(newResult);
            }
            if (this.mShouldTranscodeWhenFinished == TriState.NO) {
                this.getConsumer().onNewResult(newResult, status);
                return;
            }
            if (WebpTranscodeConsumer.isLast(status)) {
                if (this.mShouldTranscodeWhenFinished == TriState.YES && newResult != null) {
                    WebpTranscodeProducer.this.transcodeLastResult(newResult, this.getConsumer(), this.mContext);
                } else {
                    this.getConsumer().onNewResult(newResult, status);
                }
            }
        }
    }
}

