/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.LocalFetchProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.infer.annotation.Nullsafe;
import java.io.IOException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class LocalResourceFetchProducer
extends LocalFetchProducer {
    public static final String PRODUCER_NAME = "LocalResourceFetchProducer";
    private final Resources mResources;

    public LocalResourceFetchProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, Resources resources) {
        super(executor, pooledByteBufferFactory);
        this.mResources = resources;
    }

    @Override
    @Nullable
    protected EncodedImage getEncodedImage(ImageRequest imageRequest) throws IOException {
        return this.getEncodedImage(this.mResources.openRawResource(LocalResourceFetchProducer.getResourceId(imageRequest)), this.getLength(imageRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLength(ImageRequest imageRequest) {
        AssetFileDescriptor fd = null;
        try {
            fd = this.mResources.openRawResourceFd(LocalResourceFetchProducer.getResourceId(imageRequest));
            int n = (int)fd.getLength();
            return n;
        }
        catch (Resources.NotFoundException e) {
            int n = -1;
            return n;
        }
        finally {
            try {
                if (fd != null) {
                    fd.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected String getProducerName() {
        return PRODUCER_NAME;
    }

    private static int getResourceId(ImageRequest imageRequest) {
        String path = imageRequest.getSourceUri().getPath();
        Preconditions.checkNotNull((Object)path);
        return Integer.parseInt(path.substring(1));
    }
}

