/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.os.Looper;
import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.instrumentation.FrescoInstrumenter;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener2;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.imagepipeline.producers.ThreadHandoffProducerQueue;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ThreadHandoffProducer<T>
implements Producer<T> {
    public static final String PRODUCER_NAME = "BackgroundThreadHandoffProducer";
    private final Producer<T> mInputProducer;
    private final ThreadHandoffProducerQueue mThreadHandoffProducerQueue;

    public ThreadHandoffProducer(Producer<T> inputProducer, ThreadHandoffProducerQueue inputThreadHandoffProducerQueue) {
        this.mInputProducer = (Producer)Preconditions.checkNotNull(inputProducer);
        this.mThreadHandoffProducerQueue = inputThreadHandoffProducerQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceResults(final Consumer<T> consumer, final ProducerContext context) {
        try {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"ThreadHandoffProducer#produceResults");
            }
            final ProducerListener2 producerListener = context.getProducerListener();
            if (ThreadHandoffProducer.shouldRunImmediately(context)) {
                producerListener.onProducerStart(context, PRODUCER_NAME);
                producerListener.onProducerFinishWithSuccess(context, PRODUCER_NAME, null);
                this.mInputProducer.produceResults(consumer, context);
                return;
            }
            final StatefulProducerRunnable statefulRunnable = new StatefulProducerRunnable<T>(consumer, producerListener, context, PRODUCER_NAME){

                @Override
                protected void onSuccess(@Nullable T ignored) {
                    producerListener.onProducerFinishWithSuccess(context, ThreadHandoffProducer.PRODUCER_NAME, null);
                    ThreadHandoffProducer.this.mInputProducer.produceResults(consumer, context);
                }

                @Override
                protected void disposeResult(@Nullable T ignored) {
                }

                @Nullable
                protected T getResult() throws Exception {
                    return null;
                }
            };
            context.addCallbacks(new BaseProducerContextCallbacks(){

                @Override
                public void onCancellationRequested() {
                    statefulRunnable.cancel();
                    ThreadHandoffProducer.this.mThreadHandoffProducerQueue.remove((Runnable)((Object)statefulRunnable));
                }
            });
            this.mThreadHandoffProducerQueue.addToQueueOrExecute(FrescoInstrumenter.decorateRunnable((Runnable)((Object)statefulRunnable), (String)ThreadHandoffProducer.getInstrumentationTag(context)));
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    @Nullable
    private static String getInstrumentationTag(ProducerContext context) {
        return FrescoInstrumenter.isTracing() ? "ThreadHandoffProducer_produceResults_" + context.getId() : null;
    }

    private static boolean shouldRunImmediately(ProducerContext context) {
        if (!context.getImagePipelineConfig().getExperiments().handoffOnUiThreadOnly()) {
            return false;
        }
        return Looper.getMainLooper().getThread() != Thread.currentThread();
    }
}

