/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B#\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/imagepipeline/producers/DelayProducer;", "Lcom/facebook/imagepipeline/producers/Producer;", "Lcom/facebook/common/references/CloseableReference;", "Lcom/facebook/imagepipeline/image/CloseableImage;", "inputProducer", "backgroundTasksExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lcom/facebook/imagepipeline/producers/Producer;Ljava/util/concurrent/ScheduledExecutorService;)V", "produceResults", "", "consumer", "Lcom/facebook/imagepipeline/producers/Consumer;", "context", "Lcom/facebook/imagepipeline/producers/ProducerContext;", "imagepipeline_release"})
public final class DelayProducer
implements Producer<CloseableReference<CloseableImage>> {
    @NotNull
    private final Producer<CloseableReference<CloseableImage>> inputProducer;
    @Nullable
    private final ScheduledExecutorService backgroundTasksExecutor;

    public DelayProducer(@NotNull Producer<CloseableReference<CloseableImage>> inputProducer, @Nullable ScheduledExecutorService backgroundTasksExecutor) {
        Intrinsics.checkNotNullParameter(inputProducer, (String)"inputProducer");
        this.inputProducer = inputProducer;
        this.backgroundTasksExecutor = backgroundTasksExecutor;
    }

    @Override
    public void produceResults(@NotNull Consumer<CloseableReference<CloseableImage>> consumer, @NotNull ProducerContext context) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ImageRequest imageRequest = context.getImageRequest();
        Intrinsics.checkNotNullExpressionValue((Object)imageRequest, (String)"context.imageRequest");
        ImageRequest request = imageRequest;
        if (this.backgroundTasksExecutor != null) {
            this.backgroundTasksExecutor.schedule(() -> DelayProducer.produceResults$lambda$0(this, consumer, context), (long)request.getDelayMs(), TimeUnit.MILLISECONDS);
        } else {
            this.inputProducer.produceResults(consumer, context);
        }
    }

    private static final void produceResults$lambda$0(DelayProducer this$0, Consumer $consumer, ProducerContext $context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$consumer, (String)"$consumer");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        this$0.inputProducer.produceResults($consumer, $context);
    }
}

