/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.executors.StatefulRunnable;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener2;
import com.facebook.infer.annotation.Nullsafe;
import java.util.Map;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public abstract class StatefulProducerRunnable<T>
extends StatefulRunnable<T> {
    private final Consumer<T> mConsumer;
    private final ProducerListener2 mProducerListener;
    private final String mProducerName;
    private final ProducerContext mProducerContext;

    public StatefulProducerRunnable(Consumer<T> consumer, ProducerListener2 producerListener, ProducerContext producerContext, String producerName) {
        this.mConsumer = consumer;
        this.mProducerListener = producerListener;
        this.mProducerName = producerName;
        this.mProducerContext = producerContext;
        this.mProducerListener.onProducerStart(this.mProducerContext, this.mProducerName);
    }

    protected void onSuccess(@Nullable T result) {
        this.mProducerListener.onProducerFinishWithSuccess(this.mProducerContext, this.mProducerName, this.mProducerListener.requiresExtraMap(this.mProducerContext, this.mProducerName) ? this.getExtraMapOnSuccess(result) : null);
        this.mConsumer.onNewResult(result, 1);
    }

    protected void onFailure(Exception e) {
        this.mProducerListener.onProducerFinishWithFailure(this.mProducerContext, this.mProducerName, e, this.mProducerListener.requiresExtraMap(this.mProducerContext, this.mProducerName) ? this.getExtraMapOnFailure(e) : null);
        this.mConsumer.onFailure(e);
    }

    protected void onCancellation() {
        this.mProducerListener.onProducerFinishWithCancellation(this.mProducerContext, this.mProducerName, this.mProducerListener.requiresExtraMap(this.mProducerContext, this.mProducerName) ? this.getExtraMapOnCancellation() : null);
        this.mConsumer.onCancellation();
    }

    @Nullable
    protected Map<String, String> getExtraMapOnSuccess(@Nullable T result) {
        return null;
    }

    @Nullable
    protected Map<String, String> getExtraMapOnFailure(Exception exception) {
        return null;
    }

    @Nullable
    protected Map<String, String> getExtraMapOnCancellation() {
        return null;
    }

    protected abstract void disposeResult(@Nullable T var1);
}

