/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.imagepipeline.memory.BitmapCounter;
import com.facebook.imagepipeline.memory.BitmapCounterConfig;
import com.facebook.infer.annotation.ThreadSafe;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\tH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/facebook/imagepipeline/memory/BitmapCounterProvider;", "", "()V", "KB", "", "MAX_BITMAP_TOTAL_SIZE", "", "MB", "bitmapCounter", "Lcom/facebook/imagepipeline/memory/BitmapCounter;", "maxBitmapCount", "maxSizeHardCap", "getMaxSizeHardCap", "()I", "get", "initialize", "", "bitmapCounterConfig", "Lcom/facebook/imagepipeline/memory/BitmapCounterConfig;", "imagepipeline_release"})
public final class BitmapCounterProvider {
    @NotNull
    public static final BitmapCounterProvider INSTANCE = new BitmapCounterProvider();
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    @JvmField
    public static final int MAX_BITMAP_TOTAL_SIZE = INSTANCE.getMaxSizeHardCap();
    private static int maxBitmapCount = 384;
    @Nullable
    private static volatile BitmapCounter bitmapCounter;

    private BitmapCounterProvider() {
    }

    private final int getMaxSizeHardCap() {
        int maxMemory = (int)Math.min(Runtime.getRuntime().maxMemory(), Integer.MAX_VALUE);
        return (long)maxMemory > 0x1000000L ? maxMemory / 4 * 3 : maxMemory / 2;
    }

    @JvmStatic
    public static final void initialize(@NotNull BitmapCounterConfig bitmapCounterConfig) {
        Intrinsics.checkNotNullParameter((Object)bitmapCounterConfig, (String)"bitmapCounterConfig");
        if (!(bitmapCounter == null)) {
            boolean bl = false;
            String string = "BitmapCounter has already been created! `BitmapCounterProvider.initialize(...)` should only be called before `BitmapCounterProvider.get()` or not at all!";
            throw new IllegalStateException(string.toString());
        }
        maxBitmapCount = bitmapCounterConfig.getMaxBitmapCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @ThreadSafe
    @NotNull
    public static final BitmapCounter get() {
        if (bitmapCounter == null) {
            Class<BitmapCounterProvider> clazz = BitmapCounterProvider.class;
            synchronized (clazz) {
                boolean bl = false;
                if (bitmapCounter == null) {
                    bitmapCounter = new BitmapCounter(maxBitmapCount, MAX_BITMAP_TOTAL_SIZE);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        BitmapCounter bitmapCounter = BitmapCounterProvider.bitmapCounter;
        Intrinsics.checkNotNull((Object)bitmapCounter);
        return bitmapCounter;
    }
}

