/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.postprocessors;

import android.content.Context;
import android.graphics.Bitmap;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.SimpleCacheKey;
import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.filter.IterativeBoxBlurFilter;
import com.facebook.imagepipeline.filter.RenderScriptBlurFilter;
import com.facebook.imagepipeline.request.BasePostprocessor;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/facebook/imagepipeline/postprocessors/BlurPostProcessor;", "Lcom/facebook/imagepipeline/request/BasePostprocessor;", "blurRadius", "", "context", "Landroid/content/Context;", "iterations", "(ILandroid/content/Context;I)V", "getBlurRadius", "()I", "cacheKey", "Lcom/facebook/cache/common/CacheKey;", "getContext", "()Landroid/content/Context;", "getIterations", "getPostprocessorCacheKey", "process", "", "bitmap", "Landroid/graphics/Bitmap;", "destBitmap", "sourceBitmap", "Companion", "imagepipeline_release"})
public final class BlurPostProcessor
extends BasePostprocessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int blurRadius;
    @NotNull
    private final Context context;
    private final int iterations;
    @NotNull
    private final CacheKey cacheKey;
    private static final boolean canUseRenderScript = RenderScriptBlurFilter.canUseRenderScript();
    private static final int DEFAULT_ITERATIONS = 3;

    @JvmOverloads
    public BlurPostProcessor(int blurRadius, @NotNull Context context, int iterations) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.blurRadius = blurRadius;
        this.context = context;
        this.iterations = iterations;
        Preconditions.checkArgument((Boolean)(this.blurRadius > 0 && this.blurRadius <= 25 ? 1 : 0));
        Preconditions.checkArgument((Boolean)(this.iterations > 0 ? 1 : 0));
        if (canUseRenderScript) {
            Locale locale = null;
            String string2 = "IntrinsicBlur;%d";
            Object[] objectArray = new Object[]{this.blurRadius};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
        } else {
            Locale locale = null;
            String string4 = "IterativeBoxBlur;%d;%d";
            Object[] objectArray = new Object[]{this.iterations, this.blurRadius};
            String string5 = String.format(locale, string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(locale, format, *args)");
        }
        this.cacheKey = (CacheKey)new SimpleCacheKey(string);
    }

    public /* synthetic */ BlurPostProcessor(int n, Context context, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = 3;
        }
        this(n, context, n2);
    }

    public final int getBlurRadius() {
        return this.blurRadius;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final int getIterations() {
        return this.iterations;
    }

    @Override
    @NotNull
    public CacheKey getPostprocessorCacheKey() {
        return this.cacheKey;
    }

    @Override
    public void process(@NotNull Bitmap destBitmap, @NotNull Bitmap sourceBitmap) {
        Intrinsics.checkNotNullParameter((Object)destBitmap, (String)"destBitmap");
        Intrinsics.checkNotNullParameter((Object)sourceBitmap, (String)"sourceBitmap");
        if (canUseRenderScript) {
            RenderScriptBlurFilter.blurBitmap(destBitmap, sourceBitmap, this.context, this.blurRadius);
        } else {
            super.process(destBitmap, sourceBitmap);
        }
    }

    @Override
    public void process(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        IterativeBoxBlurFilter.boxBlurBitmapInPlace(bitmap, this.iterations, this.blurRadius);
    }

    @JvmOverloads
    public BlurPostProcessor(int blurRadius, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(blurRadius, context, 0, 4, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/imagepipeline/postprocessors/BlurPostProcessor$Companion;", "", "()V", "DEFAULT_ITERATIONS", "", "canUseRenderScript", "", "imagepipeline_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

