/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.request;

import android.net.Uri;
import android.os.Build;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.Fn;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.media.MediaUtils;
import com.facebook.common.util.UriUtil;
import com.facebook.imagepipeline.common.BytesRange;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.listener.RequestListener;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.imagepipeline.request.Postprocessor;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.memory.config.MemorySpikeConfig;
import com.facebook.memory.helper.HashCode;
import java.io.File;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ImageRequest {
    private static boolean sUseCachedHashcodeInEquals;
    private static boolean sCacheHashcode;
    private int mHashcode;
    private final CacheChoice mCacheChoice;
    private final Uri mSourceUri;
    private final int mSourceUriType;
    @Nullable
    private File mSourceFile;
    private final boolean mProgressiveRenderingEnabled;
    private final boolean mLocalThumbnailPreviewsEnabled;
    private final boolean mLoadThumbnailOnly;
    private final ImageDecodeOptions mImageDecodeOptions;
    @Nullable
    private final ResizeOptions mResizeOptions;
    private final RotationOptions mRotationOptions;
    @Nullable
    private final BytesRange mBytesRange;
    private final Priority mRequestPriority;
    private final RequestLevel mLowestPermittedRequestLevel;
    protected int mCachesDisabled;
    private final boolean mIsDiskCacheEnabled;
    private final boolean mIsMemoryCacheEnabled;
    @Nullable
    private final Boolean mDecodePrefetches;
    @Nullable
    private final Postprocessor mPostprocessor;
    @Nullable
    private final RequestListener mRequestListener;
    @Nullable
    private final Boolean mResizingAllowedOverride;
    private final int mDelayMs;
    public static final Fn<ImageRequest, Uri> REQUEST_TO_URI_FN;

    @Nullable
    public static ImageRequest fromFile(@Nullable File file) {
        return file == null ? null : ImageRequest.fromUri(UriUtil.getUriForFile((File)file));
    }

    @Nullable
    public static ImageRequest fromUri(@Nullable Uri uri) {
        return uri == null ? null : ImageRequestBuilder.newBuilderWithSource(uri).build();
    }

    @Nullable
    public static ImageRequest fromUri(@Nullable String uriString) {
        return uriString == null || uriString.length() == 0 ? null : ImageRequest.fromUri(Uri.parse((String)uriString));
    }

    protected ImageRequest(ImageRequestBuilder builder) {
        this.mCacheChoice = builder.getCacheChoice();
        this.mSourceUri = builder.getSourceUri();
        this.mSourceUriType = ImageRequest.getSourceUriType(this.mSourceUri);
        this.mProgressiveRenderingEnabled = builder.isProgressiveRenderingEnabled();
        this.mLocalThumbnailPreviewsEnabled = builder.isLocalThumbnailPreviewsEnabled();
        this.mLoadThumbnailOnly = builder.getLoadThumbnailOnly();
        this.mImageDecodeOptions = builder.getImageDecodeOptions();
        this.mResizeOptions = builder.getResizeOptions();
        this.mRotationOptions = builder.getRotationOptions() == null ? RotationOptions.autoRotate() : builder.getRotationOptions();
        this.mBytesRange = builder.getBytesRange();
        this.mRequestPriority = builder.getRequestPriority();
        this.mLowestPermittedRequestLevel = builder.getLowestPermittedRequestLevel();
        this.mIsDiskCacheEnabled = builder.isDiskCacheEnabled();
        int cachesDisabledFlags = builder.getCachesDisabled();
        if (!this.mIsDiskCacheEnabled) {
            cachesDisabledFlags |= 0x30;
        }
        this.mCachesDisabled = cachesDisabledFlags;
        this.mIsMemoryCacheEnabled = builder.isMemoryCacheEnabled();
        this.mDecodePrefetches = builder.shouldDecodePrefetches();
        this.mPostprocessor = builder.getPostprocessor();
        this.mRequestListener = builder.getRequestListener();
        this.mResizingAllowedOverride = builder.getResizingAllowedOverride();
        this.mDelayMs = builder.getDelayMs();
    }

    public CacheChoice getCacheChoice() {
        return this.mCacheChoice;
    }

    public Uri getSourceUri() {
        return this.mSourceUri;
    }

    public int getSourceUriType() {
        return this.mSourceUriType;
    }

    public int getPreferredWidth() {
        return this.mResizeOptions != null ? this.mResizeOptions.width : 2048;
    }

    public int getPreferredHeight() {
        return this.mResizeOptions != null ? this.mResizeOptions.height : 2048;
    }

    @Nullable
    public ResizeOptions getResizeOptions() {
        return this.mResizeOptions;
    }

    public RotationOptions getRotationOptions() {
        return this.mRotationOptions;
    }

    @Deprecated
    public boolean getAutoRotateEnabled() {
        return this.mRotationOptions.useImageMetadata();
    }

    @Nullable
    public BytesRange getBytesRange() {
        return this.mBytesRange;
    }

    public ImageDecodeOptions getImageDecodeOptions() {
        return this.mImageDecodeOptions;
    }

    public boolean getProgressiveRenderingEnabled() {
        return this.mProgressiveRenderingEnabled;
    }

    public boolean getLocalThumbnailPreviewsEnabled() {
        return this.mLocalThumbnailPreviewsEnabled;
    }

    public boolean getLoadThumbnailOnlyForAndroidSdkAboveQ() {
        return Build.VERSION.SDK_INT >= 29 && this.mLoadThumbnailOnly;
    }

    public Priority getPriority() {
        return this.mRequestPriority;
    }

    public RequestLevel getLowestPermittedRequestLevel() {
        return this.mLowestPermittedRequestLevel;
    }

    public int getCachesDisabled() {
        return this.mCachesDisabled;
    }

    public boolean isDiskCacheEnabled() {
        return this.mIsDiskCacheEnabled;
    }

    public boolean isCacheEnabled(int cacheMask) {
        return (this.getCachesDisabled() & cacheMask) == 0;
    }

    public boolean isMemoryCacheEnabled() {
        return this.mIsMemoryCacheEnabled;
    }

    @Nullable
    public Boolean shouldDecodePrefetches() {
        return this.mDecodePrefetches;
    }

    @Nullable
    public Boolean getResizingAllowedOverride() {
        return this.mResizingAllowedOverride;
    }

    public int getDelayMs() {
        return this.mDelayMs;
    }

    public synchronized File getSourceFile() {
        if (this.mSourceFile == null) {
            Preconditions.checkNotNull((Object)this.mSourceUri.getPath());
            this.mSourceFile = new File(this.mSourceUri.getPath());
        }
        return this.mSourceFile;
    }

    @Nullable
    public Postprocessor getPostprocessor() {
        return this.mPostprocessor;
    }

    @Nullable
    public RequestListener getRequestListener() {
        return this.mRequestListener;
    }

    public boolean equals(@Nullable Object o) {
        CacheKey thatPostprocessorKey;
        if (!(o instanceof ImageRequest)) {
            return false;
        }
        ImageRequest request = (ImageRequest)o;
        if (sUseCachedHashcodeInEquals) {
            int a = this.mHashcode;
            int b = request.mHashcode;
            if (a != 0 && b != 0 && a != b) {
                return false;
            }
        }
        if (this.mLocalThumbnailPreviewsEnabled != request.mLocalThumbnailPreviewsEnabled) {
            return false;
        }
        if (this.mIsDiskCacheEnabled != request.mIsDiskCacheEnabled) {
            return false;
        }
        if (this.mIsMemoryCacheEnabled != request.mIsMemoryCacheEnabled) {
            return false;
        }
        if (!(Objects.equal((Object)this.mSourceUri, (Object)request.mSourceUri) && Objects.equal((Object)((Object)this.mCacheChoice), (Object)((Object)request.mCacheChoice)) && Objects.equal((Object)this.mSourceFile, (Object)request.mSourceFile) && Objects.equal((Object)this.mBytesRange, (Object)request.mBytesRange) && Objects.equal((Object)this.mImageDecodeOptions, (Object)request.mImageDecodeOptions) && Objects.equal((Object)this.mResizeOptions, (Object)request.mResizeOptions) && Objects.equal((Object)this.mRequestPriority, (Object)request.mRequestPriority) && Objects.equal((Object)((Object)this.mLowestPermittedRequestLevel), (Object)((Object)request.mLowestPermittedRequestLevel)) && Objects.equal((Object)this.mCachesDisabled, (Object)request.mCachesDisabled) && Objects.equal((Object)this.mDecodePrefetches, (Object)request.mDecodePrefetches) && Objects.equal((Object)this.mResizingAllowedOverride, (Object)request.mResizingAllowedOverride) && Objects.equal((Object)this.mRotationOptions, (Object)request.mRotationOptions) && this.mLoadThumbnailOnly == request.mLoadThumbnailOnly)) {
            return false;
        }
        CacheKey thisPostprocessorKey = this.mPostprocessor != null ? this.mPostprocessor.getPostprocessorCacheKey() : null;
        CacheKey cacheKey = thatPostprocessorKey = request.mPostprocessor != null ? request.mPostprocessor.getPostprocessorCacheKey() : null;
        if (!Objects.equal((Object)thisPostprocessorKey, (Object)thatPostprocessorKey)) {
            return false;
        }
        return this.mDelayMs == request.mDelayMs;
    }

    public int hashCode() {
        boolean cacheHashcode = sCacheHashcode;
        int result = 0;
        if (cacheHashcode) {
            result = this.mHashcode;
        }
        if (result == 0) {
            CacheKey postprocessorCacheKey;
            CacheKey cacheKey = postprocessorCacheKey = this.mPostprocessor != null ? this.mPostprocessor.getPostprocessorCacheKey() : null;
            if (!MemorySpikeConfig.avoidObjectsHashCode()) {
                result = Objects.hashCode((Object[])new Object[]{this.mCacheChoice, this.mSourceUri, this.mLocalThumbnailPreviewsEnabled, this.mBytesRange, this.mRequestPriority, this.mLowestPermittedRequestLevel, this.mCachesDisabled, this.mIsDiskCacheEnabled, this.mIsMemoryCacheEnabled, this.mImageDecodeOptions, this.mDecodePrefetches, this.mResizeOptions, this.mRotationOptions, postprocessorCacheKey, this.mResizingAllowedOverride, this.mDelayMs, this.mLoadThumbnailOnly});
            } else {
                result = HashCode.extend((int)0, (Object)((Object)this.mCacheChoice));
                result = HashCode.extend((int)result, (Object)this.mSourceUri);
                result = HashCode.extend((int)result, (Object)this.mLocalThumbnailPreviewsEnabled);
                result = HashCode.extend((int)result, (Object)this.mBytesRange);
                result = HashCode.extend((int)result, (Object)this.mRequestPriority);
                result = HashCode.extend((int)result, (Object)((Object)this.mLowestPermittedRequestLevel));
                result = HashCode.extend((int)result, (Object)this.mCachesDisabled);
                result = HashCode.extend((int)result, (Object)this.mIsDiskCacheEnabled);
                result = HashCode.extend((int)result, (Object)this.mIsMemoryCacheEnabled);
                result = HashCode.extend((int)result, (Object)this.mImageDecodeOptions);
                result = HashCode.extend((int)result, (Object)this.mDecodePrefetches);
                result = HashCode.extend((int)result, (Object)this.mResizeOptions);
                result = HashCode.extend((int)result, (Object)this.mRotationOptions);
                result = HashCode.extend((int)result, (Object)postprocessorCacheKey);
                result = HashCode.extend((int)result, (Object)this.mResizingAllowedOverride);
                result = HashCode.extend((int)result, (Object)this.mDelayMs);
                result = HashCode.extend((int)result, (Object)this.mLoadThumbnailOnly);
            }
            if (cacheHashcode) {
                this.mHashcode = result;
            }
        }
        return result;
    }

    public void recordHashCode(HashMap<String, Integer> hashCodeLog) {
        CacheKey postprocessorCacheKey = this.mPostprocessor != null ? this.mPostprocessor.getPostprocessorCacheKey() : null;
        hashCodeLog.put("ImageRequest", this.hashCode());
        hashCodeLog.put("ImageRequest.mSourceUri", ImageRequest.getHashCodeHelper(this.mSourceUri));
        hashCodeLog.put("ImageRequest.mLocalThumbnailPreviewsEnabled", ImageRequest.getHashCodeHelper(this.mLocalThumbnailPreviewsEnabled));
        hashCodeLog.put("ImageRequest.mBytesRange", ImageRequest.getHashCodeHelper(this.mBytesRange));
        hashCodeLog.put("ImageRequest.mRequestPriority", ImageRequest.getHashCodeHelper(this.mRequestPriority));
        hashCodeLog.put("ImageRequest.mLowestPermittedRequestLevel", ImageRequest.getHashCodeHelper((Object)this.mLowestPermittedRequestLevel));
        hashCodeLog.put("ImageRequest.mCachesDisabled", ImageRequest.getHashCodeHelper(this.mCachesDisabled));
        hashCodeLog.put("ImageRequest.mIsDiskCacheEnabled", ImageRequest.getHashCodeHelper(this.mIsDiskCacheEnabled));
        hashCodeLog.put("ImageRequest.mIsMemoryCacheEnabled", ImageRequest.getHashCodeHelper(this.mIsMemoryCacheEnabled));
        hashCodeLog.put("ImageRequest.mImageDecodeOptions", ImageRequest.getHashCodeHelper(this.mImageDecodeOptions));
        hashCodeLog.put("ImageRequest.mDecodePrefetches", ImageRequest.getHashCodeHelper(this.mDecodePrefetches));
        hashCodeLog.put("ImageRequest.mSoumResizeOptionsrceUri", ImageRequest.getHashCodeHelper(this.mResizeOptions));
        hashCodeLog.put("ImageRequest.mRotationOptions", ImageRequest.getHashCodeHelper(this.mRotationOptions));
        hashCodeLog.put("ImageRequest.postprocessorCacheKey", ImageRequest.getHashCodeHelper(postprocessorCacheKey));
        hashCodeLog.put("ImageRequest.mResizingAllowedOverride", ImageRequest.getHashCodeHelper(this.mResizingAllowedOverride));
        hashCodeLog.put("ImageRequest.mDelayMs", ImageRequest.getHashCodeHelper(this.mDelayMs));
        hashCodeLog.put("ImageRequest.mLoadThumbnailOnly", ImageRequest.getHashCodeHelper(this.mLoadThumbnailOnly));
    }

    private static int getHashCodeHelper(@Nullable Object obj) {
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("uri", (Object)this.mSourceUri).add("cacheChoice", (Object)this.mCacheChoice).add("decodeOptions", (Object)this.mImageDecodeOptions).add("postprocessor", (Object)this.mPostprocessor).add("priority", (Object)this.mRequestPriority).add("resizeOptions", (Object)this.mResizeOptions).add("rotationOptions", (Object)this.mRotationOptions).add("bytesRange", (Object)this.mBytesRange).add("resizingAllowedOverride", (Object)this.mResizingAllowedOverride).add("progressiveRenderingEnabled", this.mProgressiveRenderingEnabled).add("localThumbnailPreviewsEnabled", this.mLocalThumbnailPreviewsEnabled).add("loadThumbnailOnly", this.mLoadThumbnailOnly).add("lowestPermittedRequestLevel", (Object)this.mLowestPermittedRequestLevel).add("cachesDisabled", this.mCachesDisabled).add("isDiskCacheEnabled", this.mIsDiskCacheEnabled).add("isMemoryCacheEnabled", this.mIsMemoryCacheEnabled).add("decodePrefetches", (Object)this.mDecodePrefetches).add("delayMs", this.mDelayMs).toString();
    }

    private static int getSourceUriType(@Nullable Uri uri) {
        if (uri == null) {
            return -1;
        }
        if (UriUtil.isNetworkUri((Uri)uri)) {
            return 0;
        }
        if (uri.getPath() != null && UriUtil.isLocalFileUri((Uri)uri)) {
            if (MediaUtils.isVideo((String)MediaUtils.extractMime((String)uri.getPath()))) {
                return 2;
            }
            return 3;
        }
        if (UriUtil.isLocalContentUri((Uri)uri)) {
            return 4;
        }
        if (UriUtil.isLocalAssetUri((Uri)uri)) {
            return 5;
        }
        if (UriUtil.isLocalResourceUri((Uri)uri)) {
            return 6;
        }
        if (UriUtil.isDataUri((Uri)uri)) {
            return 7;
        }
        if (UriUtil.isQualifiedResourceUri((Uri)uri)) {
            return 8;
        }
        return -1;
    }

    public static void setUseCachedHashcodeInEquals(boolean useCachedHashcodeInEquals) {
        sUseCachedHashcodeInEquals = useCachedHashcodeInEquals;
    }

    public static void setCacheHashcode(boolean cacheHashcode) {
        sCacheHashcode = cacheHashcode;
    }

    static {
        REQUEST_TO_URI_FN = new Fn<ImageRequest, Uri>(){

            @Nullable
            public Uri apply(@Nullable ImageRequest arg) {
                return arg != null ? arg.getSourceUri() : null;
            }
        };
    }

    public static enum CacheChoice {
        SMALL,
        DEFAULT;

    }

    public static enum RequestLevel {
        FULL_FETCH(1),
        DISK_CACHE(2),
        ENCODED_MEMORY_CACHE(3),
        BITMAP_MEMORY_CACHE(4);

        private int mValue;

        private RequestLevel(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static RequestLevel getMax(RequestLevel requestLevel1, RequestLevel requestLevel2) {
            return requestLevel1.getValue() > requestLevel2.getValue() ? requestLevel1 : requestLevel2;
        }
    }

    public static @interface CachesLocationsMasks {
        public static final int BITMAP_READ = 1;
        public static final int BITMAP_WRITE = 2;
        public static final int ENCODED_READ = 4;
        public static final int ENCODED_WRITE = 8;
        public static final int DISK_READ = 16;
        public static final int DISK_WRITE = 32;
    }
}

