/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.ImmutableSet;
import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.core.ImagePipelineConfigInterface;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerContextCallbacks;
import com.facebook.imagepipeline.producers.ProducerListener2;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.infer.annotation.Nullsafe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class BaseProducerContext
implements ProducerContext {
    private static final String ORIGIN_SUBCATEGORY_DEFAULT = "default";
    public static final Set<String> INITIAL_KEYS = ImmutableSet.of((Object[])new String[]{"id", "uri_source"});
    private static final Object CALLER_CONTEXT_UNSET = new Object();
    private final ImageRequest mImageRequest;
    private final String mId;
    @Nullable
    private final String mUiComponentId;
    private final ProducerListener2 mProducerListener;
    private final Object mCallerContext;
    private final ImageRequest.RequestLevel mLowestPermittedRequestLevel;
    private final Map<String, Object> mExtras;
    @GuardedBy(value="this")
    private boolean mIsPrefetch;
    @GuardedBy(value="this")
    private Priority mPriority;
    @GuardedBy(value="this")
    private boolean mIsIntermediateResultExpected;
    @GuardedBy(value="this")
    private boolean mIsCancelled;
    @GuardedBy(value="this")
    private final List<ProducerContextCallbacks> mCallbacks;
    private final ImagePipelineConfigInterface mImagePipelineConfig;

    public BaseProducerContext(ImageRequest imageRequest, String id, ProducerListener2 producerListener, @Nullable Object callerContext, ImageRequest.RequestLevel lowestPermittedRequestLevel, boolean isPrefetch, boolean isIntermediateResultExpected, Priority priority, ImagePipelineConfigInterface imagePipelineConfig) {
        this(imageRequest, id, null, null, producerListener, callerContext, lowestPermittedRequestLevel, isPrefetch, isIntermediateResultExpected, priority, imagePipelineConfig);
    }

    public BaseProducerContext(ImageRequest imageRequest, String id, @Nullable String uiComponentId, @Nullable Map<String, ?> extras, ProducerListener2 producerListener, @Nullable Object callerContext, ImageRequest.RequestLevel lowestPermittedRequestLevel, boolean isPrefetch, boolean isIntermediateResultExpected, Priority priority, ImagePipelineConfigInterface imagePipelineConfig) {
        this.mImageRequest = imageRequest;
        this.mId = id;
        this.mExtras = new HashMap<String, Object>();
        this.mExtras.put("id", this.mId);
        this.mExtras.put("uri_source", imageRequest == null ? "null-request" : imageRequest.getSourceUri());
        this.putExtras(extras);
        this.mUiComponentId = uiComponentId;
        this.mProducerListener = producerListener;
        this.mCallerContext = callerContext != null ? callerContext : CALLER_CONTEXT_UNSET;
        this.mLowestPermittedRequestLevel = lowestPermittedRequestLevel;
        this.mIsPrefetch = isPrefetch;
        this.mPriority = priority;
        this.mIsIntermediateResultExpected = isIntermediateResultExpected;
        this.mIsCancelled = false;
        this.mCallbacks = new ArrayList<ProducerContextCallbacks>();
        this.mImagePipelineConfig = imagePipelineConfig;
    }

    @Override
    public ImageRequest getImageRequest() {
        return this.mImageRequest;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    @Nullable
    public String getUiComponentId() {
        return this.mUiComponentId;
    }

    @Override
    public ProducerListener2 getProducerListener() {
        return this.mProducerListener;
    }

    @Override
    public Object getCallerContext() {
        return this.mCallerContext;
    }

    @Override
    public ImageRequest.RequestLevel getLowestPermittedRequestLevel() {
        return this.mLowestPermittedRequestLevel;
    }

    @Override
    public synchronized boolean isPrefetch() {
        return this.mIsPrefetch;
    }

    @Override
    public synchronized Priority getPriority() {
        return this.mPriority;
    }

    @Override
    public synchronized boolean isIntermediateResultExpected() {
        return this.mIsIntermediateResultExpected;
    }

    public synchronized boolean isCancelled() {
        return this.mIsCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallbacks(ProducerContextCallbacks callbacks) {
        boolean cancelImmediately = false;
        BaseProducerContext baseProducerContext = this;
        synchronized (baseProducerContext) {
            this.mCallbacks.add(callbacks);
            if (this.mIsCancelled) {
                cancelImmediately = true;
            }
        }
        if (cancelImmediately) {
            callbacks.onCancellationRequested();
        }
    }

    @Override
    public ImagePipelineConfigInterface getImagePipelineConfig() {
        return this.mImagePipelineConfig;
    }

    public void cancel() {
        BaseProducerContext.callOnCancellationRequested(this.cancelNoCallbacks());
    }

    @Nullable
    public synchronized List<ProducerContextCallbacks> setIsPrefetchNoCallbacks(boolean isPrefetch) {
        if (isPrefetch == this.mIsPrefetch) {
            return null;
        }
        this.mIsPrefetch = isPrefetch;
        return new ArrayList<ProducerContextCallbacks>(this.mCallbacks);
    }

    @Nullable
    public synchronized List<ProducerContextCallbacks> setPriorityNoCallbacks(Priority priority) {
        if (priority == this.mPriority) {
            return null;
        }
        this.mPriority = priority;
        return new ArrayList<ProducerContextCallbacks>(this.mCallbacks);
    }

    @Nullable
    public synchronized List<ProducerContextCallbacks> setIsIntermediateResultExpectedNoCallbacks(boolean isIntermediateResultExpected) {
        if (isIntermediateResultExpected == this.mIsIntermediateResultExpected) {
            return null;
        }
        this.mIsIntermediateResultExpected = isIntermediateResultExpected;
        return new ArrayList<ProducerContextCallbacks>(this.mCallbacks);
    }

    @Nullable
    public synchronized List<ProducerContextCallbacks> cancelNoCallbacks() {
        if (this.mIsCancelled) {
            return null;
        }
        this.mIsCancelled = true;
        return new ArrayList<ProducerContextCallbacks>(this.mCallbacks);
    }

    public static void callOnCancellationRequested(@Nullable List<ProducerContextCallbacks> callbacks) {
        if (callbacks == null) {
            return;
        }
        for (ProducerContextCallbacks callback : callbacks) {
            callback.onCancellationRequested();
        }
    }

    public static void callOnIsPrefetchChanged(@Nullable List<ProducerContextCallbacks> callbacks) {
        if (callbacks == null) {
            return;
        }
        for (ProducerContextCallbacks callback : callbacks) {
            callback.onIsPrefetchChanged();
        }
    }

    public static void callOnIsIntermediateResultExpectedChanged(@Nullable List<ProducerContextCallbacks> callbacks) {
        if (callbacks == null) {
            return;
        }
        for (ProducerContextCallbacks callback : callbacks) {
            callback.onIsIntermediateResultExpectedChanged();
        }
    }

    public static void callOnPriorityChanged(@Nullable List<ProducerContextCallbacks> callbacks) {
        if (callbacks == null) {
            return;
        }
        for (ProducerContextCallbacks callback : callbacks) {
            callback.onPriorityChanged();
        }
    }

    public void putExtra(String key, @Nullable Object value) {
        if (INITIAL_KEYS.contains(key)) {
            return;
        }
        this.mExtras.put(key, value);
    }

    public void putExtras(@Nullable Map<String, ?> extras) {
        if (extras == null) {
            return;
        }
        for (Map.Entry<String, ?> entry : extras.entrySet()) {
            this.putExtra(entry.getKey(), entry.getValue());
        }
    }

    @Nullable
    public <T> T getExtra(String key) {
        return (T)this.mExtras.get(key);
    }

    @Nullable
    public <E> E getExtra(String key, @Nullable E valueIfNotFound) {
        Object maybeValue = this.mExtras.get(key);
        if (maybeValue == null) {
            return valueIfNotFound;
        }
        return (E)maybeValue;
    }

    public Map<String, Object> getExtras() {
        return this.mExtras;
    }

    @Override
    public void putOriginExtra(@Nullable String origin, @Nullable String subcategory) {
        this.mExtras.put("origin", origin);
        this.mExtras.put("origin_sub", subcategory);
    }

    @Override
    public void putOriginExtra(@Nullable String origin) {
        this.putOriginExtra(origin, ORIGIN_SUBCATEGORY_DEFAULT);
    }
}

