/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.datasource;

import com.facebook.common.executors.CallerThreadExecutor;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.AbstractDataSource;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.infer.annotation.Nullsafe;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ListDataSource<T>
extends AbstractDataSource<List<CloseableReference<T>>> {
    private final DataSource<CloseableReference<T>>[] mDataSources;
    @GuardedBy(value="this")
    private int mFinishedDataSources;

    protected ListDataSource(DataSource<CloseableReference<T>>[] dataSources) {
        this.mDataSources = dataSources;
        this.mFinishedDataSources = 0;
    }

    public static <T> ListDataSource<T> create(DataSource<CloseableReference<T>> ... dataSources) {
        Preconditions.checkNotNull(dataSources);
        Preconditions.checkState((dataSources.length > 0 ? 1 : 0) != 0);
        ListDataSource<T> listDataSource = new ListDataSource<T>(dataSources);
        for (DataSource<CloseableReference<T>> dataSource : dataSources) {
            if (dataSource == null) continue;
            ListDataSource<T> listDataSource2 = listDataSource;
            Objects.requireNonNull(listDataSource2);
            dataSource.subscribe((DataSubscriber)listDataSource2.new InternalDataSubscriber(), (Executor)CallerThreadExecutor.getInstance());
        }
        return listDataSource;
    }

    @Nullable
    public synchronized List<CloseableReference<T>> getResult() {
        if (!this.hasResult()) {
            return null;
        }
        ArrayList<CloseableReference<T>> results = new ArrayList<CloseableReference<T>>(this.mDataSources.length);
        for (DataSource<CloseableReference<T>> dataSource : this.mDataSources) {
            results.add((CloseableReference)dataSource.getResult());
        }
        return results;
    }

    public synchronized boolean hasResult() {
        return !this.isClosed() && this.mFinishedDataSources == this.mDataSources.length;
    }

    public boolean close() {
        if (!super.close()) {
            return false;
        }
        for (DataSource<CloseableReference<T>> dataSource : this.mDataSources) {
            dataSource.close();
        }
        return true;
    }

    private void onDataSourceFinished() {
        if (this.increaseAndCheckIfLast()) {
            this.setResult(null, true, null);
        }
    }

    private synchronized boolean increaseAndCheckIfLast() {
        return ++this.mFinishedDataSources == this.mDataSources.length;
    }

    private void onDataSourceFailed(DataSource<CloseableReference<T>> dataSource) {
        Throwable failureCause = dataSource.getFailureCause();
        this.setFailure(failureCause != null ? failureCause : new Throwable("Unknown failure cause"));
    }

    private void onDataSourceCancelled() {
        this.setFailure(new CancellationException());
    }

    private void onDataSourceProgress() {
        float progress = 0.0f;
        for (DataSource<CloseableReference<T>> dataSource : this.mDataSources) {
            progress += dataSource.getProgress();
        }
        this.setProgress(progress / (float)this.mDataSources.length);
    }

    private class InternalDataSubscriber
    implements DataSubscriber<CloseableReference<T>> {
        @GuardedBy(value="InternalDataSubscriber.this")
        boolean mFinished = false;

        private InternalDataSubscriber() {
        }

        private synchronized boolean tryFinish() {
            if (this.mFinished) {
                return false;
            }
            this.mFinished = true;
            return true;
        }

        public void onFailure(DataSource<CloseableReference<T>> dataSource) {
            ListDataSource.this.onDataSourceFailed(dataSource);
        }

        public void onCancellation(DataSource<CloseableReference<T>> dataSource) {
            ListDataSource.this.onDataSourceCancelled();
        }

        public void onNewResult(DataSource<CloseableReference<T>> dataSource) {
            if (dataSource.isFinished() && this.tryFinish()) {
                ListDataSource.this.onDataSourceFinished();
            }
        }

        public void onProgressUpdate(DataSource<CloseableReference<T>> dataSource) {
            ListDataSource.this.onDataSourceProgress();
        }
    }
}

