/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.content.ContentResolver;
import android.database.Cursor;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.net.Uri;
import android.provider.MediaStore;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.util.UriUtil;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.LocalFetchProducer;
import com.facebook.imagepipeline.producers.ThumbnailProducer;
import com.facebook.imagepipeline.producers.ThumbnailSizeChecker;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imageutils.JfifUtil;
import com.facebook.infer.annotation.Nullsafe;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class LocalContentUriThumbnailFetchProducer
extends LocalFetchProducer
implements ThumbnailProducer<EncodedImage> {
    private static final Class<?> TAG = LocalContentUriThumbnailFetchProducer.class;
    public static final String PRODUCER_NAME = "LocalContentUriThumbnailFetchProducer";
    private static final String[] PROJECTION = new String[]{"_id", "_data"};
    private static final String[] THUMBNAIL_PROJECTION = new String[]{"_data"};
    private static final Rect MINI_THUMBNAIL_DIMENSIONS = new Rect(0, 0, 512, 384);
    private static final Rect MICRO_THUMBNAIL_DIMENSIONS = new Rect(0, 0, 96, 96);
    private static final int NO_THUMBNAIL = 0;
    private final ContentResolver mContentResolver;

    public LocalContentUriThumbnailFetchProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, ContentResolver contentResolver) {
        super(executor, pooledByteBufferFactory);
        this.mContentResolver = contentResolver;
    }

    @Override
    public boolean canProvideImageForSize(@Nullable ResizeOptions resizeOptions) {
        return ThumbnailSizeChecker.isImageBigEnough(MINI_THUMBNAIL_DIMENSIONS.width(), MINI_THUMBNAIL_DIMENSIONS.height(), resizeOptions);
    }

    @Override
    @Nullable
    protected EncodedImage getEncodedImage(ImageRequest imageRequest) throws IOException {
        Uri uri = imageRequest.getSourceUri();
        if (UriUtil.isLocalCameraUri((Uri)uri)) {
            return this.getCameraImage(uri, imageRequest.getResizeOptions());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private EncodedImage getCameraImage(Uri uri, @Nullable ResizeOptions resizeOptions) throws IOException {
        if (resizeOptions == null) {
            return null;
        }
        Cursor cursor = this.mContentResolver.query(uri, PROJECTION, null, null, null);
        if (cursor == null) {
            return null;
        }
        try {
            int imageIdColumnIndex;
            EncodedImage thumbnail;
            if (cursor.moveToFirst() && (thumbnail = this.getThumbnail(resizeOptions, cursor.getLong(imageIdColumnIndex = cursor.getColumnIndex("_id")))) != null) {
                int imageDataColumnIndex = cursor.getColumnIndex("_data");
                if (imageDataColumnIndex >= 0) {
                    String pathname = cursor.getString(imageDataColumnIndex);
                    thumbnail.setRotationAngle(LocalContentUriThumbnailFetchProducer.getRotationAngle(pathname));
                }
                EncodedImage encodedImage = thumbnail;
                return encodedImage;
            }
        }
        finally {
            cursor.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private EncodedImage getThumbnail(ResizeOptions resizeOptions, long imageId) throws IOException {
        int thumbnailKind = LocalContentUriThumbnailFetchProducer.getThumbnailKind(resizeOptions);
        if (thumbnailKind == 0) {
            return null;
        }
        Cursor thumbnailCursor = MediaStore.Images.Thumbnails.queryMiniThumbnail((ContentResolver)this.mContentResolver, (long)imageId, (int)thumbnailKind, (String[])THUMBNAIL_PROJECTION);
        if (thumbnailCursor == null) {
            return null;
        }
        try {
            String thumbnailUri;
            int thumbnailDataColumnIndex;
            if (thumbnailCursor.moveToFirst() && (thumbnailDataColumnIndex = thumbnailCursor.getColumnIndex("_data")) >= 0 && new File(thumbnailUri = (String)Preconditions.checkNotNull((Object)thumbnailCursor.getString(thumbnailDataColumnIndex))).exists()) {
                EncodedImage encodedImage = this.getEncodedImage(new FileInputStream(thumbnailUri), LocalContentUriThumbnailFetchProducer.getLength(thumbnailUri));
                return encodedImage;
            }
        }
        finally {
            thumbnailCursor.close();
        }
        return null;
    }

    private static int getThumbnailKind(ResizeOptions resizeOptions) {
        if (ThumbnailSizeChecker.isImageBigEnough(MICRO_THUMBNAIL_DIMENSIONS.width(), MICRO_THUMBNAIL_DIMENSIONS.height(), resizeOptions)) {
            return 3;
        }
        if (ThumbnailSizeChecker.isImageBigEnough(MINI_THUMBNAIL_DIMENSIONS.width(), MINI_THUMBNAIL_DIMENSIONS.height(), resizeOptions)) {
            return 1;
        }
        return 0;
    }

    private static int getLength(String pathname) {
        return pathname == null ? -1 : (int)new File(pathname).length();
    }

    @Override
    protected String getProducerName() {
        return PRODUCER_NAME;
    }

    private static int getRotationAngle(@Nullable String pathname) {
        if (pathname != null) {
            try {
                ExifInterface exif = new ExifInterface(pathname);
                return JfifUtil.getAutoRotateAngleFromOrientation((int)exif.getAttributeInt("Orientation", 1));
            }
            catch (IOException ioe) {
                FLog.e(TAG, (Throwable)ioe, (String)"Unable to retrieve thumbnail rotation for %s", (Object[])new Object[]{pathname});
            }
        }
        return 0;
    }
}

