/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.MemoryTrimmableRegistry;
import com.facebook.common.memory.NoOpMemoryTrimmableRegistry;
import com.facebook.imagepipeline.memory.DefaultBitmapPoolParams;
import com.facebook.imagepipeline.memory.DefaultByteArrayPoolParams;
import com.facebook.imagepipeline.memory.DefaultFlexByteArrayPoolParams;
import com.facebook.imagepipeline.memory.DefaultNativeMemoryChunkPoolParams;
import com.facebook.imagepipeline.memory.NoOpPoolStatsTracker;
import com.facebook.imagepipeline.memory.PoolParams;
import com.facebook.imagepipeline.memory.PoolStatsTracker;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class PoolConfig {
    public static final int BITMAP_POOL_MAX_BITMAP_SIZE_DEFAULT = 0x400000;
    private final PoolParams mBitmapPoolParams;
    private final PoolStatsTracker mBitmapPoolStatsTracker;
    private final PoolParams mFlexByteArrayPoolParams;
    private final MemoryTrimmableRegistry mMemoryTrimmableRegistry;
    private final PoolParams mMemoryChunkPoolParams;
    private final PoolStatsTracker mMemoryChunkPoolStatsTracker;
    private final PoolParams mSmallByteArrayPoolParams;
    private final PoolStatsTracker mSmallByteArrayPoolStatsTracker;
    private final String mBitmapPoolType;
    private final int mBitmapPoolMaxPoolSize;
    private final int mBitmapPoolMaxBitmapSize;
    private final boolean mRegisterLruBitmapPoolAsMemoryTrimmable;
    private final boolean mIgnoreBitmapPoolHardCap;

    private PoolConfig(Builder builder) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"PoolConfig()");
        }
        this.mBitmapPoolParams = builder.mBitmapPoolParams == null ? DefaultBitmapPoolParams.get() : builder.mBitmapPoolParams;
        this.mBitmapPoolStatsTracker = builder.mBitmapPoolStatsTracker == null ? NoOpPoolStatsTracker.getInstance() : builder.mBitmapPoolStatsTracker;
        this.mFlexByteArrayPoolParams = builder.mFlexByteArrayPoolParams == null ? DefaultFlexByteArrayPoolParams.get() : builder.mFlexByteArrayPoolParams;
        this.mMemoryTrimmableRegistry = builder.mMemoryTrimmableRegistry == null ? NoOpMemoryTrimmableRegistry.getInstance() : builder.mMemoryTrimmableRegistry;
        this.mMemoryChunkPoolParams = builder.mMemoryChunkPoolParams == null ? DefaultNativeMemoryChunkPoolParams.get() : builder.mMemoryChunkPoolParams;
        this.mMemoryChunkPoolStatsTracker = builder.mMemoryChunkPoolStatsTracker == null ? NoOpPoolStatsTracker.getInstance() : builder.mMemoryChunkPoolStatsTracker;
        this.mSmallByteArrayPoolParams = builder.mSmallByteArrayPoolParams == null ? DefaultByteArrayPoolParams.get() : builder.mSmallByteArrayPoolParams;
        this.mSmallByteArrayPoolStatsTracker = builder.mSmallByteArrayPoolStatsTracker == null ? NoOpPoolStatsTracker.getInstance() : builder.mSmallByteArrayPoolStatsTracker;
        this.mBitmapPoolType = builder.mBitmapPoolType == null ? "legacy" : builder.mBitmapPoolType;
        this.mBitmapPoolMaxPoolSize = builder.mBitmapPoolMaxPoolSize;
        this.mBitmapPoolMaxBitmapSize = builder.mBitmapPoolMaxBitmapSize > 0 ? builder.mBitmapPoolMaxBitmapSize : 0x400000;
        this.mRegisterLruBitmapPoolAsMemoryTrimmable = builder.mRegisterLruBitmapPoolAsMemoryTrimmable;
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        this.mIgnoreBitmapPoolHardCap = builder.mIgnoreBitmapPoolHardCap;
    }

    public PoolParams getBitmapPoolParams() {
        return this.mBitmapPoolParams;
    }

    public PoolStatsTracker getBitmapPoolStatsTracker() {
        return this.mBitmapPoolStatsTracker;
    }

    public MemoryTrimmableRegistry getMemoryTrimmableRegistry() {
        return this.mMemoryTrimmableRegistry;
    }

    public PoolParams getMemoryChunkPoolParams() {
        return this.mMemoryChunkPoolParams;
    }

    public PoolStatsTracker getMemoryChunkPoolStatsTracker() {
        return this.mMemoryChunkPoolStatsTracker;
    }

    public PoolParams getFlexByteArrayPoolParams() {
        return this.mFlexByteArrayPoolParams;
    }

    public PoolParams getSmallByteArrayPoolParams() {
        return this.mSmallByteArrayPoolParams;
    }

    public PoolStatsTracker getSmallByteArrayPoolStatsTracker() {
        return this.mSmallByteArrayPoolStatsTracker;
    }

    public String getBitmapPoolType() {
        return this.mBitmapPoolType;
    }

    public int getBitmapPoolMaxPoolSize() {
        return this.mBitmapPoolMaxPoolSize;
    }

    public int getBitmapPoolMaxBitmapSize() {
        return this.mBitmapPoolMaxBitmapSize;
    }

    public boolean isRegisterLruBitmapPoolAsMemoryTrimmable() {
        return this.mRegisterLruBitmapPoolAsMemoryTrimmable;
    }

    public boolean isIgnoreBitmapPoolHardCap() {
        return this.mIgnoreBitmapPoolHardCap;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private PoolParams mBitmapPoolParams;
        @Nullable
        private PoolStatsTracker mBitmapPoolStatsTracker;
        @Nullable
        private PoolParams mFlexByteArrayPoolParams;
        @Nullable
        private MemoryTrimmableRegistry mMemoryTrimmableRegistry;
        @Nullable
        private PoolParams mMemoryChunkPoolParams;
        @Nullable
        private PoolStatsTracker mMemoryChunkPoolStatsTracker;
        @Nullable
        private PoolParams mSmallByteArrayPoolParams;
        @Nullable
        private PoolStatsTracker mSmallByteArrayPoolStatsTracker;
        @Nullable
        private String mBitmapPoolType;
        private int mBitmapPoolMaxPoolSize;
        private int mBitmapPoolMaxBitmapSize;
        private boolean mRegisterLruBitmapPoolAsMemoryTrimmable;
        public boolean mIgnoreBitmapPoolHardCap;

        private Builder() {
        }

        public Builder setBitmapPoolParams(PoolParams bitmapPoolParams) {
            this.mBitmapPoolParams = (PoolParams)Preconditions.checkNotNull((Object)bitmapPoolParams);
            return this;
        }

        public Builder setBitmapPoolStatsTracker(PoolStatsTracker bitmapPoolStatsTracker) {
            this.mBitmapPoolStatsTracker = (PoolStatsTracker)Preconditions.checkNotNull((Object)bitmapPoolStatsTracker);
            return this;
        }

        public Builder setFlexByteArrayPoolParams(PoolParams flexByteArrayPoolParams) {
            this.mFlexByteArrayPoolParams = flexByteArrayPoolParams;
            return this;
        }

        public Builder setMemoryTrimmableRegistry(MemoryTrimmableRegistry memoryTrimmableRegistry) {
            this.mMemoryTrimmableRegistry = memoryTrimmableRegistry;
            return this;
        }

        public Builder setNativeMemoryChunkPoolParams(PoolParams memoryChunkPoolParams) {
            this.mMemoryChunkPoolParams = (PoolParams)Preconditions.checkNotNull((Object)memoryChunkPoolParams);
            return this;
        }

        public Builder setNativeMemoryChunkPoolStatsTracker(PoolStatsTracker memoryChunkPoolStatsTracker) {
            this.mMemoryChunkPoolStatsTracker = (PoolStatsTracker)Preconditions.checkNotNull((Object)memoryChunkPoolStatsTracker);
            return this;
        }

        public Builder setSmallByteArrayPoolParams(PoolParams commonByteArrayPoolParams) {
            this.mSmallByteArrayPoolParams = (PoolParams)Preconditions.checkNotNull((Object)commonByteArrayPoolParams);
            return this;
        }

        public Builder setSmallByteArrayPoolStatsTracker(PoolStatsTracker smallByteArrayPoolStatsTracker) {
            this.mSmallByteArrayPoolStatsTracker = (PoolStatsTracker)Preconditions.checkNotNull((Object)smallByteArrayPoolStatsTracker);
            return this;
        }

        public PoolConfig build() {
            return new PoolConfig(this);
        }

        public Builder setBitmapPoolType(String bitmapPoolType) {
            this.mBitmapPoolType = bitmapPoolType;
            return this;
        }

        public Builder setBitmapPoolMaxPoolSize(int bitmapPoolMaxPoolSize) {
            this.mBitmapPoolMaxPoolSize = bitmapPoolMaxPoolSize;
            return this;
        }

        public Builder setBitmapPoolMaxBitmapSize(int bitmapPoolMaxBitmapSize) {
            this.mBitmapPoolMaxBitmapSize = bitmapPoolMaxBitmapSize;
            return this;
        }

        public Builder setRegisterLruBitmapPoolAsMemoryTrimmable(boolean registerLruBitmapPoolAsMemoryTrimmable) {
            this.mRegisterLruBitmapPoolAsMemoryTrimmable = registerLruBitmapPoolAsMemoryTrimmable;
            return this;
        }

        public Builder setIgnoreBitmapPoolHardCap(boolean ignoreBitmapPoolHardCap) {
            this.mIgnoreBitmapPoolHardCap = ignoreBitmapPoolHardCap;
            return this;
        }
    }
}

