/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import android.content.Context;
import android.os.Build;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.disk.DiskCacheConfig;
import com.facebook.cache.disk.FileCache;
import com.facebook.common.internal.AndroidPredicates;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Predicate;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.imageformat.ImageFormatChecker;
import com.facebook.imagepipeline.animated.factory.AnimatedFactory;
import com.facebook.imagepipeline.animated.factory.AnimatedFactoryProvider;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactoryProvider;
import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.cache.CountingMemoryCache;
import com.facebook.imagepipeline.cache.EncodedCountingMemoryCacheFactory;
import com.facebook.imagepipeline.cache.EncodedMemoryCacheFactory;
import com.facebook.imagepipeline.cache.InstrumentedMemoryCache;
import com.facebook.imagepipeline.cache.InstrumentedMemoryCacheBitmapMemoryCacheFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.core.CloseableReferenceFactory;
import com.facebook.imagepipeline.core.ExecutorSupplier;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.facebook.imagepipeline.core.ImagePipelineConfigInterface;
import com.facebook.imagepipeline.core.ProducerFactory;
import com.facebook.imagepipeline.core.ProducerSequenceFactory;
import com.facebook.imagepipeline.decoder.DefaultImageDecoder;
import com.facebook.imagepipeline.decoder.ImageDecoder;
import com.facebook.imagepipeline.drawable.DrawableFactory;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.platform.PlatformDecoder;
import com.facebook.imagepipeline.platform.PlatformDecoderFactory;
import com.facebook.imagepipeline.producers.ExperimentalThreadHandoffProducerQueueImpl;
import com.facebook.imagepipeline.producers.ThreadHandoffProducerQueue;
import com.facebook.imagepipeline.producers.ThreadHandoffProducerQueueImpl;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import com.facebook.imagepipeline.transcoder.ImageTranscoderFactory;
import com.facebook.imagepipeline.transcoder.MultiImageTranscoderFactory;
import com.facebook.imagepipeline.transcoder.SimpleImageTranscoderFactory;
import com.facebook.infer.annotation.Nullsafe;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ImagePipelineFactory {
    private static final Class<?> TAG = ImagePipelineFactory.class;
    @Nullable
    private static ImagePipelineFactory sInstance = null;
    private static ImagePipeline sImagePipeline;
    private final ThreadHandoffProducerQueue mThreadHandoffProducerQueue;
    private static boolean sForceSingleInstance;
    private final ImagePipelineConfigInterface mConfig;
    private final CloseableReferenceFactory mCloseableReferenceFactory;
    @Nullable
    private CountingMemoryCache<CacheKey, CloseableImage> mBitmapCountingMemoryCache;
    @Nullable
    private InstrumentedMemoryCache<CacheKey, CloseableImage> mBitmapMemoryCache;
    @Nullable
    private CountingMemoryCache<CacheKey, PooledByteBuffer> mEncodedCountingMemoryCache;
    @Nullable
    private InstrumentedMemoryCache<CacheKey, PooledByteBuffer> mEncodedMemoryCache;
    @Nullable
    private BufferedDiskCache mMainBufferedDiskCache;
    @Nullable
    private FileCache mMainFileCache;
    @Nullable
    private ImageDecoder mImageDecoder;
    @Nullable
    private ImageTranscoderFactory mImageTranscoderFactory;
    @Nullable
    private ProducerFactory mProducerFactory;
    @Nullable
    private ProducerSequenceFactory mProducerSequenceFactory;
    @Nullable
    private BufferedDiskCache mSmallImageBufferedDiskCache;
    @Nullable
    private FileCache mSmallImageFileCache;
    @Nullable
    private Map<String, FileCache> mDynamicFileCaches;
    @Nullable
    private ImmutableMap<String, BufferedDiskCache> mDynamicBufferedDiskCaches;
    @Nullable
    private PlatformBitmapFactory mPlatformBitmapFactory;
    @Nullable
    private PlatformDecoder mPlatformDecoder;
    @Nullable
    private AnimatedFactory mAnimatedFactory;

    public static ImagePipelineFactory getInstance() {
        return (ImagePipelineFactory)Preconditions.checkNotNull((Object)sInstance, (Object)"ImagePipelineFactory was not initialized!");
    }

    public static void setInstance(ImagePipelineFactory newInstance) {
        sInstance = newInstance;
    }

    public static synchronized void initialize(Context context) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"ImagePipelineFactory#initialize");
        }
        ImagePipelineFactory.initialize(ImagePipelineConfig.newBuilder(context).build());
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
    }

    public static synchronized void initialize(ImagePipelineConfigInterface imagePipelineConfig) {
        if (sInstance != null) {
            FLog.w(TAG, (String)"ImagePipelineFactory has already been initialized! `ImagePipelineFactory.initialize(...)` should only be called once to avoid unexpected behavior.");
            if (sForceSingleInstance) {
                return;
            }
        }
        sInstance = new ImagePipelineFactory(imagePipelineConfig);
    }

    public static synchronized void forceSingleInstance() {
        sForceSingleInstance = true;
    }

    public static synchronized boolean hasBeenInitialized() {
        return sInstance != null;
    }

    public static synchronized void shutDown() {
        if (sInstance != null) {
            sInstance.getBitmapMemoryCache().removeAll((Predicate<CacheKey>)AndroidPredicates.True());
            sInstance.getEncodedMemoryCache().removeAll((Predicate<CacheKey>)AndroidPredicates.True());
            sInstance = null;
        }
    }

    public ImagePipelineFactory(ImagePipelineConfigInterface config) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"ImagePipelineConfig()");
        }
        this.mConfig = (ImagePipelineConfigInterface)Preconditions.checkNotNull((Object)config);
        this.mThreadHandoffProducerQueue = this.mConfig.getExperiments().isExperimentalThreadHandoffQueueEnabled() ? new ExperimentalThreadHandoffProducerQueueImpl(config.getExecutorSupplier().forLightweightBackgroundTasks()) : new ThreadHandoffProducerQueueImpl(config.getExecutorSupplier().forLightweightBackgroundTasks());
        this.mCloseableReferenceFactory = new CloseableReferenceFactory(config.getCloseableReferenceLeakTracker());
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
    }

    @Nullable
    private AnimatedFactory getAnimatedFactory() {
        if (this.mAnimatedFactory == null) {
            this.mAnimatedFactory = AnimatedFactoryProvider.getAnimatedFactory((PlatformBitmapFactory)this.getPlatformBitmapFactory(), (ExecutorSupplier)this.mConfig.getExecutorSupplier(), this.getBitmapCountingMemoryCache(), (boolean)this.mConfig.getExperiments().getDownscaleFrameToDrawableDimensions(), (boolean)this.mConfig.getExperiments().getUseBalancedAnimationStrategy(), (int)this.mConfig.getExperiments().getAnimationRenderFpsLimit(), (ExecutorService)this.mConfig.getExecutorServiceForAnimatedImages());
        }
        return this.mAnimatedFactory;
    }

    @Nullable
    public DrawableFactory getAnimatedDrawableFactory(@Nullable Context context) {
        AnimatedFactory animatedFactory = this.getAnimatedFactory();
        return animatedFactory == null ? null : animatedFactory.getAnimatedDrawableFactory(context);
    }

    public CountingMemoryCache<CacheKey, CloseableImage> getBitmapCountingMemoryCache() {
        if (this.mBitmapCountingMemoryCache == null) {
            this.mBitmapCountingMemoryCache = this.mConfig.getBitmapMemoryCacheFactory().create(this.mConfig.getBitmapMemoryCacheParamsSupplier(), this.mConfig.getMemoryTrimmableRegistry(), this.mConfig.getBitmapMemoryCacheTrimStrategy(), this.mConfig.getExperiments().getShouldStoreCacheEntrySize(), this.mConfig.getExperiments().getShouldIgnoreCacheSizeMismatch(), this.mConfig.getBitmapMemoryCacheEntryStateObserver());
        }
        return this.mBitmapCountingMemoryCache;
    }

    public InstrumentedMemoryCache<CacheKey, CloseableImage> getBitmapMemoryCache() {
        if (this.mBitmapMemoryCache == null) {
            CountingMemoryCache<CacheKey, CloseableImage> backingCache = this.getBitmapCountingMemoryCache();
            this.mBitmapMemoryCache = InstrumentedMemoryCacheBitmapMemoryCacheFactory.get(backingCache, this.mConfig.getImageCacheStatsTracker());
        }
        return this.mBitmapMemoryCache;
    }

    public CountingMemoryCache<CacheKey, PooledByteBuffer> getEncodedCountingMemoryCache() {
        if (this.mEncodedCountingMemoryCache == null) {
            this.mEncodedCountingMemoryCache = EncodedCountingMemoryCacheFactory.get(this.mConfig.getEncodedMemoryCacheParamsSupplier(), this.mConfig.getMemoryTrimmableRegistry(), this.mConfig.getEncodedMemoryCacheTrimStrategy());
        }
        return this.mEncodedCountingMemoryCache;
    }

    public InstrumentedMemoryCache<CacheKey, PooledByteBuffer> getEncodedMemoryCache() {
        if (this.mEncodedMemoryCache == null) {
            CountingMemoryCache<CacheKey, PooledByteBuffer> backingCache = this.mConfig.getEncodedMemoryCacheOverride() != null ? this.mConfig.getEncodedMemoryCacheOverride() : this.getEncodedCountingMemoryCache();
            this.mEncodedMemoryCache = EncodedMemoryCacheFactory.get(backingCache, this.mConfig.getImageCacheStatsTracker());
        }
        return this.mEncodedMemoryCache;
    }

    private ImageDecoder getImageDecoder() {
        if (this.mImageDecoder == null) {
            if (this.mConfig.getImageDecoder() != null) {
                this.mImageDecoder = this.mConfig.getImageDecoder();
            } else {
                AnimatedFactory animatedFactory = this.getAnimatedFactory();
                ImageDecoder gifDecoder = null;
                ImageDecoder webPDecoder = null;
                if (animatedFactory != null) {
                    gifDecoder = animatedFactory.getGifDecoder();
                    webPDecoder = animatedFactory.getWebPDecoder();
                }
                if (this.mConfig.getImageDecoderConfig() == null) {
                    this.mImageDecoder = new DefaultImageDecoder(gifDecoder, webPDecoder, this.getPlatformDecoder());
                } else {
                    this.mImageDecoder = new DefaultImageDecoder(gifDecoder, webPDecoder, this.getPlatformDecoder(), this.mConfig.getImageDecoderConfig().getCustomImageDecoders());
                    ImageFormatChecker.getInstance().setCustomImageFormatCheckers(this.mConfig.getImageDecoderConfig().getCustomImageFormats());
                }
            }
        }
        return this.mImageDecoder;
    }

    public BufferedDiskCache getMainBufferedDiskCache() {
        if (this.mMainBufferedDiskCache == null) {
            this.mMainBufferedDiskCache = new BufferedDiskCache(this.getMainFileCache(), this.mConfig.getPoolFactory().getPooledByteBufferFactory(this.mConfig.getMemoryChunkType()), this.mConfig.getPoolFactory().getPooledByteStreams(), this.mConfig.getExecutorSupplier().forLocalStorageRead(), this.mConfig.getExecutorSupplier().forLocalStorageWrite(), this.mConfig.getImageCacheStatsTracker());
        }
        return this.mMainBufferedDiskCache;
    }

    private Map<String, FileCache> getDynamicFileCaches() {
        if (this.mDynamicFileCaches == null) {
            this.mDynamicFileCaches = new HashMap<String, FileCache>();
            if (this.mConfig.getDynamicDiskCacheConfigMap() != null) {
                for (Map.Entry<String, DiskCacheConfig> diskCacheConfigEntry : this.mConfig.getDynamicDiskCacheConfigMap().entrySet()) {
                    this.mDynamicFileCaches.put(diskCacheConfigEntry.getKey(), this.mConfig.getFileCacheFactory().get(diskCacheConfigEntry.getValue()));
                }
            }
        }
        return this.mDynamicFileCaches;
    }

    private ImmutableMap<String, BufferedDiskCache> getDynamicBufferedDiskCaches() {
        if (this.mDynamicBufferedDiskCaches == null) {
            HashMap<String, BufferedDiskCache> bufferedDiskCaches = new HashMap<String, BufferedDiskCache>();
            for (Map.Entry<String, FileCache> fileCacheEntry : this.getDynamicFileCaches().entrySet()) {
                bufferedDiskCaches.put(fileCacheEntry.getKey(), new BufferedDiskCache(fileCacheEntry.getValue(), this.mConfig.getPoolFactory().getPooledByteBufferFactory(this.mConfig.getMemoryChunkType()), this.mConfig.getPoolFactory().getPooledByteStreams(), this.mConfig.getExecutorSupplier().forLocalStorageRead(), this.mConfig.getExecutorSupplier().forLocalStorageWrite(), this.mConfig.getImageCacheStatsTracker()));
            }
            this.mDynamicBufferedDiskCaches = ImmutableMap.copyOf(bufferedDiskCaches);
        }
        return this.mDynamicBufferedDiskCaches;
    }

    public FileCache getMainFileCache() {
        if (this.mMainFileCache == null) {
            DiskCacheConfig diskCacheConfig = this.mConfig.getMainDiskCacheConfig();
            this.mMainFileCache = this.mConfig.getFileCacheFactory().get(diskCacheConfig);
        }
        return this.mMainFileCache;
    }

    public ImagePipeline getImagePipeline() {
        if (sImagePipeline == null) {
            sImagePipeline = this.createImagePipeline();
        }
        return sImagePipeline;
    }

    private ImagePipeline createImagePipeline() {
        return new ImagePipeline(this.getProducerSequenceFactory(), this.mConfig.getRequestListeners(), this.mConfig.getRequestListener2s(), this.mConfig.isPrefetchEnabledSupplier(), this.getBitmapMemoryCache(), this.getEncodedMemoryCache(), this.getMainBufferedDiskCache(), this.getSmallImageBufferedDiskCache(), this.mConfig.getCacheKeyFactory(), this.mThreadHandoffProducerQueue, this.mConfig.getExperiments().getSuppressBitmapPrefetchingSupplier(), this.mConfig.getExperiments().isLazyDataSource(), this.mConfig.getCallerContextVerifier(), this.mConfig);
    }

    public PlatformBitmapFactory getPlatformBitmapFactory() {
        if (this.mPlatformBitmapFactory == null) {
            this.mPlatformBitmapFactory = PlatformBitmapFactoryProvider.buildPlatformBitmapFactory(this.mConfig.getPoolFactory(), this.getPlatformDecoder(), this.getCloseableReferenceFactory());
        }
        return this.mPlatformBitmapFactory;
    }

    public PlatformDecoder getPlatformDecoder() {
        if (this.mPlatformDecoder == null) {
            this.mPlatformDecoder = PlatformDecoderFactory.buildPlatformDecoder(this.mConfig.getPoolFactory(), this.mConfig.getExperiments().isGingerbreadDecoderEnabled(), this.mConfig.getExperiments().getShouldUseDecodingBufferHelper(), this.mConfig.getExperiments().getPlatformDecoderOptions());
        }
        return this.mPlatformDecoder;
    }

    private ProducerFactory getProducerFactory() {
        if (this.mProducerFactory == null) {
            this.mProducerFactory = this.mConfig.getExperiments().getProducerFactoryMethod().createProducerFactory(this.mConfig.getContext(), this.mConfig.getPoolFactory().getSmallByteArrayPool(), this.getImageDecoder(), this.mConfig.getProgressiveJpegConfig(), this.mConfig.getDownsampleMode(), this.mConfig.isResizeAndRotateEnabledForNetwork(), this.mConfig.getExperiments().isDecodeCancellationEnabled(), this.mConfig.getExecutorSupplier(), this.mConfig.getPoolFactory().getPooledByteBufferFactory(this.mConfig.getMemoryChunkType()), this.mConfig.getPoolFactory().getPooledByteStreams(), (MemoryCache<CacheKey, CloseableImage>)this.getBitmapMemoryCache(), (MemoryCache<CacheKey, PooledByteBuffer>)this.getEncodedMemoryCache(), this.getMainBufferedDiskCache(), this.getSmallImageBufferedDiskCache(), (Map<String, BufferedDiskCache>)this.getDynamicBufferedDiskCaches(), this.mConfig.getCacheKeyFactory(), this.getPlatformBitmapFactory(), this.mConfig.getExperiments().getBitmapPrepareToDrawMinSizeBytes(), this.mConfig.getExperiments().getBitmapPrepareToDrawMaxSizeBytes(), this.mConfig.getExperiments().getBitmapPrepareToDrawForPrefetch(), this.mConfig.getExperiments().getMaxBitmapSize(), this.getCloseableReferenceFactory(), this.mConfig.getExperiments().getKeepCancelledFetchAsLowPriority(), this.mConfig.getExperiments().getTrackedKeysSize());
        }
        return this.mProducerFactory;
    }

    private ProducerSequenceFactory getProducerSequenceFactory() {
        boolean useBitmapPrepareToDraw;
        boolean bl = useBitmapPrepareToDraw = Build.VERSION.SDK_INT >= 24 && this.mConfig.getExperiments().getUseBitmapPrepareToDraw();
        if (this.mProducerSequenceFactory == null) {
            this.mProducerSequenceFactory = new ProducerSequenceFactory(this.mConfig.getContext().getApplicationContext().getContentResolver(), this.getProducerFactory(), this.mConfig.getNetworkFetcher(), this.mConfig.isResizeAndRotateEnabledForNetwork(), this.mConfig.getExperiments().isWebpSupportEnabled(), this.mThreadHandoffProducerQueue, this.mConfig.getDownsampleMode(), useBitmapPrepareToDraw, this.mConfig.getExperiments().isPartialImageCachingEnabled(), this.mConfig.isDiskCacheEnabled(), this.getImageTranscoderFactory(), this.mConfig.getExperiments().isEncodedMemoryCacheProbingEnabled(), this.mConfig.getExperiments().isDiskCacheProbingEnabled(), this.mConfig.getExperiments().getAllowDelay(), this.mConfig.getCustomProducerSequenceFactories());
        }
        return this.mProducerSequenceFactory;
    }

    public FileCache getSmallImageFileCache() {
        if (this.mSmallImageFileCache == null) {
            DiskCacheConfig diskCacheConfig = this.mConfig.getSmallImageDiskCacheConfig();
            this.mSmallImageFileCache = this.mConfig.getFileCacheFactory().get(diskCacheConfig);
        }
        return this.mSmallImageFileCache;
    }

    public CloseableReferenceFactory getCloseableReferenceFactory() {
        return this.mCloseableReferenceFactory;
    }

    private BufferedDiskCache getSmallImageBufferedDiskCache() {
        if (this.mSmallImageBufferedDiskCache == null) {
            this.mSmallImageBufferedDiskCache = new BufferedDiskCache(this.getSmallImageFileCache(), this.mConfig.getPoolFactory().getPooledByteBufferFactory(this.mConfig.getMemoryChunkType()), this.mConfig.getPoolFactory().getPooledByteStreams(), this.mConfig.getExecutorSupplier().forLocalStorageRead(), this.mConfig.getExecutorSupplier().forLocalStorageWrite(), this.mConfig.getImageCacheStatsTracker());
        }
        return this.mSmallImageBufferedDiskCache;
    }

    private ImageTranscoderFactory getImageTranscoderFactory() {
        if (this.mImageTranscoderFactory == null) {
            this.mImageTranscoderFactory = this.mConfig.getImageTranscoderFactory() == null && this.mConfig.getImageTranscoderType() == null && this.mConfig.getExperiments().isNativeCodeDisabled() ? new SimpleImageTranscoderFactory(this.mConfig.getExperiments().getMaxBitmapSize()) : new MultiImageTranscoderFactory(this.mConfig.getExperiments().getMaxBitmapSize(), this.mConfig.getExperiments().getUseDownsamplingRatioForResizing(), this.mConfig.getImageTranscoderFactory(), this.mConfig.getImageTranscoderType(), this.mConfig.getExperiments().isEnsureTranscoderLibraryLoaded());
        }
        return this.mImageTranscoderFactory;
    }

    @Nullable
    public String reportData() {
        Objects.ToStringHelper b = Objects.toStringHelper((String)"ImagePipelineFactory");
        if (this.mBitmapCountingMemoryCache != null) {
            b.add("bitmapCountingMemoryCache", (Object)this.mBitmapCountingMemoryCache.getDebugData());
        }
        if (this.mEncodedCountingMemoryCache != null) {
            b.add("encodedCountingMemoryCache", (Object)this.mEncodedCountingMemoryCache.getDebugData());
        }
        return b.toString();
    }
}

