/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.postprocessors;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import androidx.annotation.ColorInt;
import androidx.core.graphics.ColorUtils;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.SimpleCacheKey;
import com.facebook.imagepipeline.request.BasePostprocessor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/facebook/imagepipeline/postprocessors/TintPostProcessor;", "Lcom/facebook/imagepipeline/request/BasePostprocessor;", "color", "", "alphaPercent", "", "porterDuffMode", "Landroid/graphics/PorterDuff$Mode;", "(ILjava/lang/Float;Landroid/graphics/PorterDuff$Mode;)V", "cacheKey", "Lcom/facebook/cache/common/CacheKey;", "tintColor", "getName", "", "getPostprocessorCacheKey", "process", "", "sourceBitmap", "Landroid/graphics/Bitmap;", "imagepipeline_release"})
public final class TintPostProcessor
extends BasePostprocessor {
    @Nullable
    private final PorterDuff.Mode porterDuffMode;
    @ColorInt
    private final int tintColor;
    @NotNull
    private final CacheKey cacheKey;

    public TintPostProcessor(@ColorInt int color, @Nullable Float alphaPercent, @Nullable PorterDuff.Mode porterDuffMode) {
        this.porterDuffMode = porterDuffMode;
        this.tintColor = alphaPercent != null ? ColorUtils.setAlphaComponent((int)color, (int)RangesKt.coerceIn((int)((int)(alphaPercent.floatValue() * (float)255)), (int)0, (int)255)) : color;
        this.cacheKey = (CacheKey)new SimpleCacheKey("Tint. tintColor=" + this.tintColor + ", mode=" + this.porterDuffMode);
    }

    public /* synthetic */ TintPostProcessor(int n, Float f, PorterDuff.Mode mode, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            f = null;
        }
        if ((n2 & 4) != 0) {
            mode = null;
        }
        this(n, f, mode);
    }

    @Override
    public void process(@NotNull Bitmap sourceBitmap) {
        Intrinsics.checkNotNullParameter((Object)sourceBitmap, (String)"sourceBitmap");
        if (this.porterDuffMode == null) {
            new Canvas(sourceBitmap).drawColor(this.tintColor);
        } else {
            new Canvas(sourceBitmap).drawColor(this.tintColor, this.porterDuffMode);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return Reflection.getOrCreateKotlinClass(TintPostProcessor.class).toString();
    }

    @Override
    @NotNull
    public CacheKey getPostprocessorCacheKey() {
        return this.cacheKey;
    }
}

