/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.LocalFetchProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.IOException;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/imagepipeline/producers/LocalAssetFetchProducer;", "Lcom/facebook/imagepipeline/producers/LocalFetchProducer;", "executor", "Ljava/util/concurrent/Executor;", "pooledByteBufferFactory", "Lcom/facebook/common/memory/PooledByteBufferFactory;", "assetManager", "Landroid/content/res/AssetManager;", "(Ljava/util/concurrent/Executor;Lcom/facebook/common/memory/PooledByteBufferFactory;Landroid/content/res/AssetManager;)V", "getEncodedImage", "Lcom/facebook/imagepipeline/image/EncodedImage;", "imageRequest", "Lcom/facebook/imagepipeline/request/ImageRequest;", "getLength", "", "getProducerName", "", "Companion", "imagepipeline_release"})
public final class LocalAssetFetchProducer
extends LocalFetchProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AssetManager assetManager;
    @NotNull
    public static final String PRODUCER_NAME = "LocalAssetFetchProducer";

    public LocalAssetFetchProducer(@NotNull Executor executor, @NotNull PooledByteBufferFactory pooledByteBufferFactory, @NotNull AssetManager assetManager) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)pooledByteBufferFactory, (String)"pooledByteBufferFactory");
        Intrinsics.checkNotNullParameter((Object)assetManager, (String)"assetManager");
        super(executor, pooledByteBufferFactory);
        this.assetManager = assetManager;
    }

    @Override
    @Nullable
    protected EncodedImage getEncodedImage(@NotNull ImageRequest imageRequest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        return this.getEncodedImage(this.assetManager.open(LocalAssetFetchProducer.Companion.getAssetName(imageRequest), 2), this.getLength(imageRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getLength(ImageRequest imageRequest) {
        int n;
        AssetFileDescriptor fd = null;
        try {
            fd = this.assetManager.openFd(LocalAssetFetchProducer.Companion.getAssetName(imageRequest));
            n = (int)fd.getLength();
        }
        catch (IOException e) {
            n = -1;
        }
        finally {
            try {
                AssetFileDescriptor assetFileDescriptor;
                AssetFileDescriptor assetFileDescriptor2 = assetFileDescriptor = fd;
                if (assetFileDescriptor2 != null) {
                    assetFileDescriptor2.close();
                }
            }
            catch (IOException iOException) {}
        }
        return n;
    }

    @Override
    @NotNull
    protected String getProducerName() {
        return PRODUCER_NAME;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/imagepipeline/producers/LocalAssetFetchProducer$Companion;", "", "()V", "PRODUCER_NAME", "", "getAssetName", "imageRequest", "Lcom/facebook/imagepipeline/request/ImageRequest;", "imagepipeline_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String getAssetName(ImageRequest imageRequest) {
            String string = imageRequest.getSourceUri().getPath();
            Intrinsics.checkNotNull((Object)string);
            String string2 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

