/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.listener;

import android.os.SystemClock;
import android.util.Pair;
import com.facebook.common.logging.FLog;
import com.facebook.imagepipeline.listener.RequestListener;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\f\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J.\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0017H\u0016J6\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0017H\u0016J.\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0017H\u0016J \u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J \u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J \u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0007H\u0016R(\u0010\u0004\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/facebook/imagepipeline/listener/RequestLoggingListener;", "Lcom/facebook/imagepipeline/listener/RequestListener;", "<init>", "()V", "producerStartTimeMap", "", "Landroid/util/Pair;", "", "", "requestStartTimeMap", "onRequestStart", "", "request", "Lcom/facebook/imagepipeline/request/ImageRequest;", "callerContextObject", "", "requestId", "isPrefetch", "", "onProducerStart", "producerName", "onProducerFinishWithSuccess", "extraMap", "", "onProducerFinishWithFailure", "throwable", "", "onProducerFinishWithCancellation", "onProducerEvent", "producerEventName", "onUltimateProducerReached", "successful", "onRequestSuccess", "onRequestFailure", "onRequestCancellation", "requiresExtraMap", "id", "Companion", "imagepipeline_release"})
public final class RequestLoggingListener
implements RequestListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @GuardedBy(value="this")
    @NotNull
    private final Map<Pair<String, String>, Long> producerStartTimeMap = new HashMap();
    @GuardedBy(value="this")
    @NotNull
    private final Map<String, Long> requestStartTimeMap = new HashMap();
    @NotNull
    private static final String TAG = "RequestLoggingListener";

    @Override
    public synchronized void onRequestStart(@NotNull ImageRequest request, @NotNull Object callerContextObject, @NotNull String requestId, boolean isPrefetch) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)callerContextObject, (String)"callerContextObject");
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        if (FLog.isLoggable((int)2)) {
            FLog.v((String)TAG, (String)"time %d: onRequestSubmit: {requestId: %s, callerContext: %s, isPrefetch: %b}", (Object)RequestLoggingListener.Companion.getTime(), (Object)requestId, (Object)callerContextObject, (Object)isPrefetch);
            this.requestStartTimeMap.put(requestId, RequestLoggingListener.Companion.getTime());
        }
    }

    @Override
    public synchronized void onProducerStart(@NotNull String requestId, @NotNull String producerName) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)producerName, (String)"producerName");
        if (FLog.isLoggable((int)2)) {
            Pair mapKey = Pair.create((Object)requestId, (Object)producerName);
            long startTime = RequestLoggingListener.Companion.getTime();
            Long l = startTime;
            this.producerStartTimeMap.put((Pair<String, String>)mapKey, l);
            FLog.v((String)TAG, (String)"time %d: onProducerStart: {requestId: %s, producer: %s}", (Object)startTime, (Object)requestId, (Object)producerName);
        }
    }

    @Override
    public synchronized void onProducerFinishWithSuccess(@NotNull String requestId, @NotNull String producerName, @Nullable Map<String, String> extraMap) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)producerName, (String)"producerName");
        if (FLog.isLoggable((int)2)) {
            Pair mapKey = Pair.create((Object)requestId, (Object)producerName);
            Long startTime = this.producerStartTimeMap.remove(mapKey);
            long currentTime = RequestLoggingListener.Companion.getTime();
            Object[] objectArray = new Object[]{currentTime, requestId, producerName, RequestLoggingListener.Companion.getElapsedTime(startTime, currentTime), extraMap};
            FLog.v((String)TAG, (String)"time %d: onProducerFinishWithSuccess: {requestId: %s, producer: %s, elapsedTime: %d ms, extraMap: %s}", (Object[])objectArray);
        }
    }

    @Override
    public synchronized void onProducerFinishWithFailure(@NotNull String requestId, @NotNull String producerName, @NotNull Throwable throwable, @Nullable Map<String, String> extraMap) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)producerName, (String)"producerName");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (FLog.isLoggable((int)5)) {
            Pair mapKey = Pair.create((Object)requestId, (Object)producerName);
            Long startTime = this.producerStartTimeMap.remove(mapKey);
            long currentTime = RequestLoggingListener.Companion.getTime();
            Object[] objectArray = new Object[]{currentTime, requestId, producerName, RequestLoggingListener.Companion.getElapsedTime(startTime, currentTime), extraMap, throwable.toString()};
            FLog.w((String)TAG, (Throwable)throwable, (String)"time %d: onProducerFinishWithFailure: {requestId: %s, stage: %s, elapsedTime: %d ms, extraMap: %s, throwable: %s}", (Object[])objectArray);
        }
    }

    @Override
    public synchronized void onProducerFinishWithCancellation(@NotNull String requestId, @NotNull String producerName, @Nullable Map<String, String> extraMap) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)producerName, (String)"producerName");
        if (FLog.isLoggable((int)2)) {
            Pair mapKey = Pair.create((Object)requestId, (Object)producerName);
            Long startTime = this.producerStartTimeMap.remove(mapKey);
            long currentTime = RequestLoggingListener.Companion.getTime();
            Object[] objectArray = new Object[]{currentTime, requestId, producerName, RequestLoggingListener.Companion.getElapsedTime(startTime, currentTime), extraMap};
            FLog.v((String)TAG, (String)"time %d: onProducerFinishWithCancellation: {requestId: %s, stage: %s, elapsedTime: %d ms, extraMap: %s}", (Object[])objectArray);
        }
    }

    @Override
    public synchronized void onProducerEvent(@NotNull String requestId, @NotNull String producerName, @NotNull String producerEventName) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)producerName, (String)"producerName");
        Intrinsics.checkNotNullParameter((Object)producerEventName, (String)"producerEventName");
        if (FLog.isLoggable((int)2)) {
            Pair mapKey = Pair.create((Object)requestId, (Object)producerName);
            Long startTime = this.producerStartTimeMap.get(mapKey);
            long currentTime = RequestLoggingListener.Companion.getTime();
            Object[] objectArray = new Object[]{RequestLoggingListener.Companion.getTime(), requestId, producerName, producerEventName, RequestLoggingListener.Companion.getElapsedTime(startTime, currentTime)};
            FLog.v((String)TAG, (String)"time %d: onProducerEvent: {requestId: %s, stage: %s, eventName: %s; elapsedTime: %d ms}", (Object[])objectArray);
        }
    }

    @Override
    public synchronized void onUltimateProducerReached(@NotNull String requestId, @NotNull String producerName, boolean successful) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)producerName, (String)"producerName");
        if (FLog.isLoggable((int)2)) {
            Pair mapKey = Pair.create((Object)requestId, (Object)producerName);
            Long startTime = this.producerStartTimeMap.remove(mapKey);
            long currentTime = RequestLoggingListener.Companion.getTime();
            Object[] objectArray = new Object[]{currentTime, requestId, producerName, RequestLoggingListener.Companion.getElapsedTime(startTime, currentTime), successful};
            FLog.v((String)TAG, (String)"time %d: onUltimateProducerReached: {requestId: %s, producer: %s, elapsedTime: %d ms, success: %b}", (Object[])objectArray);
        }
    }

    @Override
    public synchronized void onRequestSuccess(@NotNull ImageRequest request, @NotNull String requestId, boolean isPrefetch) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        if (FLog.isLoggable((int)2)) {
            Long startTime = this.requestStartTimeMap.remove(requestId);
            long currentTime = RequestLoggingListener.Companion.getTime();
            FLog.v((String)TAG, (String)"time %d: onRequestSuccess: {requestId: %s, elapsedTime: %d ms}", (Object)currentTime, (Object)requestId, (Object)RequestLoggingListener.Companion.getElapsedTime(startTime, currentTime));
        }
    }

    @Override
    public synchronized void onRequestFailure(@NotNull ImageRequest request, @NotNull String requestId, @NotNull Throwable throwable, boolean isPrefetch) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (FLog.isLoggable((int)5)) {
            Long startTime = this.requestStartTimeMap.remove(requestId);
            long currentTime = RequestLoggingListener.Companion.getTime();
            Object[] objectArray = new Object[]{currentTime, requestId, RequestLoggingListener.Companion.getElapsedTime(startTime, currentTime), throwable.toString()};
            FLog.w((String)TAG, (String)"time %d: onRequestFailure: {requestId: %s, elapsedTime: %d ms, throwable: %s}", (Object[])objectArray);
        }
    }

    @Override
    public synchronized void onRequestCancellation(@NotNull String requestId) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        if (FLog.isLoggable((int)2)) {
            Long startTime = this.requestStartTimeMap.remove(requestId);
            long currentTime = RequestLoggingListener.Companion.getTime();
            FLog.v((String)TAG, (String)"time %d: onRequestCancellation: {requestId: %s, elapsedTime: %d ms}", (Object)currentTime, (Object)requestId, (Object)RequestLoggingListener.Companion.getElapsedTime(startTime, currentTime));
        }
    }

    @Override
    public boolean requiresExtraMap(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return FLog.isLoggable((int)2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/facebook/imagepipeline/listener/RequestLoggingListener$Companion;", "", "<init>", "()V", "TAG", "", "getElapsedTime", "", "startTime", "endTime", "(Ljava/lang/Long;J)J", "time", "getTime", "()J", "imagepipeline_release"})
    public static final class Companion {
        private Companion() {
        }

        private final long getElapsedTime(Long startTime, long endTime) {
            return startTime != null ? endTime - startTime : -1L;
        }

        private final long getTime() {
            return SystemClock.uptimeMillis();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

