/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.util.SparseIntArray;
import com.facebook.imagepipeline.memory.PoolParams;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/facebook/imagepipeline/memory/DefaultNativeMemoryChunkPoolParams;", "", "<init>", "()V", "SMALL_BUCKET_LENGTH", "", "LARGE_BUCKET_LENGTH", "get", "Lcom/facebook/imagepipeline/memory/PoolParams;", "maxSizeSoftCap", "getMaxSizeSoftCap", "()I", "maxSizeHardCap", "getMaxSizeHardCap", "imagepipeline_release"})
public final class DefaultNativeMemoryChunkPoolParams {
    @NotNull
    public static final DefaultNativeMemoryChunkPoolParams INSTANCE = new DefaultNativeMemoryChunkPoolParams();
    private static final int SMALL_BUCKET_LENGTH = 5;
    private static final int LARGE_BUCKET_LENGTH = 2;

    private DefaultNativeMemoryChunkPoolParams() {
    }

    @JvmStatic
    @NotNull
    public static final PoolParams get() {
        SparseIntArray DEFAULT_BUCKETS = new SparseIntArray();
        DEFAULT_BUCKETS.put(1024, 5);
        DEFAULT_BUCKETS.put(2048, 5);
        DEFAULT_BUCKETS.put(4096, 5);
        DEFAULT_BUCKETS.put(8192, 5);
        DEFAULT_BUCKETS.put(16384, 5);
        DEFAULT_BUCKETS.put(32768, 5);
        DEFAULT_BUCKETS.put(65536, 5);
        DEFAULT_BUCKETS.put(131072, 5);
        DEFAULT_BUCKETS.put(262144, 2);
        DEFAULT_BUCKETS.put(524288, 2);
        DEFAULT_BUCKETS.put(0x100000, 2);
        return new PoolParams(INSTANCE.getMaxSizeSoftCap(), INSTANCE.getMaxSizeHardCap(), DEFAULT_BUCKETS);
    }

    private final int getMaxSizeSoftCap() {
        int maxMemory = (int)Math.min(Runtime.getRuntime().maxMemory(), Integer.MAX_VALUE);
        return maxMemory < 0x1000000 ? 0x300000 : (maxMemory < 0x2000000 ? 0x600000 : 0xC00000);
    }

    private final int getMaxSizeHardCap() {
        int maxMemory = (int)Math.min(Runtime.getRuntime().maxMemory(), Integer.MAX_VALUE);
        return maxMemory < 0x1000000 ? maxMemory / 2 : maxMemory / 4 * 3;
    }
}

