/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import androidx.annotation.VisibleForTesting;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.memory.PooledByteStreams;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.memory.MemoryChunk;
import com.facebook.imagepipeline.memory.MemoryChunkPool;
import com.facebook.imagepipeline.memory.MemoryPooledByteBuffer;
import com.facebook.imagepipeline.memory.MemoryPooledByteBufferOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/imagepipeline/memory/MemoryPooledByteBufferFactory;", "Lcom/facebook/common/memory/PooledByteBufferFactory;", "pool", "Lcom/facebook/imagepipeline/memory/MemoryChunkPool;", "pooledByteStreams", "Lcom/facebook/common/memory/PooledByteStreams;", "<init>", "(Lcom/facebook/imagepipeline/memory/MemoryChunkPool;Lcom/facebook/common/memory/PooledByteStreams;)V", "newByteBuffer", "Lcom/facebook/imagepipeline/memory/MemoryPooledByteBuffer;", "size", "", "inputStream", "Ljava/io/InputStream;", "bytes", "", "initialCapacity", "newByteBuf", "outputStream", "Lcom/facebook/imagepipeline/memory/MemoryPooledByteBufferOutputStream;", "newOutputStream", "imagepipeline_release"})
@ThreadSafe
public final class MemoryPooledByteBufferFactory
implements PooledByteBufferFactory {
    @NotNull
    private final MemoryChunkPool pool;
    @NotNull
    private final PooledByteStreams pooledByteStreams;

    public MemoryPooledByteBufferFactory(@NotNull MemoryChunkPool pool, @NotNull PooledByteStreams pooledByteStreams) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        Intrinsics.checkNotNullParameter((Object)pooledByteStreams, (String)"pooledByteStreams");
        this.pool = pool;
        this.pooledByteStreams = pooledByteStreams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MemoryPooledByteBuffer newByteBuffer(int size) {
        MemoryPooledByteBuffer memoryPooledByteBuffer;
        if (!(size > 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        CloseableReference closeableReference = CloseableReference.of(this.pool.get(size), (ResourceReleaser)((ResourceReleaser)this.pool));
        Intrinsics.checkNotNullExpressionValue((Object)closeableReference, (String)"of(...)");
        try (CloseableReference chunkRef = closeableReference;){
            memoryPooledByteBuffer = new MemoryPooledByteBuffer((CloseableReference<MemoryChunk>)chunkRef, size);
        }
        return memoryPooledByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MemoryPooledByteBuffer newByteBuffer(@NotNull InputStream inputStream) throws IOException {
        MemoryPooledByteBuffer memoryPooledByteBuffer;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        try (MemoryPooledByteBufferOutputStream outputStream = new MemoryPooledByteBufferOutputStream(this.pool, 0, 2, null);){
            memoryPooledByteBuffer = this.newByteBuf(inputStream, outputStream);
        }
        return memoryPooledByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MemoryPooledByteBuffer newByteBuffer(@NotNull byte[] bytes) {
        MemoryPooledByteBuffer memoryPooledByteBuffer;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try (MemoryPooledByteBufferOutputStream outputStream = new MemoryPooledByteBufferOutputStream(this.pool, bytes.length);){
            outputStream.write(bytes, 0, bytes.length);
            memoryPooledByteBuffer = outputStream.toByteBuffer();
        }
        return memoryPooledByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MemoryPooledByteBuffer newByteBuffer(@NotNull InputStream inputStream, int initialCapacity) throws IOException {
        MemoryPooledByteBuffer memoryPooledByteBuffer;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        try (MemoryPooledByteBufferOutputStream outputStream = new MemoryPooledByteBufferOutputStream(this.pool, initialCapacity);){
            memoryPooledByteBuffer = this.newByteBuf(inputStream, outputStream);
        }
        return memoryPooledByteBuffer;
    }

    @VisibleForTesting
    @NotNull
    public final MemoryPooledByteBuffer newByteBuf(@NotNull InputStream inputStream, @NotNull MemoryPooledByteBufferOutputStream outputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)((Object)outputStream), (String)"outputStream");
        this.pooledByteStreams.copy(inputStream, (OutputStream)((Object)outputStream));
        return outputStream.toByteBuffer();
    }

    @NotNull
    public MemoryPooledByteBufferOutputStream newOutputStream() {
        return new MemoryPooledByteBufferOutputStream(this.pool, 0, 2, null);
    }

    @NotNull
    public MemoryPooledByteBufferOutputStream newOutputStream(int initialCapacity) {
        return new MemoryPooledByteBufferOutputStream(this.pool, initialCapacity);
    }
}

