/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import androidx.annotation.VisibleForTesting;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.Supplier;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.core.DiskCachesStore;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.DiskCacheDecision;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class DiskCacheWriteProducer
implements Producer<EncodedImage> {
    @VisibleForTesting
    static final String PRODUCER_NAME = "DiskCacheWriteProducer";
    private final Supplier<DiskCachesStore> mDiskCachesStoreSupplier;
    private final CacheKeyFactory mCacheKeyFactory;
    private final Producer<EncodedImage> mInputProducer;

    public DiskCacheWriteProducer(Supplier<DiskCachesStore> diskCachesStoreSupplier, CacheKeyFactory cacheKeyFactory, Producer<EncodedImage> inputProducer) {
        this.mDiskCachesStoreSupplier = diskCachesStoreSupplier;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mInputProducer = inputProducer;
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        this.maybeStartInputProducer(consumer, producerContext);
    }

    private void maybeStartInputProducer(Consumer<EncodedImage> consumerOfDiskCacheWriteProducer, ProducerContext producerContext) {
        if (producerContext.getLowestPermittedRequestLevel().getValue() >= ImageRequest.RequestLevel.DISK_CACHE.getValue()) {
            producerContext.putOriginExtra("disk", "nil-result_write");
            consumerOfDiskCacheWriteProducer.onNewResult(null, 1);
        } else {
            boolean isDiskCacheEnabledForWrite = producerContext.getImageRequest().isCacheEnabled(32);
            DiskCacheWriteConsumer consumer = isDiskCacheEnabledForWrite ? new DiskCacheWriteConsumer(consumerOfDiskCacheWriteProducer, producerContext, this.mDiskCachesStoreSupplier, this.mCacheKeyFactory) : consumerOfDiskCacheWriteProducer;
            this.mInputProducer.produceResults(consumer, producerContext);
        }
    }

    private static class DiskCacheWriteConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private final ProducerContext mProducerContext;
        private final Supplier<DiskCachesStore> mDiskCachesStoreSupplier;
        private final CacheKeyFactory mCacheKeyFactory;

        private DiskCacheWriteConsumer(Consumer<EncodedImage> consumer, ProducerContext producerContext, Supplier<DiskCachesStore> diskCachesStoreSupplier, CacheKeyFactory cacheKeyFactory) {
            super(consumer);
            this.mProducerContext = producerContext;
            this.mDiskCachesStoreSupplier = diskCachesStoreSupplier;
            this.mCacheKeyFactory = cacheKeyFactory;
        }

        @Override
        public void onNewResultImpl(@Nullable EncodedImage newResult, int status) {
            this.mProducerContext.getProducerListener().onProducerStart(this.mProducerContext, DiskCacheWriteProducer.PRODUCER_NAME);
            if (DiskCacheWriteConsumer.isNotLast(status) || newResult == null || DiskCacheWriteConsumer.statusHasAnyFlag(status, 10) || newResult.getImageFormat() == ImageFormat.UNKNOWN) {
                this.mProducerContext.getProducerListener().onProducerFinishWithSuccess(this.mProducerContext, DiskCacheWriteProducer.PRODUCER_NAME, null);
                this.getConsumer().onNewResult(newResult, status);
                return;
            }
            ImageRequest imageRequest = this.mProducerContext.getImageRequest();
            CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, this.mProducerContext.getCallerContext());
            DiskCachesStore diskCachesStore2 = (DiskCachesStore)this.mDiskCachesStoreSupplier.get();
            BufferedDiskCache bufferedDiskCache = DiskCacheDecision.chooseDiskCacheForRequest(imageRequest, diskCachesStore2.getSmallImageBufferedDiskCache(), diskCachesStore2.getMainBufferedDiskCache(), diskCachesStore2.getDynamicBufferedDiskCaches());
            if (bufferedDiskCache == null) {
                this.mProducerContext.getProducerListener().onProducerFinishWithFailure(this.mProducerContext, DiskCacheWriteProducer.PRODUCER_NAME, new DiskCacheDecision.DiskCacheDecisionNoDiskCacheChosenException("Got no disk cache for CacheChoice: " + Integer.valueOf(imageRequest.getCacheChoice().ordinal()).toString()), null);
                this.getConsumer().onNewResult(newResult, status);
                return;
            }
            bufferedDiskCache.put(cacheKey, newResult);
            this.mProducerContext.getProducerListener().onProducerFinishWithSuccess(this.mProducerContext, DiskCacheWriteProducer.PRODUCER_NAME, null);
            this.getConsumer().onNewResult(newResult, status);
        }
    }
}

