/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.os.SystemClock;
import androidx.annotation.VisibleForTesting;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.instrumentation.FrescoInstrumenter;
import com.facebook.imagepipeline.producers.BaseConsumer;
import com.facebook.infer.annotation.FalseOnNull;
import com.facebook.infer.annotation.Nullsafe;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class JobScheduler {
    static final String QUEUE_TIME_KEY = "queueTime";
    private final Executor mExecutor;
    private final JobRunnable mJobRunnable;
    private final Runnable mDoJobRunnable;
    private final Runnable mSubmitJobRunnable;
    private final int mMinimumJobIntervalMs;
    @Nullable
    @GuardedBy(value="this")
    @VisibleForTesting
    EncodedImage mEncodedImage;
    @GuardedBy(value="this")
    @VisibleForTesting
    int mStatus;
    @GuardedBy(value="this")
    @VisibleForTesting
    JobState mJobState;
    @GuardedBy(value="this")
    @VisibleForTesting
    long mJobSubmitTime;
    @GuardedBy(value="this")
    @VisibleForTesting
    long mJobStartTime;

    public JobScheduler(Executor executor, JobRunnable jobRunnable, int minimumJobIntervalMs) {
        this.mExecutor = executor;
        this.mJobRunnable = jobRunnable;
        this.mMinimumJobIntervalMs = minimumJobIntervalMs;
        this.mDoJobRunnable = new Runnable(){

            @Override
            public void run() {
                JobScheduler.this.doJob();
            }
        };
        this.mSubmitJobRunnable = new Runnable(){

            @Override
            public void run() {
                JobScheduler.this.submitJob();
            }
        };
        this.mEncodedImage = null;
        this.mStatus = 0;
        this.mJobState = JobState.IDLE;
        this.mJobSubmitTime = 0L;
        this.mJobStartTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJob() {
        EncodedImage oldEncodedImage;
        JobScheduler jobScheduler = this;
        synchronized (jobScheduler) {
            oldEncodedImage = this.mEncodedImage;
            this.mEncodedImage = null;
            this.mStatus = 0;
        }
        EncodedImage.closeSafely((EncodedImage)oldEncodedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateJob(@Nullable EncodedImage encodedImage, int status) {
        EncodedImage oldEncodedImage;
        if (!JobScheduler.shouldProcess(encodedImage, status)) {
            return false;
        }
        JobScheduler jobScheduler = this;
        synchronized (jobScheduler) {
            oldEncodedImage = this.mEncodedImage;
            this.mEncodedImage = EncodedImage.cloneOrNull((EncodedImage)encodedImage);
            this.mStatus = status;
        }
        EncodedImage.closeSafely((EncodedImage)oldEncodedImage);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleJob() {
        long now = SystemClock.uptimeMillis();
        long when = 0L;
        boolean shouldEnqueue = false;
        JobScheduler jobScheduler = this;
        synchronized (jobScheduler) {
            if (!JobScheduler.shouldProcess(this.mEncodedImage, this.mStatus)) {
                return false;
            }
            switch (this.mJobState) {
                case IDLE: {
                    when = Math.max(this.mJobStartTime + (long)this.mMinimumJobIntervalMs, now);
                    shouldEnqueue = true;
                    this.mJobSubmitTime = now;
                    this.mJobState = JobState.QUEUED;
                    break;
                }
                case QUEUED: {
                    break;
                }
                case RUNNING: {
                    this.mJobState = JobState.RUNNING_AND_PENDING;
                    break;
                }
            }
        }
        if (shouldEnqueue) {
            this.enqueueJob(when - now);
        }
        return true;
    }

    private void enqueueJob(long delay) {
        Runnable submitJobRunnable = FrescoInstrumenter.decorateRunnable((Runnable)this.mSubmitJobRunnable, (String)"JobScheduler_enqueueJob");
        if (delay > 0L) {
            JobStartExecutorSupplier.get().schedule(submitJobRunnable, delay, TimeUnit.MILLISECONDS);
        } else {
            submitJobRunnable.run();
        }
    }

    private void submitJob() {
        this.mExecutor.execute(FrescoInstrumenter.decorateRunnable((Runnable)this.mDoJobRunnable, (String)"JobScheduler_submitJob"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doJob() {
        int status;
        EncodedImage input;
        long now = SystemClock.uptimeMillis();
        JobScheduler jobScheduler = this;
        synchronized (jobScheduler) {
            input = this.mEncodedImage;
            status = this.mStatus;
            this.mEncodedImage = null;
            this.mStatus = 0;
            this.mJobState = JobState.RUNNING;
            this.mJobStartTime = now;
        }
        try {
            if (JobScheduler.shouldProcess(input, status)) {
                this.mJobRunnable.run(input, status);
            }
        }
        finally {
            EncodedImage.closeSafely((EncodedImage)input);
            this.onJobFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onJobFinished() {
        long now = SystemClock.uptimeMillis();
        long when = 0L;
        boolean shouldEnqueue = false;
        JobScheduler jobScheduler = this;
        synchronized (jobScheduler) {
            if (this.mJobState == JobState.RUNNING_AND_PENDING) {
                when = Math.max(this.mJobStartTime + (long)this.mMinimumJobIntervalMs, now);
                shouldEnqueue = true;
                this.mJobSubmitTime = now;
                this.mJobState = JobState.QUEUED;
            } else {
                this.mJobState = JobState.IDLE;
            }
        }
        if (shouldEnqueue) {
            this.enqueueJob(when - now);
        }
    }

    @FalseOnNull
    private static boolean shouldProcess(@Nullable EncodedImage encodedImage, int status) {
        return BaseConsumer.isLast(status) || BaseConsumer.statusHasFlag(status, 4) || EncodedImage.isValid((EncodedImage)encodedImage);
    }

    public synchronized long getQueuedTime() {
        return this.mJobStartTime - this.mJobSubmitTime;
    }

    @VisibleForTesting
    static enum JobState {
        IDLE,
        QUEUED,
        RUNNING,
        RUNNING_AND_PENDING;

    }

    public static interface JobRunnable {
        public void run(@Nullable EncodedImage var1, int var2);
    }

    @VisibleForTesting
    static class JobStartExecutorSupplier {
        private static ScheduledExecutorService sJobStarterExecutor;

        JobStartExecutorSupplier() {
        }

        static ScheduledExecutorService get() {
            if (sJobStarterExecutor == null) {
                sJobStarterExecutor = Executors.newSingleThreadScheduledExecutor();
            }
            return sJobStarterExecutor;
        }
    }
}

