/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.bitmaps;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imagepipeline.bitmaps.EmptyJpegGenerator;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.bitmaps.SimpleBitmapReleaser;
import com.facebook.imagepipeline.core.CloseableReferenceFactory;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.platform.PlatformDecoder;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/imagepipeline/bitmaps/HoneycombBitmapFactory;", "Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;", "jpegGenerator", "Lcom/facebook/imagepipeline/bitmaps/EmptyJpegGenerator;", "purgeableDecoder", "Lcom/facebook/imagepipeline/platform/PlatformDecoder;", "closeableReferenceFactory", "Lcom/facebook/imagepipeline/core/CloseableReferenceFactory;", "<init>", "(Lcom/facebook/imagepipeline/bitmaps/EmptyJpegGenerator;Lcom/facebook/imagepipeline/platform/PlatformDecoder;Lcom/facebook/imagepipeline/core/CloseableReferenceFactory;)V", "immutableBitmapFallback", "", "createBitmapInternal", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "width", "", "height", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "createFallbackBitmap", "Companion", "imagepipeline_release"})
@ThreadSafe
public final class HoneycombBitmapFactory
extends PlatformBitmapFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EmptyJpegGenerator jpegGenerator;
    @NotNull
    private final PlatformDecoder purgeableDecoder;
    @NotNull
    private final CloseableReferenceFactory closeableReferenceFactory;
    private boolean immutableBitmapFallback;
    private static final String TAG = HoneycombBitmapFactory.class.getSimpleName();

    public HoneycombBitmapFactory(@NotNull EmptyJpegGenerator jpegGenerator, @NotNull PlatformDecoder purgeableDecoder, @NotNull CloseableReferenceFactory closeableReferenceFactory) {
        Intrinsics.checkNotNullParameter((Object)jpegGenerator, (String)"jpegGenerator");
        Intrinsics.checkNotNullParameter((Object)purgeableDecoder, (String)"purgeableDecoder");
        Intrinsics.checkNotNullParameter((Object)closeableReferenceFactory, (String)"closeableReferenceFactory");
        this.jpegGenerator = jpegGenerator;
        this.purgeableDecoder = purgeableDecoder;
        this.closeableReferenceFactory = closeableReferenceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=12)
    @NotNull
    public CloseableReference<Bitmap> createBitmapInternal(int width, int height, @NotNull Bitmap.Config bitmapConfig) {
        CloseableReference<Bitmap> closeableReference;
        Intrinsics.checkNotNullParameter((Object)bitmapConfig, (String)"bitmapConfig");
        if (this.immutableBitmapFallback) {
            return this.createFallbackBitmap(width, height, bitmapConfig);
        }
        CloseableReference<PooledByteBuffer> closeableReference2 = this.jpegGenerator.generate((short)width, (short)height);
        Intrinsics.checkNotNullExpressionValue(closeableReference2, (String)"generate(...)");
        try (CloseableReference<PooledByteBuffer> jpgRef = closeableReference2;){
            CloseableReference<Bitmap> closeableReference3;
            EncodedImage encodedImage = new EncodedImage(jpgRef);
            encodedImage.setImageFormat(DefaultImageFormats.JPEG);
            try {
                CloseableReference<Bitmap> bitmapRef = this.purgeableDecoder.decodeJPEGFromEncodedImage(encodedImage, bitmapConfig, null, ((PooledByteBuffer)jpgRef.get()).size());
                if (bitmapRef == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                if (!((Bitmap)bitmapRef.get()).isMutable()) {
                    CloseableReference.closeSafely(bitmapRef);
                    this.immutableBitmapFallback = true;
                    FLog.wtf((String)TAG, (String)"Immutable bitmap returned by decoder");
                    CloseableReference<Bitmap> closeableReference4 = this.createFallbackBitmap(width, height, bitmapConfig);
                    return closeableReference4;
                }
                ((Bitmap)bitmapRef.get()).setHasAlpha(true);
                ((Bitmap)bitmapRef.get()).eraseColor(0);
                closeableReference3 = bitmapRef;
            }
            finally {
                EncodedImage.closeSafely((EncodedImage)encodedImage);
            }
            closeableReference = closeableReference3;
        }
        return closeableReference;
    }

    private final CloseableReference<Bitmap> createFallbackBitmap(int width, int height, Bitmap.Config bitmapConfig) {
        CloseableReference<Bitmap> closeableReference = this.closeableReferenceFactory.create(Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)bitmapConfig), (ResourceReleaser)SimpleBitmapReleaser.getInstance());
        Intrinsics.checkNotNullExpressionValue(closeableReference, (String)"create(...)");
        return closeableReference;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/imagepipeline/bitmaps/HoneycombBitmapFactory$Companion;", "", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "imagepipeline_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

