/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.util.SparseIntArray;
import com.facebook.common.memory.ByteArrayPool;
import com.facebook.common.memory.MemoryTrimmableRegistry;
import com.facebook.imagepipeline.memory.BasePool;
import com.facebook.imagepipeline.memory.PoolParams;
import com.facebook.imagepipeline.memory.PoolStatsTracker;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000fH\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0014J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0014J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0014J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0002H\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/facebook/imagepipeline/memory/GenericByteArrayPool;", "Lcom/facebook/imagepipeline/memory/BasePool;", "", "Lcom/facebook/common/memory/ByteArrayPool;", "memoryTrimmableRegistry", "Lcom/facebook/common/memory/MemoryTrimmableRegistry;", "poolParams", "Lcom/facebook/imagepipeline/memory/PoolParams;", "poolStatsTracker", "Lcom/facebook/imagepipeline/memory/PoolStatsTracker;", "<init>", "(Lcom/facebook/common/memory/MemoryTrimmableRegistry;Lcom/facebook/imagepipeline/memory/PoolParams;Lcom/facebook/imagepipeline/memory/PoolStatsTracker;)V", "bucketSizes", "", "minBufferSize", "", "getMinBufferSize", "()I", "alloc", "bucketedSize", "free", "", "value", "getSizeInBytes", "getBucketedSize", "requestSize", "getBucketedSizeForValue", "imagepipeline_release"})
@ThreadSafe
public class GenericByteArrayPool
extends BasePool<byte[]>
implements ByteArrayPool {
    @NotNull
    private final int[] bucketSizes;

    public GenericByteArrayPool(@NotNull MemoryTrimmableRegistry memoryTrimmableRegistry, @NotNull PoolParams poolParams, @NotNull PoolStatsTracker poolStatsTracker) {
        Intrinsics.checkNotNullParameter((Object)memoryTrimmableRegistry, (String)"memoryTrimmableRegistry");
        Intrinsics.checkNotNullParameter((Object)poolParams, (String)"poolParams");
        Intrinsics.checkNotNullParameter((Object)poolStatsTracker, (String)"poolStatsTracker");
        super(memoryTrimmableRegistry, poolParams, poolStatsTracker);
        SparseIntArray bucketSizes = poolParams.bucketSizes;
        if (bucketSizes != null) {
            this.bucketSizes = new int[bucketSizes.size()];
            int n = bucketSizes.size();
            for (int i = 0; i < n; ++i) {
                this.bucketSizes[i] = bucketSizes.keyAt(i);
            }
        } else {
            this.bucketSizes = new int[0];
        }
        this.initialize();
    }

    public final int getMinBufferSize() {
        return this.bucketSizes.length > 0 ? this.bucketSizes[0] : 0;
    }

    @Override
    @NotNull
    protected byte[] alloc(int bucketedSize) {
        return new byte[bucketedSize];
    }

    @Override
    protected void free(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
    }

    @Override
    protected int getSizeInBytes(int bucketedSize) {
        return bucketedSize;
    }

    @Override
    protected int getBucketedSize(int requestSize) {
        if (requestSize <= 0) {
            throw new BasePool.InvalidSizeException(requestSize);
        }
        for (int bucketedSize : this.bucketSizes) {
            if (bucketedSize < requestSize) continue;
            return bucketedSize;
        }
        return requestSize;
    }

    @Override
    protected int getBucketedSizeForValue(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value.length;
    }
}

