/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.transcoder;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ColorSpace;
import android.graphics.Matrix;
import android.os.Build;
import com.facebook.common.logging.FLog;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.transcoder.DownsampleUtil;
import com.facebook.imagepipeline.transcoder.ImageTranscodeResult;
import com.facebook.imagepipeline.transcoder.ImageTranscoder;
import com.facebook.imagepipeline.transcoder.JpegTranscoderUtils;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JO\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J$\u0010\u0018\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\"\u0010\u001f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lcom/facebook/imagepipeline/transcoder/SimpleImageTranscoder;", "Lcom/facebook/imagepipeline/transcoder/ImageTranscoder;", "resizingEnabled", "", "maxBitmapSize", "", "<init>", "(ZI)V", "transcode", "Lcom/facebook/imagepipeline/transcoder/ImageTranscodeResult;", "encodedImage", "Lcom/facebook/imagepipeline/image/EncodedImage;", "outputStream", "Ljava/io/OutputStream;", "rotationOptions", "Lcom/facebook/imagepipeline/common/RotationOptions;", "resizeOptions", "Lcom/facebook/imagepipeline/common/ResizeOptions;", "outputFormat", "Lcom/facebook/imageformat/ImageFormat;", "quality", "colorSpace", "Landroid/graphics/ColorSpace;", "(Lcom/facebook/imagepipeline/image/EncodedImage;Ljava/io/OutputStream;Lcom/facebook/imagepipeline/common/RotationOptions;Lcom/facebook/imagepipeline/common/ResizeOptions;Lcom/facebook/imageformat/ImageFormat;Ljava/lang/Integer;Landroid/graphics/ColorSpace;)Lcom/facebook/imagepipeline/transcoder/ImageTranscodeResult;", "canResize", "canTranscode", "imageFormat", "identifier", "", "getIdentifier", "()Ljava/lang/String;", "getSampleSize", "Companion", "imagepipeline_release"})
public final class SimpleImageTranscoder
implements ImageTranscoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean resizingEnabled;
    private final int maxBitmapSize;
    @NotNull
    private final String identifier;
    @NotNull
    private static final String TAG = "SimpleImageTranscoder";

    public SimpleImageTranscoder(boolean resizingEnabled, int maxBitmapSize) {
        this.resizingEnabled = resizingEnabled;
        this.maxBitmapSize = maxBitmapSize;
        this.identifier = TAG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ImageTranscodeResult transcode(@NotNull EncodedImage encodedImage, @NotNull OutputStream outputStream, @Nullable RotationOptions rotationOptions, @Nullable ResizeOptions resizeOptions, @Nullable ImageFormat outputFormat, @Nullable Integer quality, @Nullable ColorSpace colorSpace) {
        ImageTranscodeResult imageTranscodeResult;
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)encodedImage, (String)"encodedImage");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        RotationOptions rotationOptions2 = rotationOptions;
        Integer quality2 = quality;
        if (quality2 == null) {
            quality2 = 85;
        }
        if (rotationOptions2 == null) {
            rotationOptions2 = RotationOptions.Companion.autoRotate();
        }
        int sampleSize = this.getSampleSize(encodedImage, rotationOptions2, resizeOptions);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = sampleSize;
        if (colorSpace != null && Build.VERSION.SDK_INT >= 26) {
            options.inPreferredColorSpace = colorSpace;
        }
        try {
            bitmap = BitmapFactory.decodeStream((InputStream)encodedImage.getInputStream(), null, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError oom) {
            FLog.e((String)TAG, (String)"Out-Of-Memory during transcode", (Throwable)oom);
            return new ImageTranscodeResult(2);
        }
        Bitmap resizedBitmap = bitmap;
        if (resizedBitmap == null) {
            FLog.e((String)TAG, (String)"Couldn't decode the EncodedImage InputStream ! ");
            return new ImageTranscodeResult(2);
        }
        Matrix transformationMatrix = JpegTranscoderUtils.getTransformationMatrix((EncodedImage)encodedImage, (RotationOptions)rotationOptions2);
        Bitmap srcBitmap = resizedBitmap;
        try {
            if (transformationMatrix != null) {
                srcBitmap = Bitmap.createBitmap((Bitmap)resizedBitmap, (int)0, (int)0, (int)resizedBitmap.getWidth(), (int)resizedBitmap.getHeight(), (Matrix)transformationMatrix, (boolean)false);
            }
            srcBitmap.compress(SimpleImageTranscoder.Companion.getOutputFormat(outputFormat), quality2.intValue(), outputStream);
            imageTranscodeResult = new ImageTranscodeResult(sampleSize > 1 ? 0 : 1);
        }
        catch (OutOfMemoryError oom) {
            FLog.e((String)TAG, (String)"Out-Of-Memory during transcode", (Throwable)oom);
            imageTranscodeResult = new ImageTranscodeResult(2);
        }
        finally {
            srcBitmap.recycle();
            resizedBitmap.recycle();
        }
        return imageTranscodeResult;
    }

    public boolean canResize(@NotNull EncodedImage encodedImage, @Nullable RotationOptions rotationOptions, @Nullable ResizeOptions resizeOptions) {
        Intrinsics.checkNotNullParameter((Object)encodedImage, (String)"encodedImage");
        RotationOptions rotationOptions2 = rotationOptions;
        if (rotationOptions2 == null) {
            rotationOptions2 = RotationOptions.Companion.autoRotate();
        }
        return this.resizingEnabled && DownsampleUtil.determineSampleSize((RotationOptions)rotationOptions2, (ResizeOptions)resizeOptions, (EncodedImage)encodedImage, (int)this.maxBitmapSize) > 1;
    }

    public boolean canTranscode(@NotNull ImageFormat imageFormat) {
        Intrinsics.checkNotNullParameter((Object)imageFormat, (String)"imageFormat");
        return imageFormat == DefaultImageFormats.HEIF || imageFormat == DefaultImageFormats.JPEG;
    }

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    private final int getSampleSize(EncodedImage encodedImage, RotationOptions rotationOptions, ResizeOptions resizeOptions) {
        int sampleSize = !this.resizingEnabled ? 1 : DownsampleUtil.determineSampleSize((RotationOptions)rotationOptions, (ResizeOptions)resizeOptions, (EncodedImage)encodedImage, (int)this.maxBitmapSize);
        return sampleSize;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/imagepipeline/transcoder/SimpleImageTranscoder$Companion;", "", "<init>", "()V", "TAG", "", "getOutputFormat", "Landroid/graphics/Bitmap$CompressFormat;", "format", "Lcom/facebook/imageformat/ImageFormat;", "imagepipeline_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Bitmap.CompressFormat getOutputFormat(ImageFormat format) {
            if (format == null) {
                return Bitmap.CompressFormat.JPEG;
            }
            return format == DefaultImageFormats.JPEG ? Bitmap.CompressFormat.JPEG : (format == DefaultImageFormats.PNG ? Bitmap.CompressFormat.PNG : (Build.VERSION.SDK_INT >= 14 && DefaultImageFormats.isStaticWebpFormat((ImageFormat)format) ? Bitmap.CompressFormat.WEBP : Bitmap.CompressFormat.JPEG));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

