/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.xml;

import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import androidx.core.content.res.ResourcesCompat;
import com.facebook.common.logging.FLog;
import com.facebook.common.util.UriUtil;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.decoder.ImageDecoder;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.DefaultCloseableXml;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.image.QualityInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/imagepipeline/xml/XmlFormatDecoder;", "Lcom/facebook/imagepipeline/decoder/ImageDecoder;", "resources", "Landroid/content/res/Resources;", "<init>", "(Landroid/content/res/Resources;)V", "resourceIdCache", "", "", "", "decode", "Lcom/facebook/imagepipeline/image/CloseableImage;", "encodedImage", "Lcom/facebook/imagepipeline/image/EncodedImage;", "length", "qualityInfo", "Lcom/facebook/imagepipeline/image/QualityInfo;", "options", "Lcom/facebook/imagepipeline/common/ImageDecodeOptions;", "getXmlResourceId", "xmlResourceName", "parseImageSourceResourceId", "xmlResource", "Landroid/net/Uri;", "Companion", "imagepipeline_release"})
@SourceDebugExtension(value={"SMAP\nXmlFormatDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlFormatDecoder.kt\ncom/facebook/imagepipeline/xml/XmlFormatDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,72:1\n1#2:73\n381#3,7:74\n*S KotlinDebug\n*F\n+ 1 XmlFormatDecoder.kt\ncom/facebook/imagepipeline/xml/XmlFormatDecoder\n*L\n45#1:74,7\n*E\n"})
public final class XmlFormatDecoder
implements ImageDecoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Resources resources;
    @NotNull
    private final Map<String, Integer> resourceIdCache;
    @NotNull
    private static final String TAG = "XmlFormatDecoder";

    public XmlFormatDecoder(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        this.resources = resources;
        this.resourceIdCache = new ConcurrentHashMap();
    }

    @Nullable
    public CloseableImage decode(@NotNull EncodedImage encodedImage, int length, @NotNull QualityInfo qualityInfo, @NotNull ImageDecodeOptions options) {
        CloseableImage closeableImage;
        Intrinsics.checkNotNullParameter((Object)encodedImage, (String)"encodedImage");
        Intrinsics.checkNotNullParameter((Object)qualityInfo, (String)"qualityInfo");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        try {
            DefaultCloseableXml defaultCloseableXml;
            Drawable drawable;
            String string = encodedImage.getSource();
            if (string == null) {
                throw new IllegalStateException("No source in encoded image".toString());
            }
            String xmlResourceName = string;
            int xmlResourceId = this.getXmlResourceId(xmlResourceName);
            Drawable drawable2 = drawable = ResourcesCompat.getDrawable((Resources)this.resources, (int)xmlResourceId, null);
            if (drawable2 != null) {
                Drawable it = drawable2;
                boolean bl = false;
                defaultCloseableXml = new DefaultCloseableXml(it);
            } else {
                defaultCloseableXml = null;
            }
            closeableImage = (CloseableImage)defaultCloseableXml;
        }
        catch (Throwable error) {
            FLog.e((String)TAG, (String)"Cannot decode xml", (Throwable)error);
            closeableImage = null;
        }
        return closeableImage;
    }

    private final int getXmlResourceId(String xmlResourceName) {
        Integer n;
        Map<String, Integer> $this$getOrPut$iv = this.resourceIdCache;
        boolean $i$f$getOrPut = false;
        Integer value$iv = $this$getOrPut$iv.get(xmlResourceName);
        if (value$iv == null) {
            boolean bl = false;
            Uri uri = Uri.parse((String)xmlResourceName);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(...)");
            Integer answer$iv = this.parseImageSourceResourceId(uri);
            $this$getOrPut$iv.put(xmlResourceName, answer$iv);
            n = answer$iv;
        } else {
            n = value$iv;
        }
        return ((Number)n).intValue();
    }

    private final int parseImageSourceResourceId(Uri xmlResource) {
        Object object;
        if (UriUtil.isLocalResourceUri((Uri)xmlResource) || UriUtil.isQualifiedResourceUri((Uri)xmlResource)) {
            List list = xmlResource.getPathSegments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathSegments(...)");
            object = (String)CollectionsKt.lastOrNull((List)list);
            if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
                throw new IllegalStateException(("Unable to read resource ID from " + xmlResource.getPath()).toString());
            }
        } else {
            throw new IllegalStateException(("Unsupported uri " + xmlResource).toString());
        }
        return (Integer)object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/imagepipeline/xml/XmlFormatDecoder$Companion;", "", "<init>", "()V", "TAG", "", "imagepipeline_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

