/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.nativecode;

import com.facebook.common.internal.Closeables;
import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.nativecode.NativeJpegTranscoderSoLoader;
import com.facebook.imagepipeline.transcoder.DownsampleUtil;
import com.facebook.imagepipeline.transcoder.ImageTranscodeResult;
import com.facebook.imagepipeline.transcoder.ImageTranscoder;
import com.facebook.imagepipeline.transcoder.JpegTranscoderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;

@DoNotStrip
public class NativeJpegTranscoder
implements ImageTranscoder {
    public static final String TAG = "NativeJpegTranscoder";
    private boolean mResizingEnabled;
    private int mMaxBitmapSize;
    private boolean mUseDownsamplingRatio;

    public NativeJpegTranscoder(boolean resizingEnabled, int maxBitmapSize, boolean useDownsamplingRatio) {
        this.mResizingEnabled = resizingEnabled;
        this.mMaxBitmapSize = maxBitmapSize;
        this.mUseDownsamplingRatio = useDownsamplingRatio;
    }

    public boolean canResize(EncodedImage encodedImage, @Nullable RotationOptions rotationOptions, @Nullable ResizeOptions resizeOptions) {
        if (rotationOptions == null) {
            rotationOptions = RotationOptions.autoRotate();
        }
        return JpegTranscoderUtils.getSoftwareNumerator((RotationOptions)rotationOptions, (ResizeOptions)resizeOptions, (EncodedImage)encodedImage, (boolean)this.mResizingEnabled) < 8;
    }

    public boolean canTranscode(ImageFormat imageFormat) {
        return imageFormat == DefaultImageFormats.JPEG;
    }

    public String getIdentifier() {
        return TAG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageTranscodeResult transcode(EncodedImage encodedImage, OutputStream outputStream, @Nullable RotationOptions rotationOptions, @Nullable ResizeOptions resizeOptions, @Nullable ImageFormat outputFormat, @Nullable Integer quality) throws IOException {
        InputStream is;
        int downsampleRatio;
        block5: {
            if (quality == null) {
                quality = 85;
            }
            if (rotationOptions == null) {
                rotationOptions = RotationOptions.autoRotate();
            }
            downsampleRatio = DownsampleUtil.determineSampleSize((RotationOptions)rotationOptions, (ResizeOptions)resizeOptions, (EncodedImage)encodedImage, (int)this.mMaxBitmapSize);
            is = null;
            try {
                int softwareNumerator = JpegTranscoderUtils.getSoftwareNumerator((RotationOptions)rotationOptions, (ResizeOptions)resizeOptions, (EncodedImage)encodedImage, (boolean)this.mResizingEnabled);
                int downsampleNumerator = JpegTranscoderUtils.calculateDownsampleNumerator((int)downsampleRatio);
                int numerator = this.mUseDownsamplingRatio ? downsampleNumerator : softwareNumerator;
                is = encodedImage.getInputStream();
                if (JpegTranscoderUtils.INVERTED_EXIF_ORIENTATIONS.contains((Object)encodedImage.getExifOrientation())) {
                    int exifOrientation = JpegTranscoderUtils.getForceRotatedInvertedExifOrientation((RotationOptions)rotationOptions, (EncodedImage)encodedImage);
                    NativeJpegTranscoder.transcodeJpegWithExifOrientation(is, outputStream, exifOrientation, numerator, quality);
                    break block5;
                }
                int rotationAngle = JpegTranscoderUtils.getRotationAngle((RotationOptions)rotationOptions, (EncodedImage)encodedImage);
                NativeJpegTranscoder.transcodeJpeg(is, outputStream, rotationAngle, numerator, quality);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(is);
                throw throwable;
            }
        }
        Closeables.closeQuietly((InputStream)is);
        return new ImageTranscodeResult(downsampleRatio == 1 ? 1 : 0);
    }

    @VisibleForTesting
    public static void transcodeJpeg(InputStream inputStream, OutputStream outputStream, int rotationAngle, int scaleNumerator, int quality) throws IOException {
        NativeJpegTranscoderSoLoader.ensure();
        Preconditions.checkArgument((scaleNumerator >= 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((scaleNumerator <= 16 ? 1 : 0) != 0);
        Preconditions.checkArgument((quality >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((quality <= 100 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)JpegTranscoderUtils.isRotationAngleAllowed((int)rotationAngle));
        Preconditions.checkArgument((scaleNumerator != 8 || rotationAngle != 0 ? 1 : 0) != 0, (Object)"no transformation requested");
        NativeJpegTranscoder.nativeTranscodeJpeg((InputStream)Preconditions.checkNotNull((Object)inputStream), (OutputStream)Preconditions.checkNotNull((Object)outputStream), rotationAngle, scaleNumerator, quality);
    }

    @DoNotStrip
    private static native void nativeTranscodeJpeg(InputStream var0, OutputStream var1, int var2, int var3, int var4) throws IOException;

    @VisibleForTesting
    public static void transcodeJpegWithExifOrientation(InputStream inputStream, OutputStream outputStream, int exifOrientation, int scaleNumerator, int quality) throws IOException {
        NativeJpegTranscoderSoLoader.ensure();
        Preconditions.checkArgument((scaleNumerator >= 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((scaleNumerator <= 16 ? 1 : 0) != 0);
        Preconditions.checkArgument((quality >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((quality <= 100 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)JpegTranscoderUtils.isExifOrientationAllowed((int)exifOrientation));
        Preconditions.checkArgument((scaleNumerator != 8 || exifOrientation != 1 ? 1 : 0) != 0, (Object)"no transformation requested");
        NativeJpegTranscoder.nativeTranscodeJpegWithExifOrientation((InputStream)Preconditions.checkNotNull((Object)inputStream), (OutputStream)Preconditions.checkNotNull((Object)outputStream), exifOrientation, scaleNumerator, quality);
    }

    @DoNotStrip
    private static native void nativeTranscodeJpegWithExifOrientation(InputStream var0, OutputStream var1, int var2, int var3, int var4) throws IOException;

    static {
        NativeJpegTranscoderSoLoader.ensure();
    }
}

