/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.stetho;

import android.graphics.Bitmap;
import android.os.Environment;
import android.util.SparseIntArray;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.disk.DiskStorage;
import com.facebook.cache.disk.FileCache;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.time.RealtimeSinceBootClock;
import com.facebook.imagepipeline.cache.BitmapMemoryCacheKey;
import com.facebook.imagepipeline.cache.CountingMemoryCache;
import com.facebook.imagepipeline.cache.CountingMemoryCacheInspector;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.core.ImagePipelineFactory;
import com.facebook.imagepipeline.image.CloseableBitmap;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.stetho.dumpapp.DumpException;
import com.facebook.stetho.dumpapp.DumpUsageException;
import com.facebook.stetho.dumpapp.DumperContext;
import com.facebook.stetho.dumpapp.DumperPlugin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 C2\u00020\u0001:\u0001CB\u000f\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J.\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"H\u0002J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0016H$J$\u0010'\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0)H\u0002J\b\u0010*\u001a\u00020\u001eH\u0016J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0004J\u001e\u0010,\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"H\u0002J\u0018\u0010-\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010(\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J:\u00100\u001a\u00020\u00162\u0018\u00101\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t020\"2\u0006\u00103\u001a\u0002042\u0006\u0010\u001f\u001a\u00020 2\u0006\u00105\u001a\u000206H\u0002J(\u00107\u001a\u00020\u00162\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u0002062\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u000204H\u0002J$\u0010>\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t02H\u0002J\u0018\u0010?\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010@\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010A\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010(\u001a\u00020.H\u0002J\u0018\u0010B\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010(\u001a\u00020.H\u0002R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/facebook/imagepipeline/stetho/BaseFrescoStethoPlugin;", "Lcom/facebook/stetho/dumpapp/DumperPlugin;", "factory", "Lcom/facebook/imagepipeline/core/ImagePipelineFactory;", "(Lcom/facebook/imagepipeline/core/ImagePipelineFactory;)V", "()V", "bitmapMemoryCacheInspector", "Lcom/facebook/imagepipeline/cache/CountingMemoryCacheInspector;", "Lcom/facebook/cache/common/CacheKey;", "Lcom/facebook/imagepipeline/image/CloseableImage;", "imagePipeline", "Lcom/facebook/imagepipeline/core/ImagePipeline;", "initialized", "", "getInitialized", "()Z", "setInitialized", "(Z)V", "mainFileCache", "Lcom/facebook/cache/disk/FileCache;", "smallFileCache", "addToHistogram", "", "histogram", "Landroid/util/SparseIntArray;", "entry", "Lcom/facebook/cache/disk/DiskStorage$DiskDumpInfoEntry;", "diskcache", "cache", "title", "", "writer", "Ljava/io/PrintStream;", "args", "", "dump", "dumpContext", "Lcom/facebook/stetho/dumpapp/DumperContext;", "ensureInitialized", "getFiles", "dumpInfo", "Lcom/facebook/imagepipeline/cache/CountingMemoryCacheInspector$DumpInfo;", "getName", "initialize", "memcache", "printFileTypes", "Lcom/facebook/cache/disk/DiskStorage$DiskDumpInfo;", "printHistogram", "storeEntries", "entries", "Lcom/facebook/imagepipeline/cache/CountingMemoryCacheInspector$DumpInfoEntry;", "i", "", "directory", "Ljava/io/File;", "storeImage", "image", "Landroid/graphics/Bitmap;", "pictureFile", "compressionFormat", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "writeCacheEntry", "writeDiskDumpEntry", "writeDiskDumpEntryScriptReadable", "writeDiskDumpInfo", "writeDiskDumpInfoScriptReadable", "Companion", "stetho_release"})
public abstract class BaseFrescoStethoPlugin
implements DumperPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean initialized;
    @Nullable
    private CountingMemoryCacheInspector<CacheKey, CloseableImage> bitmapMemoryCacheInspector;
    @Nullable
    private FileCache mainFileCache;
    @Nullable
    private FileCache smallFileCache;
    @Nullable
    private ImagePipeline imagePipeline;
    @NotNull
    private static final String NAME = "image";
    private static final float KB = 1024.0f;

    public BaseFrescoStethoPlugin() {
    }

    protected final boolean getInitialized() {
        return this.initialized;
    }

    protected final void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    protected BaseFrescoStethoPlugin(@NotNull ImagePipelineFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this();
        this.initialize(factory);
    }

    protected abstract void ensureInitialized() throws DumpException;

    protected final void initialize(@NotNull ImagePipelineFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        CountingMemoryCache countingMemoryCache = factory.getBitmapCountingMemoryCache();
        Intrinsics.checkNotNullExpressionValue((Object)countingMemoryCache, (String)"factory.bitmapCountingMemoryCache");
        this.bitmapMemoryCacheInspector = new CountingMemoryCacheInspector(countingMemoryCache);
        this.mainFileCache = factory.getMainFileCache();
        this.smallFileCache = factory.getSmallImageFileCache();
        this.imagePipeline = factory.getImagePipeline();
        this.initialized = true;
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    public void dump(@NotNull DumperContext dumpContext) throws DumpException {
        Intrinsics.checkNotNullParameter((Object)dumpContext, (String)"dumpContext");
        this.ensureInitialized();
        List args = dumpContext.getArgsAsList();
        PrintStream writer = dumpContext.getStdout();
        String cmd = args.isEmpty() ? null : (String)args.get(0);
        List<String> rest = args.isEmpty() ? (List<String>)new ArrayList() : args.subList(1, args.size());
        if (cmd != null && Intrinsics.areEqual((Object)cmd, (Object)"memcache")) {
            Intrinsics.checkNotNullExpressionValue((Object)writer, (String)"writer");
            this.memcache(writer, rest);
        } else if (cmd != null && Intrinsics.areEqual((Object)cmd, (Object)"diskcache")) {
            FileCache fileCache = this.mainFileCache;
            if (fileCache == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            FileCache mainFileCache = fileCache;
            FileCache fileCache2 = this.smallFileCache;
            if (fileCache2 == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            FileCache smallFileCache = fileCache2;
            Intrinsics.checkNotNullExpressionValue((Object)writer, (String)"writer");
            this.diskcache(mainFileCache, "Main", writer, rest);
            this.diskcache(smallFileCache, "Small", writer, rest);
        } else if (cmd != null && Intrinsics.areEqual((Object)cmd, (Object)"clear")) {
            ImagePipeline imagePipeline = this.imagePipeline;
            if (imagePipeline == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            ImagePipeline imagePipeline2 = imagePipeline;
            imagePipeline2.clearCaches();
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)writer, (String)"writer");
            BaseFrescoStethoPlugin.Companion.usage(writer);
            CharSequence charSequence = cmd;
            if (charSequence == null || charSequence.length() == 0) {
                throw new DumpUsageException("Missing command");
            }
            throw new DumpUsageException("Unknown command: " + cmd);
        }
    }

    private final void diskcache(FileCache cache, String title, PrintStream writer, List<String> args) throws DumpException {
        DiskStorage.DiskDumpInfo diskDumpInfo;
        try {
            diskDumpInfo = cache.getDumpInfo();
        }
        catch (IOException e) {
            throw new DumpException(e.getMessage());
        }
        DiskStorage.DiskDumpInfo diskDumpInfo2 = diskDumpInfo;
        Intrinsics.checkNotNullExpressionValue((Object)diskDumpInfo2, (String)"try {\n          cache.du\u2026tion(e.message)\n        }");
        DiskStorage.DiskDumpInfo intDiskDumpInfo = diskDumpInfo2;
        if (!((Collection)args).isEmpty() && Intrinsics.areEqual((Object)args.get(0), (Object)"-s")) {
            this.writeDiskDumpInfoScriptReadable(writer, intDiskDumpInfo);
        } else {
            writer.println();
            writer.println(title + " disk cache contents:");
            this.writeDiskDumpInfo(writer, intDiskDumpInfo);
        }
    }

    private final void writeDiskDumpInfo(PrintStream writer, DiskStorage.DiskDumpInfo dumpInfo) {
        if (dumpInfo.entries.isEmpty()) {
            writer.println("Empty");
            return;
        }
        SparseIntArray histogram = BaseFrescoStethoPlugin.Companion.emptyHistogram();
        float total = 0.0f;
        for (DiskStorage.DiskDumpInfoEntry entry : dumpInfo.entries) {
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
            this.writeDiskDumpEntry(writer, entry);
            this.addToHistogram(histogram, entry);
            total += entry.size;
        }
        writer.println();
        Object[] objectArray = new Object[]{Float.valueOf(total / (float)1024 / 1024.0f)};
        writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("Total size: %.1f MB", objectArray));
        this.printFileTypes(writer, dumpInfo);
        this.printHistogram(writer, histogram);
    }

    private final void printFileTypes(PrintStream writer, DiskStorage.DiskDumpInfo dumpInfo) {
        writer.println();
        writer.println("File Type Counts:");
        for (String type : dumpInfo.typeCounts.keySet()) {
            Object v = dumpInfo.typeCounts.get(type);
            if (v == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            int typeCounts = ((Number)v).intValue();
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
            objectArray[0] = type;
            objectArray[1] = typeCounts;
            writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("%4s: %5d", objectArray));
        }
    }

    private final void addToHistogram(SparseIntArray histogram, DiskStorage.DiskDumpInfoEntry entry) {
        int n = histogram.size();
        for (int i = 0; i < n; ++i) {
            int key = histogram.keyAt(i);
            if (!(entry.size / 1024.0f < (float)key)) continue;
            histogram.put(key, histogram.get(key) + 1);
            return;
        }
        histogram.put((int)(entry.size / 1024.0f), 1);
    }

    private final void printHistogram(PrintStream writer, SparseIntArray histogram) {
        writer.println();
        writer.println("File Size Counts:");
        int n = histogram.size();
        for (int i = 1; i < n; ++i) {
            int lb = histogram.keyAt(i - 1);
            int ub = histogram.keyAt(i);
            Object[] objectArray = new Object[]{lb, ub, histogram.get(ub)};
            writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("%4d-%4dK: %3d", objectArray));
        }
    }

    private final void writeDiskDumpEntry(PrintStream writer, DiskStorage.DiskDumpInfoEntry entry) {
        if (entry.firstBits != null) {
            String string = entry.firstBits;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.firstBits");
            if (((CharSequence)string).length() > 0) {
                writer.println("Undefined: " + entry.firstBits);
            }
        }
        Object[] objectArray = new Object[3];
        Intrinsics.checkNotNullExpressionValue((Object)entry.type, (String)"entry.type");
        objectArray[1] = Float.valueOf(entry.size / 1024.0f);
        Intrinsics.checkNotNullExpressionValue((Object)entry.path, (String)"entry.path");
        writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("type: %5s size: %7.2fkB path: %9s", objectArray));
    }

    private final void writeDiskDumpInfoScriptReadable(PrintStream writer, DiskStorage.DiskDumpInfo dumpInfo) {
        for (DiskStorage.DiskDumpInfoEntry entry : dumpInfo.entries) {
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
            this.writeDiskDumpEntryScriptReadable(writer, entry);
        }
    }

    private final void writeDiskDumpEntryScriptReadable(PrintStream writer, DiskStorage.DiskDumpInfoEntry entry) {
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)entry.type, (String)"entry.type");
        Intrinsics.checkNotNullExpressionValue((Object)entry.path, (String)"entry.path");
        writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("%s\t%s", objectArray));
    }

    private final void writeCacheEntry(PrintStream writer, CountingMemoryCacheInspector.DumpInfoEntry<CacheKey, CloseableImage> entry) {
        if (!(entry.key instanceof BitmapMemoryCacheKey)) {
            writer.println("Undefined: " + entry.key.getClass());
        }
        Object object = entry.key;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.facebook.imagepipeline.cache.BitmapMemoryCacheKey");
        BitmapMemoryCacheKey cacheKey = (BitmapMemoryCacheKey)object;
        CloseableReference closeableReference = entry.value;
        if (closeableReference == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        CloseableReference entryValue = closeableReference;
        Object[] objectArray = new Object[6];
        objectArray[0] = Float.valueOf((float)((CloseableImage)entryValue.get()).getSizeInBytes() / 1024.0f);
        objectArray[1] = ((CloseableImage)entryValue.get()).getWidth();
        objectArray[2] = ((CloseableImage)entryValue.get()).getHeight();
        objectArray[3] = entry.key;
        if (cacheKey.getCallerContext() == null) {
            Object cfr_ignored_0 = objectArray[4];
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        objectArray[5] = RealtimeSinceBootClock.get().now() - cacheKey.getInBitmapCacheSince();
        writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("size: %7.2fkB (%4d x %4d) key: %s, %s, duration: %dms", objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void memcache(PrintStream writer, List<String> args) throws DumpException {
        CountingMemoryCacheInspector<CacheKey, CloseableImage> countingMemoryCacheInspector = this.bitmapMemoryCacheInspector;
        if (countingMemoryCacheInspector == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        CountingMemoryCacheInspector<CacheKey, CloseableImage> bitmapMemoryCacheInspector = countingMemoryCacheInspector;
        CountingMemoryCacheInspector.DumpInfo dumpInfo = bitmapMemoryCacheInspector.dumpCacheContent();
        try {
            writer.println(bitmapMemoryCacheInspector.getClass().getSimpleName());
            writer.println();
            writer.println("Params:");
            Object object = new Object[]{(double)dumpInfo.maxSize / 1048576.0};
            writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("Max size:          %7.2fMB", (Object[])object));
            object = new Object[]{dumpInfo.maxEntriesCount};
            writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("Max entries count: %9d", (Object[])object));
            object = new Object[]{(double)dumpInfo.maxEntrySize / 1048576.0};
            writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("Max entry size:    %7.2fMB", (Object[])object));
            writer.println();
            writer.println("Summary of current content:");
            object = new Object[]{(double)dumpInfo.size / 1048576.0};
            writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("Total size:        %7.2fMB (includes in-use content)", (Object[])object));
            object = new Object[]{dumpInfo.lruEntries.size() + dumpInfo.sharedEntries.size()};
            writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("Entries count:     %9d", (Object[])object));
            object = new Object[]{(double)dumpInfo.lruSize / 1048576.0};
            writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("LRU size:          %7.2fMB", (Object[])object));
            object = new Object[]{dumpInfo.lruEntries.size()};
            writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("LRU count:         %9d", (Object[])object));
            object = new Object[]{(double)(dumpInfo.size - dumpInfo.lruSize) / 1048576.0};
            writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("Shared size:       %7.2fMB", (Object[])object));
            object = new Object[]{dumpInfo.sharedEntries.size()};
            writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("Shared count:      %9d", (Object[])object));
            writer.println();
            writer.println("The cache consists of two parts: Things currently being used and things not.");
            writer.println("Those things that are *not* currently being used are in the LRU.");
            writer.println("Things currently being used are considered to be shared. They will be added");
            writer.println("to the LRU if/when they stop being used.");
            writer.println();
            writer.println("LRU contents: (things near the top will be evicted first)");
            for (CountingMemoryCacheInspector.DumpInfoEntry entry : dumpInfo.lruEntries) {
                this.writeCacheEntry(writer, (CountingMemoryCacheInspector.DumpInfoEntry<CacheKey, CloseableImage>)entry);
            }
            writer.println();
            writer.println("Shared contents:");
            for (CountingMemoryCacheInspector.DumpInfoEntry entry : dumpInfo.sharedEntries) {
                this.writeCacheEntry(writer, (CountingMemoryCacheInspector.DumpInfoEntry<CacheKey, CloseableImage>)entry);
            }
            if (!((Collection)args).isEmpty() && Intrinsics.areEqual((Object)"-g", (Object)args.get(0))) {
                this.getFiles(writer, (CountingMemoryCacheInspector.DumpInfo<CacheKey, CloseableImage>)dumpInfo);
            }
        }
        catch (IOException e) {
            throw new DumpException(e.getMessage());
        }
        finally {
            dumpInfo.release();
        }
    }

    private final void getFiles(PrintStream writer, CountingMemoryCacheInspector.DumpInfo<CacheKey, CloseableImage> dumpInfo) throws DumpException, IOException {
        writer.println("\nStoring all images in the memory cache into /sdcard/imagedumperfiles/ ...");
        File dir = new File(Environment.getExternalStorageDirectory().getPath() + "/imagedumperfiles/");
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    file.delete();
                }
            }
            if (!dir.delete()) {
                throw new DumpException("Failed to clear existing /sdcard/imagedumperfiles directory");
            }
        }
        if (!dir.mkdirs()) {
            throw new DumpException("Failed to create /sdcard/imagedumperfiles directory");
        }
        if (!((Collection)dumpInfo.lruEntries).isEmpty()) {
            writer.println("LRU Entries:");
            this.storeEntries(dumpInfo.lruEntries, 1, writer, dir);
        }
        if (!((Collection)dumpInfo.sharedEntries).isEmpty()) {
            writer.println("Shared Entries:");
            this.storeEntries(dumpInfo.sharedEntries, dumpInfo.lruEntries.size() + 1, writer, dir);
        }
        writer.println("Done!");
    }

    private final void storeEntries(List<CountingMemoryCacheInspector.DumpInfoEntry<CacheKey, CloseableImage>> entries, int i, PrintStream writer, File directory) throws IOException {
        int i2 = i;
        String filename = null;
        for (CountingMemoryCacheInspector.DumpInfoEntry<CacheKey, CloseableImage> entry : entries) {
            CloseableReference entryValue;
            Object[] objectArray;
            if (entry.value == null) {
                objectArray = "Required value was null.";
                throw new IllegalStateException(objectArray.toString());
            }
            Object object = entryValue.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entryValue.get()");
            CloseableImage closeableImage = (CloseableImage)object;
            if (closeableImage instanceof CloseableBitmap) {
                filename = "tmp" + i2 + ".png";
                objectArray = new Object[]{i2, filename, entry.key};
                writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("Storing image %d as %s. Key: %s", objectArray));
                Bitmap bitmap = ((CloseableBitmap)closeableImage).getUnderlyingBitmap();
                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"closeableImage.underlyingBitmap");
                this.storeImage(bitmap, new File(directory, filename), Bitmap.CompressFormat.PNG, 100);
            } else {
                objectArray = new Object[]{i2, closeableImage, entry.key};
                writer.println(BaseFrescoStethoPlugin.Companion.formatStrLocaleSafe("Image %d has unrecognized type %s. Key: %s", objectArray));
            }
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void storeImage(Bitmap image, File pictureFile, Bitmap.CompressFormat compressionFormat, int quality) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(pictureFile);
            image.compress(compressionFormat, quality, (OutputStream)fos);
        }
        catch (FileNotFoundException e) {
            try {
                throw new IOException(e.getMessage());
            }
            catch (Throwable throwable) {
                FileOutputStream fileOutputStream = fos;
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                throw throwable;
            }
        }
        fos.close();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J)\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\f\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/imagepipeline/stetho/BaseFrescoStethoPlugin$Companion;", "", "()V", "KB", "", "NAME", "", "emptyHistogram", "Landroid/util/SparseIntArray;", "formatStrLocaleSafe", "format", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "usage", "", "writer", "Ljava/io/PrintStream;", "stetho_release"})
    public static final class Companion {
        private Companion() {
        }

        private final SparseIntArray emptyHistogram() {
            SparseIntArray histogram = new SparseIntArray();
            histogram.put(0, 0);
            histogram.put(5, 0);
            histogram.put(10, 0);
            histogram.put(20, 0);
            histogram.put(50, 0);
            histogram.put(100, 0);
            histogram.put(200, 0);
            histogram.put(512, 0);
            histogram.put(1024, 0);
            return histogram;
        }

        private final void usage(PrintStream writer) {
            String cmdName = "dumpapp image";
            String usagePrefix = "Usage: " + cmdName + ' ';
            writer.println(usagePrefix + "<command> [command-options]");
            writer.println(usagePrefix + "memcache|diskcache");
            writer.println();
            writer.println(cmdName + " memcache: Show contents of bitmap memory cache.");
            writer.println(cmdName + " memcache -g: Get contents of bitmap memory cache and store themon the sdcard.");
            writer.println(cmdName + " diskcache: Show contents of disk storage cache.");
            writer.println(cmdName + " diskcache -s: Show contents of disk storage cache formatted for script consumption.");
            writer.println(cmdName + " clear: Clear all caches.");
            writer.println();
        }

        private final String formatStrLocaleSafe(String format, Object ... args) {
            Locale locale = null;
            String string = "  " + format;
            Object[] objectArray = Arrays.copyOf(args, args.length);
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

