/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.BitFieldReader;
import com.facebook.hive.orc.BitFieldWriter;
import com.facebook.hive.orc.CompressionCodec;
import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.OutStream;
import com.facebook.hive.orc.PositionRecorder;
import com.facebook.hive.orc.PositionedOutputStream;
import com.facebook.hive.orc.TestInStream;
import com.facebook.hive.orc.WriterImpl;
import com.facebook.hive.orc.ZlibCodec;
import java.nio.ByteBuffer;
import junit.framework.Assert;
import org.junit.Test;

public class TestBitFieldReader {
    public void runSeekTest(CompressionCodec codec) throws Exception {
        int x;
        int i;
        TestInStream.OutputCollector collect = new TestInStream.OutputCollector();
        int COUNT = 16384;
        BitFieldWriter out = new BitFieldWriter((PositionedOutputStream)new OutStream("test", 500, codec, (OutStream.OutputReceiver)collect), 1);
        OrcProto.RowIndex.Builder rowIndex = OrcProto.RowIndex.newBuilder();
        OrcProto.RowIndexEntry.Builder rowIndexEntry = OrcProto.RowIndexEntry.newBuilder();
        WriterImpl.RowIndexPositionRecorder rowIndexPosition = new WriterImpl.RowIndexPositionRecorder(rowIndexEntry);
        for (int i2 = 0; i2 < 16384; ++i2) {
            out.getPosition((PositionRecorder)rowIndexPosition);
            rowIndex.addEntry(rowIndexEntry.build());
            rowIndexEntry.clear();
            if (i2 < 8192) {
                out.write(i2 & 1);
                continue;
            }
            out.write(i2 / 3 & 1);
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        BitFieldReader in = new BitFieldReader(InStream.create((String)"test", (ByteBuffer)inBuf, (CompressionCodec)codec, (int)500));
        for (i = 0; i < 16384; ++i) {
            x = in.next();
            if (i < 8192) {
                Assert.assertEquals((int)(i & 1), (int)x);
                continue;
            }
            Assert.assertEquals((int)(i / 3 & 1), (int)x);
        }
        in.loadIndeces(rowIndex.build().getEntryList(), 0);
        for (i = 16383; i >= 0; --i) {
            in.seek(i);
            x = in.next();
            if (i < 8192) {
                Assert.assertEquals((int)(i & 1), (int)x);
                continue;
            }
            Assert.assertEquals((int)(i / 3 & 1), (int)x);
        }
    }

    @Test
    public void testUncompressedSeek() throws Exception {
        this.runSeekTest(null);
    }

    @Test
    public void testCompressedSeek() throws Exception {
        this.runSeekTest((CompressionCodec)new ZlibCodec());
    }

    @Test
    public void testSkips() throws Exception {
        TestInStream.OutputCollector collect = new TestInStream.OutputCollector();
        BitFieldWriter out = new BitFieldWriter((PositionedOutputStream)new OutStream("test", 100, null, (OutStream.OutputReceiver)collect), 1);
        int COUNT = 16384;
        for (int i = 0; i < 16384; ++i) {
            if (i < 8192) {
                out.write(i & 1);
                continue;
            }
            out.write(i / 3 & 1);
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        BitFieldReader in = new BitFieldReader(InStream.create((String)"test", (ByteBuffer)inBuf, null, (int)100));
        for (int i = 0; i < 16384; i += 5) {
            int x = in.next();
            if (i < 8192) {
                Assert.assertEquals((int)(i & 1), (int)x);
            } else {
                Assert.assertEquals((int)(i / 3 & 1), (int)x);
            }
            if (i < 16379) {
                in.skip(4L);
            }
            in.skip(0L);
        }
    }
}

