/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.DynamicByteArray;
import com.facebook.hive.orc.DynamicIntArray;
import com.facebook.hive.orc.DynamicLongArray;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class TestDynamicArray {
    @Test
    public void testByteArray() throws Exception {
        DynamicByteArray dba = new DynamicByteArray(10);
        dba.add((byte)0);
        dba.add((byte)1);
        dba.set(3, (byte)3);
        dba.set(2, (byte)2);
        dba.add((byte)4);
        Assert.assertEquals((Object)"{0,1,2,3,4}", (Object)dba.toString());
        Assert.assertEquals((long)5L, (long)dba.size());
        for (int b = -128; b < 128; ++b) {
            dba.add((byte)b);
        }
        byte[] val = new byte[1024];
        Random rand = new Random(1701L);
        for (int i = 0; i < val.length; ++i) {
            rand.nextBytes(val);
        }
        dba.add(val, 0, 1024);
        Assert.assertEquals((long)1285L, (long)dba.size());
    }

    @Test
    public void testIntArray() throws Exception {
        int i;
        DynamicIntArray dia = new DynamicIntArray(10);
        for (i = 0; i < 10000; ++i) {
            dia.add(2 * i);
        }
        Assert.assertEquals((long)10000L, (long)dia.size());
        for (i = 0; i < 10000; ++i) {
            Assert.assertEquals((long)(2 * i), (long)dia.get(i));
        }
        dia.clear();
        Assert.assertEquals((long)0L, (long)dia.size());
        dia.add(3);
        dia.add(12);
        dia.add(65);
        Assert.assertEquals((Object)"{3,12,65}", (Object)dia.toString());
        for (i = 0; i < 5; ++i) {
            dia.increment(i, 3);
        }
        Assert.assertEquals((Object)"{6,15,68,3,3}", (Object)dia.toString());
    }

    @Test
    public void testLongArray() throws Exception {
        int i;
        DynamicLongArray dia = new DynamicLongArray(10);
        for (i = 0; i < 10000; ++i) {
            dia.add((long)(2 * i) + Integer.MAX_VALUE);
        }
        Assert.assertEquals((long)10000L, (long)dia.size());
        for (i = 0; i < 10000; ++i) {
            Assert.assertEquals((long)((long)(2 * i) + Integer.MAX_VALUE), (long)dia.get(i));
        }
        dia.clear();
        Assert.assertEquals((long)0L, (long)dia.size());
        dia.add(3L);
        dia.add(12L);
        dia.add(65L);
        Assert.assertEquals((Object)"{3,12,65}", (Object)dia.toString());
        for (i = 0; i < 5; ++i) {
            dia.increment(i, 3L);
        }
        Assert.assertEquals((Object)"{6,15,68,3,3}", (Object)dia.toString());
    }
}

