/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.CompressionKind;
import com.facebook.hive.orc.FileDump;
import com.facebook.hive.orc.MemoryManager;
import com.facebook.hive.orc.OrcConf;
import com.facebook.hive.orc.TestOrcFile;
import com.facebook.hive.orc.WriterImpl;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.junit.Before;
import org.junit.Test;

public class TestFileDump {
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    Configuration conf;
    FileSystem fs;
    Path testFilePath;

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.fs.setWorkingDirectory(this.workDir);
        this.fs.mkdirs(this.workDir);
        this.testFilePath = new Path("TestFileDump.testDump.orc");
        this.fs.delete(this.testFilePath, false);
    }

    private static void checkOutput(String expected, String actual) throws Exception {
        BufferedReader eStream = new BufferedReader(new FileReader(expected));
        BufferedReader aStream = new BufferedReader(new FileReader(actual));
        String line = eStream.readLine();
        while (line != null) {
            Assert.assertEquals((String)line, (String)aStream.readLine());
            line = eStream.readLine();
        }
        Assert.assertNull((Object)eStream.readLine());
        Assert.assertNull((Object)aStream.readLine());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDump() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRecord.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            WriterImpl writer = new WriterImpl(this.fs, this.testFilePath, this.conf, inspector, 100000L, CompressionKind.SNAPPY, 10000, 10000, new MemoryManager(this.conf));
            Random r1 = new Random(1L);
            String[] words = new String[]{"It", "was", "the", "best", "of", "times,", "it", "was", "the", "worst", "of", "times,", "it", "was", "the", "age", "of", "wisdom,", "it", "was", "the", "age", "of", "foolishness,", "it", "was", "the", "epoch", "of", "belief,", "it", "was", "the", "epoch", "of", "incredulity,", "it", "was", "the", "season", "of", "Light,", "it", "was", "the", "season", "of", "Darkness,", "it", "was", "the", "spring", "of", "hope,", "it", "was", "the", "winter", "of", "despair,", "we", "had", "everything", "before", "us,", "we", "had", "nothing", "before", "us,", "we", "were", "all", "going", "direct", "to", "Heaven,", "we", "were", "all", "going", "direct", "the", "other", "way"};
            for (int i = 0; i < 21000; ++i) {
                int curNum = r1.nextInt(words.length);
                writer.addRow((Object)new MyRecord(curNum, (long)curNum + Integer.MAX_VALUE, words[curNum]));
            }
            writer.close();
            PrintStream origOut = System.out;
            URL expectedFileUrl = Resources.getResource((String)"orc-file-dump.out");
            String outputFilename = this.workDir + File.separator + "orc-file-dump.out";
            FileOutputStream myOut = new FileOutputStream(outputFilename);
            System.setOut(new PrintStream(myOut));
            FileDump.main((String[])new String[]{this.testFilePath.getName()});
            System.out.flush();
            System.setOut(origOut);
            TestFileDump.checkOutput(expectedFileUrl.getPath(), outputFilename);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDictionary(Configuration conf, String expectedOutputFilename) throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRecord.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            OrcConf.setFloatVar((Configuration)conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_ENTROPY_KEY_STRING_SIZE_THRESHOLD, (float)-1.0f);
            WriterImpl writer = new WriterImpl(this.fs, this.testFilePath, conf, inspector, 100000L, CompressionKind.SNAPPY, 10000, 10000, new MemoryManager(conf));
            Random r1 = new Random(1L);
            String[] words = new String[]{"It", "was", "the", "best", "of", "times,", "it", "was", "the", "worst", "of", "times,", "it", "was", "the", "age", "of", "wisdom,", "it", "was", "the", "age", "of", "foolishness,", "it", "was", "the", "epoch", "of", "belief,", "it", "was", "the", "epoch", "of", "incredulity,", "it", "was", "the", "season", "of", "Light,", "it", "was", "the", "season", "of", "Darkness,", "it", "was", "the", "spring", "of", "hope,", "it", "was", "the", "winter", "of", "despair,", "we", "had", "everything", "before", "us,", "we", "had", "nothing", "before", "us,", "we", "were", "all", "going", "direct", "to", "Heaven,", "we", "were", "all", "going", "direct", "the", "other", "way"};
            int nextInt = 0;
            int nextNumIdx = 0;
            int numRows = 21000;
            ArrayList<Integer> intVals = new ArrayList<Integer>(words.length);
            ArrayList<Long> longVals = new ArrayList<Long>(words.length);
            boolean prevInt = false;
            long prevLong = 0L;
            for (i = 0; i < numRows; ++i) {
                intVals.add(i);
                longVals.add((long)i + Integer.MAX_VALUE);
            }
            Collections.shuffle(intVals, r1);
            Collections.shuffle(longVals, r1);
            for (i = 0; i < numRows; ++i) {
                if (i % 2 == 0) {
                    nextInt = r1.nextInt(words.length);
                    nextNumIdx = i;
                    int n = nextInt;
                    words[n] = words[n] + "-" + i;
                }
                writer.addRow((Object)new MyRecord((Integer)intVals.get(nextNumIdx), (Long)longVals.get(nextNumIdx), words[nextInt]));
            }
            writer.close();
            PrintStream origOut = System.out;
            URL expectedFileUrl = Resources.getResource((String)expectedOutputFilename);
            String outputFilename = this.workDir + File.separator + expectedOutputFilename;
            FileOutputStream myOut = new FileOutputStream(outputFilename);
            System.setOut(new PrintStream(myOut));
            FileDump.main((String[])new String[]{this.testFilePath.getName()});
            System.out.flush();
            System.setOut(origOut);
            TestFileDump.checkOutput(expectedFileUrl.getPath(), outputFilename);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntropyThreshold() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRecord.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Configuration conf = new Configuration();
            OrcConf.setFloatVar((Configuration)conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_ENTROPY_KEY_STRING_SIZE_THRESHOLD, (float)1.0f);
            OrcConf.setIntVar((Configuration)conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_ENTROPY_STRING_THRESHOLD, (int)11);
            OrcConf.setFloatVar((Configuration)conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_DICTIONARY_STRING_KEY_SIZE_THRESHOLD, (float)1.0f);
            WriterImpl writer = new WriterImpl(this.fs, this.testFilePath, conf, inspector, 100000L, CompressionKind.SNAPPY, 10000, 10000, new MemoryManager(conf));
            Random r1 = new Random(1L);
            for (int i = 0; i < 21000; ++i) {
                writer.addRow((Object)new MyRecord(r1.nextInt(), r1.nextLong(), Integer.toString(r1.nextInt())));
            }
            writer.close();
            PrintStream origOut = System.out;
            URL expectedFileUrl = Resources.getResource((String)"orc-file-dump-entropy-threshold.out");
            String outputFilename = this.workDir + File.separator + "orc-file-dump-entropy-threshold.out";
            FileOutputStream myOut = new FileOutputStream(outputFilename);
            System.setOut(new PrintStream(myOut));
            FileDump.main((String[])new String[]{this.testFilePath.getName()});
            System.out.flush();
            System.setOut(origOut);
            TestFileDump.checkOutput(expectedFileUrl.getPath(), outputFilename);
            return;
        }
    }

    @Test
    public void testDictionaryThreshold() throws Exception {
        Configuration conf = new Configuration();
        OrcConf.setFloatVar((Configuration)conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_DICTIONARY_STRING_KEY_SIZE_THRESHOLD, (float)0.49f);
        OrcConf.setFloatVar((Configuration)conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_DICTIONARY_NUMERIC_KEY_SIZE_THRESHOLD, (float)0.49f);
        this.testDictionary(conf, "orc-file-dump-dictionary-threshold.out");
    }

    @Test
    public void testUnsortedDictionary() throws Exception {
        Configuration conf = new Configuration();
        OrcConf.setFloatVar((Configuration)conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_DICTIONARY_STRING_KEY_SIZE_THRESHOLD, (float)0.49f);
        OrcConf.setFloatVar((Configuration)conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_DICTIONARY_NUMERIC_KEY_SIZE_THRESHOLD, (float)0.49f);
        OrcConf.setBoolVar((Configuration)conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_DICTIONARY_SORT_KEYS, (boolean)false);
        this.testDictionary(conf, "orc-file-dump-dictionary-threshold-unsorted.out");
    }

    @Test
    public void testUnsortedDictionary2() throws Exception {
        Configuration conf = new Configuration();
        OrcConf.setFloatVar((Configuration)conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_DICTIONARY_STRING_KEY_SIZE_THRESHOLD, (float)0.51f);
        OrcConf.setFloatVar((Configuration)conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_DICTIONARY_NUMERIC_KEY_SIZE_THRESHOLD, (float)0.51f);
        OrcConf.setBoolVar((Configuration)conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_DICTIONARY_SORT_KEYS, (boolean)false);
        this.testDictionary(conf, "orc-file-dump-dictionary-threshold-unsorted2.out");
    }

    static class MyRecord {
        int i;
        long l;
        String s;

        MyRecord(int i, long l, String s) {
            this.i = i;
            this.l = l;
            this.s = s;
        }
    }
}

