/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.CompressionCodec;
import com.facebook.hive.orc.CompressionKind;
import com.facebook.hive.orc.DynamicByteArray;
import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.OutStream;
import com.facebook.hive.orc.PositionRecorder;
import com.facebook.hive.orc.WriterImpl;
import com.facebook.hive.orc.ZlibCodec;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.junit.Test;

public class TestInStream {
    @Test
    public void testUncompressed() throws Exception {
        int i;
        int i2;
        OutputCollector collect = new OutputCollector();
        OutStream out = new OutStream("test", 100, null, (OutStream.OutputReceiver)collect);
        OrcProto.RowIndex.Builder rowIndex = OrcProto.RowIndex.newBuilder();
        OrcProto.RowIndexEntry.Builder rowIndexEntry = OrcProto.RowIndexEntry.newBuilder();
        WriterImpl.RowIndexPositionRecorder rowIndexPosition = new WriterImpl.RowIndexPositionRecorder(rowIndexEntry);
        for (i2 = 0; i2 < 1024; ++i2) {
            out.getPosition((PositionRecorder)rowIndexPosition);
            rowIndex.addEntry(rowIndexEntry.build());
            rowIndexEntry.clear();
            out.write(i2);
        }
        out.flush();
        Assert.assertEquals((int)1024, (int)collect.buffer.size());
        for (i2 = 0; i2 < 1024; ++i2) {
            Assert.assertEquals((byte)((byte)i2), (byte)collect.buffer.get(i2));
        }
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        InStream in = InStream.create((String)"test", (ByteBuffer)inBuf, null, (int)100);
        Assert.assertEquals((String)"uncompressed stream test base: 0 offset: 0 limit: 1024", (String)in.toString());
        for (i = 0; i < 1024; ++i) {
            int x = in.read();
            Assert.assertEquals((int)(i & 0xFF), (int)x);
        }
        in.loadIndeces(rowIndex.build().getEntryList(), 0);
        for (i = 1023; i >= 0; --i) {
            in.seek(i);
            Assert.assertEquals((int)(i & 0xFF), (int)in.read());
        }
    }

    @Test
    public void testCompressed() throws Exception {
        int i;
        OutputCollector collect = new OutputCollector();
        ZlibCodec codec = new ZlibCodec();
        OutStream out = new OutStream("test", 300, (CompressionCodec)codec, (OutStream.OutputReceiver)collect);
        OrcProto.RowIndex.Builder rowIndex = OrcProto.RowIndex.newBuilder();
        OrcProto.RowIndexEntry.Builder rowIndexEntry = OrcProto.RowIndexEntry.newBuilder();
        WriterImpl.RowIndexPositionRecorder rowIndexPosition = new WriterImpl.RowIndexPositionRecorder(rowIndexEntry);
        for (int i2 = 0; i2 < 1024; ++i2) {
            out.getPosition((PositionRecorder)rowIndexPosition);
            rowIndex.addEntry(rowIndexEntry.build());
            rowIndexEntry.clear();
            out.write(i2);
        }
        out.flush();
        Assert.assertEquals((String)"test", (String)out.toString());
        Assert.assertEquals((int)961, (int)collect.buffer.size());
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        InStream in = InStream.create((String)"test", (ByteBuffer)inBuf, (CompressionCodec)codec, (int)300);
        Assert.assertEquals((String)"compressed stream test base: 0 limit: 961 current stride: 1 compressed offset: 0", (String)in.toString());
        for (i = 0; i < 1024; ++i) {
            int x = in.read();
            Assert.assertEquals((int)(i & 0xFF), (int)x);
        }
        Assert.assertEquals((int)0, (int)in.available());
        in.loadIndeces(rowIndex.build().getEntryList(), 0);
        for (i = 1023; i >= 0; --i) {
            in.seek(i);
            Assert.assertEquals((int)(i & 0xFF), (int)in.read());
        }
    }

    @Test
    public void testCorruptStream() throws Exception {
        OutputCollector collect = new OutputCollector();
        ZlibCodec codec = new ZlibCodec();
        OutStream out = new OutStream("test", 500, (CompressionCodec)codec, (OutStream.OutputReceiver)collect);
        for (int i = 0; i < 1024; ++i) {
            out.write(i);
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        InStream in = InStream.create((String)"test", (ByteBuffer)inBuf, (CompressionCodec)codec, (int)100);
        byte[] contents = new byte[1024];
        try {
            in.read(contents);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        inBuf.clear();
        inBuf.put((byte)32);
        inBuf.put((byte)0);
        inBuf.flip();
        in = InStream.create((String)"test2", (ByteBuffer)inBuf, (CompressionCodec)codec, (int)300);
        try {
            in.read();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testBigFile() throws IOException {
        TestInputStream inputStream = new TestInputStream();
        TestFSDataInputStream stream = new TestFSDataInputStream(inputStream, 0x80000000L);
        InStream in = InStream.create((String)"testStram", (FSDataInputStream)stream, (long)0x80000000L, (int)32899, (CompressionCodec)WriterImpl.createCodec((CompressionKind)CompressionKind.ZLIB), (int)32896);
        in.read();
    }

    private static class TestInputStream
    extends InputStream
    implements Seekable,
    PositionedReadable {
        private TestInputStream() {
        }

        public long getPos() throws IOException {
            return 0L;
        }

        public void seek(long arg0) throws IOException {
        }

        public boolean seekToNewSource(long arg0) throws IOException {
            return false;
        }

        public int read(long arg0, byte[] arg1, int arg2, int arg3) throws IOException {
            return 0;
        }

        public void readFully(long arg0, byte[] arg1) throws IOException {
        }

        public void readFully(long arg0, byte[] arg1, int arg2, int arg3) throws IOException {
        }

        @Override
        public int read() throws IOException {
            return 1;
        }

        public List<ByteBuffer> readFullyScatterGather(long arg0, int arg1) throws IOException {
            return null;
        }
    }

    private static class TestFSDataInputStream
    extends FSDataInputStream {
        private final long expectedSeek;

        public TestFSDataInputStream(InputStream stream, long expectedSeek) throws IOException {
            super(stream);
            this.expectedSeek = expectedSeek;
        }

        public synchronized void seek(long desired) throws IOException {
            Assert.assertEquals((String)"Seeking by an unexpected amount", (long)this.expectedSeek, (long)desired);
        }
    }

    static class OutputCollector
    implements OutStream.OutputReceiver {
        DynamicByteArray buffer = new DynamicByteArray();

        OutputCollector() {
        }

        public void output(ByteBuffer buffer) throws IOException {
            this.buffer.add(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        }
    }
}

